/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.security;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.security.DefaultFilterInputStream;
import com.sap.ip.me.security.DefaultFilterOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;

public class StreamFactory {
    private static String SIGNING_IMPLEMENTOR;
    private static String UNSIGNING_IMPLEMENTOR;
    private static String ENCRYPTION_IMPLEMENTOR;
    private static String DECRYPTION_IMPLEMENTOR;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$io$InputStream;

    public static boolean isSigningSupported() {
        return SIGNING_IMPLEMENTOR != null && UNSIGNING_IMPLEMENTOR != null;
    }

    public static boolean isEncryptionSupported() {
        return ENCRYPTION_IMPLEMENTOR != null && DECRYPTION_IMPLEMENTOR != null;
    }

    public static OutputStream createSigningOutputStream(OutputStream out) {
        OutputStream result;
        if (SIGNING_IMPLEMENTOR == null) {
            result = new DefaultFilterOutputStream(out);
        } else {
            try {
                Class<?> clazz = Class.forName(SIGNING_IMPLEMENTOR);
                Constructor<?> constructor = clazz.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = StreamFactory.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                result = (OutputStream)constructor.newInstance(out);
            }
            catch (Exception e) {
                AppLog.getInstance("MI/Security").logException("Cannot create singning filter output stream; check decive configuration key MobileEngine.Security.FilterStreams.Signing", (Throwable)e, true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public static InputStream createUnsigningInputStream(InputStream in) {
        InputStream result;
        if (UNSIGNING_IMPLEMENTOR == null) {
            result = new DefaultFilterInputStream(in);
        } else {
            try {
                Class<?> clazz = Class.forName(UNSIGNING_IMPLEMENTOR);
                Constructor<?> constructor = clazz.getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = StreamFactory.class$("java.io.InputStream")) : class$java$io$InputStream);
                result = (InputStream)constructor.newInstance(in);
            }
            catch (Exception e) {
                AppLog.getInstance("MI/Security").logException("Cannot create unsingning filter output stream; check decive configuration key MobileEngine.Security.FilterStreams.Unsigning", (Throwable)e, true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public static OutputStream createEncryptionOutputStream(OutputStream out) {
        OutputStream result;
        if (ENCRYPTION_IMPLEMENTOR == null) {
            result = new DefaultFilterOutputStream(out);
        } else {
            try {
                Class<?> clazz = Class.forName(ENCRYPTION_IMPLEMENTOR);
                Constructor<?> constructor = clazz.getConstructor(class$java$io$OutputStream == null ? (class$java$io$OutputStream = StreamFactory.class$("java.io.OutputStream")) : class$java$io$OutputStream);
                result = (OutputStream)constructor.newInstance(out);
            }
            catch (Exception e) {
                AppLog.getInstance("MI/Security").logException("Cannot create encryption filter output stream; check decive configuration key MobileEngine.Security.FilterStreams.Encryption", (Throwable)e, true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public static InputStream createDecryptionInputStream(InputStream in) {
        InputStream result;
        if (DECRYPTION_IMPLEMENTOR == null) {
            result = new DefaultFilterInputStream(in);
        } else {
            try {
                Class<?> clazz = Class.forName(DECRYPTION_IMPLEMENTOR);
                Constructor<?> constructor = clazz.getConstructor(class$java$io$InputStream == null ? (class$java$io$InputStream = StreamFactory.class$("java.io.InputStream")) : class$java$io$InputStream);
                result = (InputStream)constructor.newInstance(in);
            }
            catch (Exception e) {
                AppLog.getInstance("MI/Security").logException("Cannot create decryption filter output stream; check decive configuration key MobileEngine.Security.FilterStreams.Decryption", (Throwable)e, true);
                throw new RuntimeException(e.getMessage());
            }
        }
        return result;
    }

    public static OutputStream createEncryptionSigningOutputStream(OutputStream out) {
        return StreamFactory.createEncryptionOutputStream(StreamFactory.createSigningOutputStream(out));
    }

    public static InputStream createUnsigningDecryptionInputStream(InputStream in) {
        return StreamFactory.createDecryptionInputStream(StreamFactory.createUnsigningInputStream(in));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Configuration config = Configuration.getInstance();
        SIGNING_IMPLEMENTOR = config.getProperty("MobileEngine.Security.FilterStreams.Signing");
        if (SIGNING_IMPLEMENTOR != null && SIGNING_IMPLEMENTOR.trim().length() == 0) {
            SIGNING_IMPLEMENTOR = null;
        }
        if ((ENCRYPTION_IMPLEMENTOR = config.getProperty("MobileEngine.Security.FilterStreams.Encryption")) != null && ENCRYPTION_IMPLEMENTOR.trim().length() == 0) {
            ENCRYPTION_IMPLEMENTOR = null;
        }
        if ((UNSIGNING_IMPLEMENTOR = config.getProperty("MobileEngine.Security.FilterStreams.Unsigning")) != null && UNSIGNING_IMPLEMENTOR.trim().length() == 0) {
            UNSIGNING_IMPLEMENTOR = null;
        }
        if ((DECRYPTION_IMPLEMENTOR = config.getProperty("MobileEngine.Security.FilterStreams.Decryption")) != null && DECRYPTION_IMPLEMENTOR.trim().length() == 0) {
            DECRYPTION_IMPLEMENTOR = null;
        }
    }
}

