/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBBigDecimalFormatter;
import com.sap.ip.me.persist.jdbc.DBBigIntegerFormatter;
import com.sap.ip.me.persist.jdbc.DBBinaryFormatter;
import com.sap.ip.me.persist.jdbc.DBBooleanFormatter;
import com.sap.ip.me.persist.jdbc.DBByteFormatter;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBConnectionManager;
import com.sap.ip.me.persist.jdbc.DBDateFormatter;
import com.sap.ip.me.persist.jdbc.DBDecimalFormatter;
import com.sap.ip.me.persist.jdbc.DBDoubleFormatter;
import com.sap.ip.me.persist.jdbc.DBEncryptionManager;
import com.sap.ip.me.persist.jdbc.DBFloatFormatter;
import com.sap.ip.me.persist.jdbc.DBIntegerFormatter;
import com.sap.ip.me.persist.jdbc.DBLongFormatter;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import com.sap.ip.me.persist.jdbc.DBSQLDateFormatter;
import com.sap.ip.me.persist.jdbc.DBSQLTimeFormatter;
import com.sap.ip.me.persist.jdbc.DBShortFormatter;
import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import com.sap.ip.me.persist.jdbc.DBStringFormatter;
import com.sap.ip.me.persist.jdbc.DBTableNotFoundSQLException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class SAPDBRepresentorImpl
extends DBRepresentor {
    private static final String TABLENOTFOUND = "42000";
    private static final int TABLEEXISTS = -6000;
    private static final int MAX_COUNT_OF_INDEXES = 16;
    private DBEncryptionManager encryptionMngr;
    private Hashtable hashFormatter = null;

    SAPDBRepresentorImpl(DBConnectionManager connectionMngr, DBEncryptionManager encryptionMngr) {
        super(connectionMngr);
        this.encryptionMngr = encryptionMngr;
        DBAttributeDescriptorImpl.setDBRepresentor(this);
        this.createFormatterHash();
    }

    public SQLException getVerifiedSQLException(SQLException e, String message) {
        if (e.getSQLState().equals(TABLENOTFOUND)) {
            return new DBTableNotFoundSQLException(message, e.getSQLState(), e.getErrorCode());
        }
        return e;
    }

    private String getCreateTableStatement(String tablename, DBAttributeDescriptor[] ads) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("CREATE TABLE ");
        sb.append(tablename);
        sb.append(" ( ");
        int i = 0;
        while (i < ads.length) {
            if (i > 0) {
                sb.append(" , ");
            }
            sb.append(ads[i].toMetaCreate());
            if (ads[i].isIndex()) {
                sb.append(" NOT NULL ");
            }
            ++i;
        }
        StringBuffer pkey_sb = new StringBuffer(20);
        int x = 0;
        int i2 = 0;
        while (i2 < ads.length) {
            if (ads[i2].isIndex()) {
                if (x > 0) {
                    pkey_sb.append(" , ");
                }
                pkey_sb.append(ads[i2].getColumnName());
                ++x;
            }
            ++i2;
        }
        if (x > 0) {
            sb.append(" , PRIMARY KEY( ");
            sb.append((Object)pkey_sb);
            sb.append(")");
        }
        sb.append(")");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getCreateTableStatement(String tablename, ClassDescriptorImpl cdes) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("CREATE TABLE ");
        sb.append(tablename);
        sb.append(" ( ");
        AttributeDescriptor[] descriptors = cdes.getAttributeDescriptorArray();
        int keyPos = cdes.getKeyAttributePosition();
        int i = 0;
        while (i < descriptors.length) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(((DBAttributeDescriptor)descriptors[i]).toMetaCreate());
            if (i == keyPos) {
                sb.append(" NOT NULL");
            }
            ++i;
        }
        int count = ((DBClassDescriptor)cdes).getSingleLinkCount();
        int j = 0;
        while (j < count) {
            sb.append(",link").append(j).append(" VARCHAR(128)");
            ++j;
        }
        sb.append(" , PRIMARY KEY( ");
        sb.append(((DBAttributeDescriptor)descriptors[keyPos]).getColumnName());
        sb.append(" ) )");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getCreateLinkIndexStatement(String tablename, ClassDescriptor cdes) {
        StringBuffer sb = new StringBuffer(200);
        sb.append("CREATE INDEX ");
        boolean existIndex = false;
        sb.append(tablename).append("_LINK_IDX ON ").append(tablename).append(" (");
        int linkCount = ((DBClassDescriptor)cdes).getSingleLinkCount();
        int j = 0;
        while (j < linkCount) {
            if (existIndex) {
                sb.append(',');
            } else {
                existIndex = true;
            }
            sb.append("link").append(j);
            ++j;
        }
        if (existIndex) {
            sb.append(')');
            String sqlStr = sb.toString();
            Trace.getInstance("MI/Persistence").log(90, sqlStr);
            return sqlStr;
        }
        return null;
    }

    private void executeCreateIndexStatements(String tablename, ClassDescriptor cdes) throws SQLException {
        AttributeDescriptor[] attDescriptors = cdes.getAttributeDescriptorArray();
        AttributeDescriptor key = cdes.getKeyAttributeDescriptor();
        int count = 0;
        int i = 0;
        while (i < attDescriptors.length) {
            if (attDescriptors[i].isIndex() && attDescriptors[i] != key) {
                ++count;
                StringBuffer sb = new StringBuffer(200);
                sb.append("CREATE INDEX ");
                sb.append(tablename).append("_IDX").append(i).append(" ON ").append(tablename).append(" (");
                if (attDescriptors[i].getMultiple() == 1) {
                    sb.append(((DBAttributeDescriptorImpl)attDescriptors[i]).getColumnName());
                } else {
                    int j = 0;
                    while (j < attDescriptors[i].getMultiple()) {
                        if (j > 0) {
                            sb.append(',');
                        }
                        sb.append(((DBAttributeDescriptorImpl)attDescriptors[i]).getColumnName(j));
                        ++j;
                    }
                }
                sb.append(")");
                ++count;
                String sqlString = sb.toString();
                Trace.getInstance("MI/Persistence").log(90, sqlString);
                this.executeAutoCommitUpdate(sqlString);
            }
            if (count >= 16) break;
            ++i;
        }
    }

    public void createTable(String tablename, ClassDescriptor cdes) throws SQLException {
        String createTableStatement = this.getCreateTableStatement(tablename, (ClassDescriptorImpl)cdes);
        this.executeAutoCommitUpdate(createTableStatement);
        this.executeCreateIndexStatements(tablename, cdes);
        String createLinkIndexStatement = this.getCreateLinkIndexStatement(tablename, cdes);
        if (createLinkIndexStatement != null) {
            this.executeAutoCommitUpdate(createLinkIndexStatement);
        }
    }

    public void createTable(String tablename, DBAttributeDescriptor[] ads) throws SQLException {
        String createTableStatement = this.getCreateTableStatement(tablename, ads);
        this.executeAutoCommitUpdate(createTableStatement);
    }

    public void dropTable(String tablename) throws SQLException {
        String dropTableStatement = this.getDropTableStatement(tablename);
        this.executeAutoCommitUpdate(dropTableStatement);
    }

    private String getDropTableStatement(String tablename) {
        StringBuffer sb = new StringBuffer(100);
        sb.append("DROP TABLE ").append(tablename);
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private void executeAutoCommitUpdate(String statement) throws SQLException {
        Connection dbConn = this.getConnection();
        dbConn.setAutoCommit(true);
        Statement dbStatement = dbConn.createStatement();
        try {
            dbStatement.executeUpdate(statement);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dbStatement.close();
            dbConn.setAutoCommit(false);
            throw throwable;
        }
        dbStatement.close();
        dbConn.setAutoCommit(false);
    }

    private final void createFormatterHash() {
        this.hashFormatter = new Hashtable();
        this.hashFormatter.put(AttributeType.BINARY, new DBBinaryFormatter(this));
        this.hashFormatter.put(AttributeType.BOOLEAN, new DBBooleanFormatter());
        this.hashFormatter.put(AttributeType.BYTE, new DBByteFormatter());
        this.hashFormatter.put(AttributeType.DATE, new DBDateFormatter());
        this.hashFormatter.put(AttributeType.DECIMAL, new DBDecimalFormatter());
        this.hashFormatter.put(AttributeType.DOUBLE, new DBDoubleFormatter());
        this.hashFormatter.put(AttributeType.FLOAT, new DBFloatFormatter());
        this.hashFormatter.put(AttributeType.INTEGER, new DBIntegerFormatter());
        this.hashFormatter.put(AttributeType.LONG, new DBLongFormatter());
        this.hashFormatter.put(AttributeType.SHORT, new DBShortFormatter());
        this.hashFormatter.put(AttributeType.STRING, new DBStringFormatter());
        this.hashFormatter.put(AttributeType.BIGDECIMAL, new DBBigDecimalFormatter());
        this.hashFormatter.put(AttributeType.BIGINTEGER, new DBBigIntegerFormatter());
        this.hashFormatter.put(AttributeType.SQLDATE, new DBSQLDateFormatter());
        this.hashFormatter.put(AttributeType.SQLTIME, new DBSQLTimeFormatter());
    }

    public DBSqlFormatter getFormatter(AttributeType type) {
        return (DBSqlFormatter)this.hashFormatter.get(type);
    }

    public boolean verifyTableExists(String tablename, DBAttributeDescriptor[] ads) throws SQLException {
        try {
            this.createTable(tablename, ads);
            return false;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -6000) {
                Trace.getInstance("MI/Persistence").log(70, "Link Table already exists");
                return true;
            }
            throw e;
        }
    }

    public void createBlobTable(String tablename, DBAttributeDescriptor[] ads) throws SQLException {
        try {
            StringBuffer sb = new StringBuffer(128);
            sb.append("create table ").append(tablename).append(" (");
            int i = 0;
            while (i < ads.length) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ads[i].toMetaCreate());
                if (i == 0) {
                    sb.append(" NOT NULL");
                }
                ++i;
            }
            sb.append(", BLOBJECT LONG BYTE, primary key (");
            sb.append(ads[0].getColumnName()).append("))");
            String sqlStr = sb.toString();
            Trace.getInstance("MI/Persistence").log(90, sqlStr);
            this.executeAutoCommitUpdate(sqlStr);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -6000) {
                Trace.getInstance("MI/Persistence").log(70, "BLOB Table already exists");
                return;
            }
            throw e;
        }
    }
}

