/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.DeviceConfiguration;
import com.sap.ip.me.persist.jdbc.DBManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import com.sap.ip.me.persist.jdbc.DBTableManager;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import com.sap.ip.me.persist.jdbc.SAPDBRepresentorImpl;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class SAPDBManager
extends DBManager {
    private static Connection connection;
    private static final String USER_PROP = "user";
    private static final String PASS_PROP = "password";
    private static final String RECONNECT_PROP = "reconnect";

    public Connection getConnection() throws SQLException {
        if (connection == null) {
            try {
                Class.forName(super.getDriverClassName()).newInstance();
            }
            catch (Throwable t) {
                throw new RuntimeException(t.toString());
            }
            String url = super.getDBUrl();
            String user = super.getUserName();
            String password = super.getPassword();
            connection = this.getConnection(url, user, password);
            DatabaseMetaData dbMeta = connection.getMetaData();
            StringBuffer temp = new StringBuffer(80);
            temp.append(dbMeta.getDatabaseProductName());
            temp.append(" ");
            temp.append(dbMeta.getDatabaseProductVersion());
            StringBuffer sb = new StringBuffer("Connected to Database: ");
            sb.append((Object)temp);
            sb.append(" JDBC ");
            sb.append(dbMeta.getDriverVersion());
            DeviceConfiguration.setInformation("DATABASE_FULLNAME", temp.toString());
            Trace.getInstance("MI/Persistence").log(70, sb.toString());
            connection.setAutoCommit(false);
        }
        return connection;
    }

    private Connection getConnection(String url, String user, String password) throws SQLException {
        Properties p = new Properties();
        ((Hashtable)p).put(USER_PROP, user);
        ((Hashtable)p).put(PASS_PROP, password);
        ((Hashtable)p).put(RECONNECT_PROP, "on");
        return DriverManager.getConnection(url, p);
    }

    public void closeConnection() throws SQLException {
        if (connection != null) {
            connection.close();
            connection = null;
            Trace.getInstance("MI/Persistence").log(70, "Connection to MaxDB was closed");
        }
    }

    protected DBPersistenceManager createConcreteTransactionManager(DBTableMap tableMap) {
        return new DBPersistenceManagerImpl(tableMap, this, this);
    }

    protected DBTableManager createTableAdmin() throws SQLException {
        return new DBTableManager(new SAPDBRepresentorImpl(this, this));
    }

    public Connection restoreConnection() throws SQLException {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                Trace.getInstance("MI/Persistence").logException(60, "Connection could not be closed", e, false);
            }
            connection = null;
        }
        return this.getConnection();
    }
}

