/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PackageEntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.Transaction;
import com.sap.ip.me.api.persist.core.TransactionManager;
import com.sap.ip.me.api.persist.core.TransactionType;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBEntityFactoryAdapter;
import com.sap.ip.me.persist.jdbc.DBEntityStore;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactoryImpl;
import com.sap.ip.me.persist.jdbc.DBPersistableEntityAdapter;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import com.sap.ip.me.persist.jdbc.DBPersistedObjectAdapter;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl;
import com.sap.ip.me.persist.jdbc.DBTransactionAdapter;
import java.util.Enumeration;
import java.util.Hashtable;

final class DBTransactionManagerAdapter
implements TransactionManager {
    private final DBPersistenceRuntimeImpl runtime;
    private final Hashtable entityFactories = new Hashtable(20);
    private DBTransactionAdapter currentTransaction;
    private DBEntityStoreFactoryImpl ioProvider = null;
    private Hashtable cds;
    private DBPersistenceManagerImpl persistenceManager;
    private Hashtable inUseList = new Hashtable(10);

    DBTransactionManagerAdapter(Hashtable cds, DBPersistenceRuntimeImpl runtime, DBPersistenceManagerImpl dbpm) throws PersistenceException {
        try {
            this.runtime = runtime;
            this.persistenceManager = dbpm;
            this.persistenceManager.registerEntityFactory(new DBEntityFactoryAdapter());
            this.ioProvider = this.persistenceManager.getStoreFactory();
            DBEntityStore.IS_LAZYLOAD = false;
            this.cds = cds;
        }
        catch (Throwable t) {
            if (t instanceof PersistenceException) {
                throw (PersistenceException)t;
            }
            throw new PersistenceException(t.toString());
        }
    }

    DBPersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    public void insert(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            this.persistenceManager.insert(this.entityToPersistableEntity(entity), treeOption);
            Object var5_4 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "insert Entity operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insert Entity operation");
    }

    public void insert(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            int x = 0;
            while (x < entity.length) {
                this.persistenceManager.insert(this.entityToPersistableEntity(entity[x]), treeOption);
                ++x;
            }
            Object var6_5 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "insert Entity[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insert Entity[] operation");
    }

    public void modify(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity);
            if (pent == null) {
                pent = this.ioProvider.getEntityStore(entity.getClasstype()).get(entity.getEntityKey(), treeOption);
            }
            entity.getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
            ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_MODIFY, treeOption);
            this.persistenceManager.modify(pent, treeOption);
            Object var6_5 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "modify Entity operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "modify Entity operation");
    }

    public void update(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            if (this.contains(entity.getEntityKey())) {
                PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity);
                if (pent == null) {
                    pent = this.ioProvider.getEntityStore(entity.getClasstype()).get(entity.getEntityKey(), treeOption);
                }
                entity.getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
                ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_MODIFY, treeOption);
                this.persistenceManager.modify(pent, treeOption);
            } else {
                this.persistenceManager.insert(this.entityToPersistableEntity(entity), treeOption);
            }
            Object var6_5 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "update Entity operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "update Entity operation");
    }

    public void update(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            int x = 0;
            while (x < entity.length) {
                if (this.contains(entity[x].getEntityKey())) {
                    PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity[x]);
                    if (pent == null) {
                        pent = this.ioProvider.getEntityStore(entity[x].getClasstype()).get(entity[x].getEntityKey(), treeOption);
                    }
                    entity[x].getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
                    ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_MODIFY, treeOption);
                    this.persistenceManager.update(pent, treeOption);
                } else {
                    this.persistenceManager.insert(this.entityToPersistableEntity(entity[x]), treeOption);
                }
                ++x;
            }
            Object var7_6 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "update Entity[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "update Entity[] operation");
    }

    public void modify(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            int x = 0;
            while (x < entity.length) {
                PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity[x]);
                if (pent == null) {
                    pent = this.ioProvider.getEntityStore(entity[x].getClasstype()).get(entity[x].getEntityKey(), treeOption);
                }
                entity[x].getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
                ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_MODIFY, treeOption);
                this.persistenceManager.modify(pent, treeOption);
                ++x;
            }
            Object var7_6 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "modify Entity[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "modify Entity[] operation");
    }

    public void delete(Entity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity);
            if (pent == null) {
                pent = this.ioProvider.getEntityStore(entity.getClasstype()).get(entity.getEntityKey(), treeOption);
            }
            entity.getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
            ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_CLEAN, treeOption);
            this.persistenceManager.delete(pent, treeOption);
            Object var6_5 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "delete Entity operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete Entity operation");
    }

    public void delete(Entity[] entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            int x = 0;
            while (x < entity.length) {
                PersistableEntity pent = DBEntityFactoryAdapter.getEntity(entity[x]);
                if (pent == null) {
                    pent = this.ioProvider.getEntityStore(entity[x].getClasstype()).get(entity[x].getEntityKey(), treeOption);
                }
                entity[x].getInstance((DBPersistedObjectAdapter)pent.getPersistedObject());
                ((DBPersistedObjectAdapter)pent.getPersistedObject()).setState(DBPersistedObject.STATE_CLEAN, treeOption);
                this.persistenceManager.delete(pent, treeOption);
                ++x;
            }
            Object var7_6 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "delete by Entity[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete by Entity[] operation");
    }

    public void delete(String entityKey, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            Entity entity = this.get(entityKey, treeOption);
            this.persistenceManager.delete(this.entityToPersistableEntity(entity), treeOption);
            Object var6_5 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "delete by entityKey operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete by entityKey operation");
    }

    public void delete(String[] entityKey, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            int x = 0;
            MeIterator entities = this.get(entityKey, TreeOptionType.SKELETON);
            while (entities.hasNext()) {
                Entity entity = this.get(entityKey[x], treeOption);
                this.persistenceManager.delete(this.entityToPersistableEntity((Entity)entities.next()), treeOption);
                ++x;
            }
            Object var8_7 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "delete by entityKey[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete by entityKey[] operation");
    }

    public MeIterator get(String[] entityKey, TreeOptionType tree) throws PersistenceException {
        MeIteratorArrayImpl meIteratorArrayImpl;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            Object[] result = new Entity[entityKey.length];
            int x = 0;
            while (x < entityKey.length) {
                result[x] = this.get(entityKey[x], tree);
                ++x;
            }
            meIteratorArrayImpl = new MeIteratorArrayImpl(result);
            Object var8_7 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "get by entityKey[] operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by entityKey[] operation");
        return meIteratorArrayImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(String entityKey) throws PersistenceException {
        boolean bl;
        Object perfLogTag;
        block4: {
            boolean bl2;
            perfLogTag = PerformanceLog.methodStarted(this);
            try {
                ClassDescriptor cd = null;
                DBEntityStore store = null;
                PersistableEntity pe = null;
                Enumeration it = this.cds.elements();
                do {
                    if (!it.hasMoreElements()) {
                        bl = false;
                        break block4;
                    }
                    cd = (ClassDescriptor)it.nextElement();
                } while ((pe = (store = this.persistenceManager.getEntityStoreFactory().getEntityStore(cd.getClasstype())).get(entityKey, TreeOptionType.SKELETON)) == null);
                bl2 = true;
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                PerformanceLog.methodFinished(perfLogTag, "contains entityKey operation");
                throw throwable;
            }
            PerformanceLog.methodFinished(perfLogTag, "contains entityKey operation");
            return bl2;
        }
        Object var9_10 = null;
        PerformanceLog.methodFinished(perfLogTag, "contains entityKey operation");
        return bl;
    }

    public boolean contains(String classtype, String entityKey) throws PersistenceException {
        return this.ioProvider.getEntityStore(classtype).contains(entityKey);
    }

    public Entity get(String classtype, String entityKey) throws PersistenceException {
        return this.get(entityKey, TreeOptionType.SKELETON);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Entity get(String entityKey, TreeOptionType tree) throws PersistenceException {
        Entity entity;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            ClassDescriptor cd = null;
            DBEntityStore store = null;
            PersistableEntity pe = null;
            Enumeration it = this.cds.elements();
            do {
                if (!it.hasMoreElements()) {
                    throw new PersistenceException("Entity with key " + entityKey + " does not exist");
                }
                cd = (ClassDescriptor)it.nextElement();
            } while ((pe = (store = this.persistenceManager.getEntityStoreFactory().getEntityStore(cd.getClasstype())).get(entityKey, tree)) == null);
            entity = this.persistableEntityToEntity(pe);
            Object var10_9 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "get by entityKey operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by entityKey operation");
        return entity;
    }

    public MeIterator get(Query query, TreeOptionType tree) throws PersistenceException {
        MeIteratorArrayImpl meIteratorArrayImpl;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            MeIterator toBeConverted = this.ioProvider.getEntityStore(query.getClasstype()).get(query, tree);
            Object[] arr = new Entity[toBeConverted.elementCount()];
            int i = 0;
            while (toBeConverted.hasNext()) {
                arr[i] = this.persistableEntityToEntity((PersistableEntity)toBeConverted.next());
                ++i;
            }
            meIteratorArrayImpl = new MeIteratorArrayImpl(arr);
            Object var9_8 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "get by Query operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by Query operation");
        return meIteratorArrayImpl;
    }

    public int getCount(Query query) throws PersistenceException {
        int n;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            n = this.ioProvider.getEntityStore(query.getClasstype()).getCount(query);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.methodFinished(perfLogTag, "getCount by Query operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getCount by Query operation");
        return n;
    }

    public MeIterator getAll(String classtype, TreeOptionType tree) throws PersistenceException {
        MeIteratorArrayImpl meIteratorArrayImpl;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            MeIterator toBeConverted = this.ioProvider.getEntityStore(classtype).getAll(TreeOptionType.COMPLETE);
            Object[] arr = new Entity[toBeConverted.elementCount()];
            int i = 0;
            while (toBeConverted.hasNext()) {
                arr[i] = this.persistableEntityToEntity((PersistableEntity)toBeConverted.next());
                ++i;
            }
            meIteratorArrayImpl = new MeIteratorArrayImpl(arr);
            Object var9_8 = null;
            this.inUseList.clear();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.inUseList.clear();
            PerformanceLog.methodFinished(perfLogTag, "getAll operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getAll operation");
        return meIteratorArrayImpl;
    }

    public void deleteAll(String classtype, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            MeIterator allEntity = this.getAll(classtype, treeOption);
            while (allEntity.hasNext()) {
                this.delete((Entity)allEntity.next(), treeOption);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PerformanceLog.methodFinished(perfLogTag, "deleteAll operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "deleteAll operation");
    }

    public Transaction begin(TransactionType type) throws PersistenceException {
        DBTransactionAdapter dBTransactionAdapter;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            if (this.currentTransaction != null) {
                throw new PersistenceException("nested transaction not supported by TransactionManager");
            }
            dBTransactionAdapter = this.currentTransaction = new DBTransactionAdapter(this, type);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.methodFinished(perfLogTag, "begin Transaction operation");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "begin Transaction operation");
        return dBTransactionAdapter;
    }

    public Transaction getTransaction() {
        return this.currentTransaction;
    }

    public void registerEntityFactory(PackageEntityFactory entityFactory) {
        String[] classtypes = entityFactory.getPersistenceMaster().getClasstypes();
        int x = 0;
        while (x < classtypes.length) {
            this.entityFactories.put(classtypes[x], entityFactory);
            ++x;
        }
    }

    void commit() throws PersistenceException {
        this.persistenceManager.commit();
        this.currentTransaction = null;
    }

    void rollback() throws PersistenceException {
        this.persistenceManager.rollback();
        this.currentTransaction = null;
    }

    Entity persistableEntityToEntity(PersistableEntity pe) throws PersistenceException {
        if (!this.inUseList.containsKey(pe.getPersistedObject().getKey())) {
            PackageEntityFactory entityFactory = (PackageEntityFactory)this.entityFactories.get(pe.getPersistedObject().getClasstype());
            DBPersistedObject po = (DBPersistedObject)pe.getPersistedObject();
            DBPersistedObjectAdapter poa = new DBPersistedObjectAdapter((ClassDescriptorImpl)entityFactory.getPersistenceMaster().getClassDescriptor(po.getClasstype()), po.getKey());
            DBPersistableEntityAdapter pea = new DBPersistableEntityAdapter(poa);
            poa.copyAttributes(po.getAttributes());
            poa.copyLinks(po.getLinks());
            Entity entity = entityFactory.createEntity(poa.getKey(), poa.getClasstype(), poa.getAttributes());
            this.inUseList.put(poa.getKey(), entity);
            entity.setInstance(poa);
            poa.setState(DBPersistedObject.STATE_CLEAN, TreeOptionType.SKELETON);
            return entity;
        }
        return (Entity)this.inUseList.get(pe.getPersistedObject().getKey());
    }

    PersistableEntity entityToPersistableEntity(Entity entity) throws PersistenceException {
        if (!this.inUseList.containsKey(entity.getEntityKey())) {
            PackageEntityFactory entityFactory = (PackageEntityFactory)this.entityFactories.get(entity.getClasstype());
            DBPersistedObjectAdapter po = new DBPersistedObjectAdapter((ClassDescriptorImpl)entityFactory.getPersistenceMaster().getClassDescriptor(entity.getClasstype()), entity.getEntityKey());
            DBPersistableEntityAdapter persistableEntity = DBEntityFactoryAdapter.getEntity(po);
            this.inUseList.put(entity.getEntityKey(), persistableEntity);
            entity.getInstance(po);
            return persistableEntity;
        }
        return (PersistableEntity)this.inUseList.get(entity.getEntityKey());
    }

    Entity getEntityFromFactory(String entityKey, String classtype, Object[] attrib) throws PersistenceException {
        PackageEntityFactory entityFactory = (PackageEntityFactory)this.entityFactories.get(classtype);
        if (entityFactory != null) {
            return entityFactory.createEntity(entityKey, classtype, attrib);
        }
        throw new PersistenceException("No EntityFactory registered for ClassType " + classtype);
    }

    ClassDescriptor getClassDescriptorForKey(String classtype) {
        return (ClassDescriptor)this.cds.get(classtype);
    }
}

