/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.persist.jdbc.DBBlobTable;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBLinkTableDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DBTableMap {
    private static final String EMPTY_LINK = "";
    private static final int IDX_TABNAME = 0;
    private static final int IDX_LNKNAME = 1;
    private static final int IDX_CLASSID = 2;
    private static final int IDX_CLSDESC = 3;
    private Hashtable map = new Hashtable();
    private DBLinkTableDescriptor linkDesc;
    private DBBlobTable blobTable;
    private String linkTabName;
    private String blobTableName;

    final String getTablename(DBClassDescriptor classDesc) {
        return this.getTablename(classDesc.getClasstype());
    }

    final String getTablename(String classType) {
        this.verfiyClassType(classType);
        return (String)((Object[])this.map.get(classType))[0];
    }

    final String getLinkTablename() {
        return this.linkTabName;
    }

    final void setBlobTable(DBBlobTable blobTab, String tableName) {
        this.blobTable = blobTab;
        this.blobTableName = tableName;
    }

    final DBBlobTable getBlobTable() {
        return this.blobTable;
    }

    final String getBlobTablename() {
        return this.blobTableName;
    }

    final Object getEntityIdentifiction(DBClassDescriptor classDesc) {
        return this.getEntityIdentifiction(classDesc.getClasstype());
    }

    final Object getEntityIdentifiction(String classType) {
        this.verfiyClassType(classType);
        return ((Object[])this.map.get(classType))[2];
    }

    final DBClassDescriptor getClassDescriptor(String classType) {
        this.verfiyClassType(classType);
        return (DBClassDescriptor)((Object[])this.map.get(classType))[3];
    }

    DBLinkTableDescriptor getLinkTableDescriptor(DBClassDescriptor classDesc) {
        return this.getLinkTableDescriptor(classDesc.getClasstype());
    }

    DBLinkTableDescriptor getLinkTableDescriptor(String classType) {
        this.verfiyClassType(classType);
        return this.linkDesc;
    }

    private final void verfiyClassType(String classType) {
        if (classType == null) {
            throw new NullPointerException("classType is null");
        }
        if (!this.map.containsKey(classType)) {
            throw new IllegalArgumentException("ClassDescriptor not found in TableMap");
        }
    }

    void setLinkTableDescriptor(DBLinkTableDescriptor linkTabDesc, String linkTableName) {
        if (linkTabDesc == null) {
            throw new NullPointerException("DBLinkTableDescriptor is null");
        }
        if (this.linkDesc != null) {
            throw new IllegalStateException("DBLinkTableDescriptor is already set");
        }
        this.linkDesc = linkTabDesc;
        this.linkTabName = linkTableName;
    }

    void add(DBClassDescriptor classDesc, String tableName, Object entityId) {
        this.add(classDesc, tableName, entityId, EMPTY_LINK);
    }

    void add(DBClassDescriptor classDesc, String tableName, Object entityId, String linkName) {
        if (classDesc == null) {
            throw new NullPointerException("ClassDescriptor is null");
        }
        if (tableName == null) {
            throw new NullPointerException("Table name is null");
        }
        if (entityId == null) {
            throw new NullPointerException("Entity identification is null");
        }
        if (linkName == null) {
            throw new NullPointerException("Link name is null");
        }
        if (linkName != EMPTY_LINK && this.linkDesc == null) {
            throw new IllegalStateException("link attributes are not set");
        }
        Object[] arr = new Object[]{tableName, linkName, entityId, classDesc};
        if (this.map.put(classDesc.getClasstype(), arr) != null) {
            throw new IllegalArgumentException("ClassDescriptor was already added to the TableMap classType=" + classDesc.getClasstype());
        }
    }

    void setLink(DBClassDescriptor classDesc, String linkName) {
        if (classDesc == null) {
            throw new NullPointerException("ClassDescriptor is null");
        }
        if (linkName == null) {
            throw new NullPointerException("Link name is null");
        }
        this.setLink(classDesc.getClasstype(), linkName);
    }

    void setLink(String classtype, String linkName) {
        this.verfiyClassType(classtype);
        ((Object[])this.map.get((Object)classtype))[1] = linkName;
    }

    boolean contains(DBClassDescriptor classDesc) {
        return this.contains(classDesc.getClasstype());
    }

    boolean contains(String classType) {
        return this.map.containsKey(classType);
    }

    boolean containsLink(DBClassDescriptor classDesc) {
        return this.containsLink(classDesc.getClasstype());
    }

    boolean containsLink(String classtype) {
        return this.map.get(classtype) != null && ((Object[])this.map.get(classtype))[1] != EMPTY_LINK;
    }

    final Enumeration getClassTypes() {
        return this.map.keys();
    }
}

