/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.persist.jdbc.DBBlobTableAdmin;
import com.sap.ip.me.persist.jdbc.DBBlobTableImpl;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassTableAdmin;
import com.sap.ip.me.persist.jdbc.DBClassTableItem;
import com.sap.ip.me.persist.jdbc.DBLinkAdmin;
import com.sap.ip.me.persist.jdbc.DBLinkTableAdmin;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DBTableManager {
    private static final String PHYS_TABNAME_PREFIX = "MI_";
    private static final String PHYS_LINK_TABNAME_PREFIX = "MI_L_";
    private static final String PHYS_BLOB_TABNAME_PREFIX = "MI_B_";
    private DBRepresentor dbrep;
    private Hashtable mapAdmins = new Hashtable();
    private Hashtable tableMaps = new Hashtable();
    private DBLinkTableAdmin linkTableAdmin;
    private DBBlobTableAdmin blobTableAdmin;

    public DBTableManager(DBRepresentor dbrep) throws SQLException {
        this.dbrep = dbrep;
    }

    DBTableMap getTableMap(String convId, Hashtable cds) throws SQLException {
        DBTableMap map;
        DBLinkAdmin linkAdmin = new DBLinkAdmin(cds);
        if (this.linkTableAdmin == null) {
            this.linkTableAdmin = new DBLinkTableAdmin(this.dbrep);
        }
        if (this.blobTableAdmin == null) {
            this.blobTableAdmin = new DBBlobTableAdmin(this.dbrep);
        }
        if (this.tableMaps.containsKey(convId)) {
            map = (DBTableMap)this.tableMaps.get(convId);
            this.dbrep.setCurrentBlobTable(map.getBlobTable());
        } else {
            map = new DBTableMap();
            map.setLinkTableDescriptor(linkAdmin.getLinkTableDescriptor(), this.getPhysicalLinkTablename(convId));
            linkAdmin.verifyLinkTable(this.dbrep, this.getPhysicalLinkTablename(convId));
            String blobTabName = this.getPhysicalBlobTablename(convId);
            DBBlobTableImpl blobTab = new DBBlobTableImpl(blobTabName, this.dbrep);
            map.setBlobTable(blobTab, blobTabName);
            this.dbrep.setCurrentBlobTable(blobTab);
            this.tableMaps.put(convId, map);
        }
        this.initializeTables(map, linkAdmin, convId, cds);
        return map;
    }

    private DBClassTableAdmin getClassTableAdmin(String convId) throws SQLException {
        if (this.mapAdmins.containsKey(convId)) {
            return (DBClassTableAdmin)this.mapAdmins.get(convId);
        }
        DBClassTableAdmin mapAdmin = new DBClassTableAdmin(this.dbrep, convId);
        this.mapAdmins.put(convId, mapAdmin);
        return mapAdmin;
    }

    void deleteAllDataForConversationId(String convId) throws SQLException {
        DBTableMap tableMap = (DBTableMap)this.tableMaps.remove(convId);
        if (tableMap != null) {
            this.linkTableAdmin.deleteTableName(convId);
            this.blobTableAdmin.deleteTableName(convId);
            this.dropTables(tableMap);
        }
        this.getClassTableAdmin(convId).deleteAllTableNames();
    }

    private void initializeTables(DBTableMap tablemap, DBLinkAdmin linkAdmin, String convId, Hashtable cds) throws SQLException {
        this.readTableMap(convId, cds, this.getClassTableAdmin(convId), tablemap);
        this.createTables(this.getClassTableAdmin(convId), linkAdmin, cds, tablemap);
    }

    private void dropTables(DBTableMap tableMap) throws SQLException {
        try {
            this.dropTable(tableMap.getLinkTablename());
            this.dropTable(tableMap.getBlobTablename());
        }
        catch (SQLException e) {
            Trace.getInstance("MI/Persistence").log(70, "No Linktable or Blobtable was dropped");
        }
        Enumeration enumeration = tableMap.getClassTypes();
        while (enumeration.hasMoreElements()) {
            String classtype = (String)enumeration.nextElement();
            this.dropTable(tableMap.getTablename(classtype));
        }
    }

    private void dropTable(String tablename) throws SQLException {
        if (tablename != null) {
            this.dbrep.dropTable(tablename);
        }
    }

    private int readTableMap(String convId, Hashtable cds, DBClassTableAdmin mapAdmin, DBTableMap tableMap) throws SQLException {
        int count = 0;
        Enumeration enumeration = mapAdmin.elements();
        while (enumeration.hasMoreElements()) {
            DBClassDescriptor cd;
            DBClassTableItem item = (DBClassTableItem)enumeration.nextElement();
            if (cds.containsKey(item.getClassType()) && !tableMap.contains(cd = (DBClassDescriptor)cds.get(item.getClassType()))) {
                if (item.isLinkAttached()) {
                    tableMap.add(cd, this.getPhysicalTablename(item.getId()), new Integer(item.getId()), this.getPhysicalLinkTablename(convId));
                } else {
                    tableMap.add(cd, this.getPhysicalTablename(item.getId()), new Integer(item.getId()));
                }
            }
            ++count;
        }
        return count;
    }

    private void createTables(DBClassTableAdmin classTableAdmin, DBLinkAdmin linkAdmin, Hashtable cds, DBTableMap map) throws SQLException {
        Enumeration enumeration = cds.elements();
        while (enumeration.hasMoreElements()) {
            DBClassDescriptor cd = (DBClassDescriptor)enumeration.nextElement();
            this.createTable(classTableAdmin, linkAdmin, cd, map);
        }
    }

    private void createTable(DBClassTableAdmin classTableAdmin, DBLinkAdmin linkAdmin, DBClassDescriptor cd, DBTableMap map) throws SQLException {
        boolean linkExists = linkAdmin.isReferenced(cd);
        if (!map.contains(cd)) {
            int tableno = classTableAdmin.insertTableName(cd.getClasstype(), linkExists);
            String physicalTablename = this.getPhysicalTablename(tableno);
            this.dbrep.createTable(physicalTablename, cd);
            map.add(cd, physicalTablename, new Integer(tableno), map.getLinkTablename());
        } else if (linkExists && !map.containsLink(cd)) {
            String physicalTablename = map.getTablename(cd);
            int tableno = this.getTableNo(physicalTablename);
            map.setLink(cd, map.getLinkTablename());
        }
    }

    private String getPhysicalTablename(int id) {
        return PHYS_TABNAME_PREFIX + Integer.toString(id);
    }

    private int getTableNo(String name) {
        if (!name.startsWith(PHYS_TABNAME_PREFIX)) {
            throw new IllegalArgumentException(name + " is not legal name");
        }
        return Integer.parseInt(name.substring(PHYS_TABNAME_PREFIX.length()));
    }

    String getPhysicalLinkTablename(String convId) throws SQLException {
        int tabindex = this.linkTableAdmin.getTableIndex(convId);
        if (tabindex < 0) {
            tabindex = this.linkTableAdmin.insertTableName(convId);
        }
        StringBuffer sb = new StringBuffer(PHYS_LINK_TABNAME_PREFIX);
        return sb.append(tabindex).toString();
    }

    String getPhysicalBlobTablename(String convId) throws SQLException {
        int tabindex = this.blobTableAdmin.getTableIndex(convId);
        if (tabindex < 0) {
            tabindex = this.blobTableAdmin.insertTableName(convId);
        }
        StringBuffer sb = new StringBuffer(PHYS_BLOB_TABNAME_PREFIX);
        return sb.append(tabindex).toString();
    }

    Hashtable _getTableMaps() {
        return this.tableMaps;
    }
}

