/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBlobTable;
import com.sap.ip.me.persist.jdbc.DBConnectionManager;
import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class DBRepresentor {
    private DBConnectionManager connectionMngr;
    private DBBlobTable blobTable;

    public abstract SQLException getVerifiedSQLException(SQLException var1, String var2);

    public abstract void createTable(String var1, ClassDescriptor var2) throws SQLException;

    public abstract void createTable(String var1, DBAttributeDescriptor[] var2) throws SQLException;

    public abstract void dropTable(String var1) throws SQLException;

    public abstract boolean verifyTableExists(String var1, DBAttributeDescriptor[] var2) throws SQLException;

    public abstract void createBlobTable(String var1, DBAttributeDescriptor[] var2) throws SQLException;

    public abstract DBSqlFormatter getFormatter(AttributeType var1);

    public DBRepresentor(DBConnectionManager connectionMngr) {
        this.connectionMngr = connectionMngr;
    }

    public DBBlobTable getBlobTable() {
        if (this.blobTable == null) {
            throw new RuntimeException("BLOB TABLE is null");
        }
        return this.blobTable;
    }

    public void setCurrentBlobTable(DBBlobTable blobTab) {
        this.blobTable = blobTab;
    }

    public ResultSet executeQuery(Statement statement, String statementStr) throws SQLException {
        return statement.executeQuery(statementStr);
    }

    public Statement getStatement() throws SQLException {
        return this.connectionMngr.getConnection().createStatement();
    }

    public void executeUpdate(String statementStr) throws SQLException {
        Statement statement = this.getStatement();
        try {
            statement.executeUpdate(statementStr);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    public Connection getConnection() throws SQLException {
        return this.connectionMngr.getConnection();
    }

    public void createSingleIndex(String tablename, DBAttributeDescriptor ads) throws SQLException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("CREATE INDEX ").append(tablename).append("_");
        sb.append(ads.getColumnName()).append(" ON ");
        sb.append(tablename).append(" (").append(ads.getColumnName()).append(")");
        String str = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sb.toString());
        this.executeUpdate(str);
    }
}

