/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TransactionManager;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MeLinkedList;
import com.sap.ip.me.core.MobileSolutionDescriptor;
import com.sap.ip.me.persist.core.PersistenceCleaner;
import com.sap.ip.me.persist.core.PersistenceManagerTXWrapper;
import com.sap.ip.me.persist.core.TransactionManagerTXWrapper;
import com.sap.ip.me.persist.jdbc.DBManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceException;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import com.sap.ip.me.persist.jdbc.DBTransactionManagerAdapter;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

public final class DBPersistenceRuntimeImpl
extends PersistenceRuntime
implements PersistenceCleaner {
    private static DBPersistenceRuntimeImpl INSTANCE = null;
    private static final String DBMANAGERCLASSNAME = "MobileEngine.Persist.Jdbc.DbManagerClass";
    private PersistenceManagerPool txManagerPool = new PersistenceManagerPool();
    private Hashtable persistenceMasters = new Hashtable();
    private DBManager dbManager;
    private DBTransactionManagerAdapter txManagerAdapter;

    public DBPersistenceRuntimeImpl() throws PersistenceException {
        if (INSTANCE != null) {
            Trace.getInstance("MI/Persistence").log(60, "Illegal State: DBPersistenceruntime was already instantiated");
            throw new IllegalStateException("DBPersistenceruntime was already instantiated");
        }
        INSTANCE = this;
    }

    public TransactionManager getTransactionManager(VisibilityType visibility) throws PersistenceException {
        ConversationId convId = ConversationIdHandler.getInstance().getCurrentConversationId(visibility);
        return this.getTransactionManager(convId);
    }

    public PersistenceManager getPersistenceManager(VisibilityType visibility) throws PersistenceException {
        ConversationId convId = ConversationIdHandler.getInstance().getCurrentConversationId(visibility);
        return this.getPersistenceManager(convId);
    }

    public TransactionManager getTransactionManager(String convIdStr) throws PersistenceException {
        ConversationId convId = ConversationIdHandler.getInstance().getConversationId(convIdStr);
        if (convId == null) {
            Trace.getInstance("MI/Persistence").log(50, "Illegal State: ConversationId not found for id: " + convIdStr);
            throw new IllegalStateException("ConversationId not found for id: " + convIdStr);
        }
        return this.getTransactionManager(convId);
    }

    private synchronized TransactionManager getTransactionManager(ConversationId convId) throws PersistenceException {
        DBPersistenceManagerImpl txManager = (DBPersistenceManagerImpl)this.txManagerPool.readCache(convId.getId());
        MobileSolutionDescriptor msd = convId.getMsd();
        Hashtable cds = (Hashtable)this.persistenceMasters.get(msd);
        if (cds == null) {
            throw new PersistenceException("No PackagePersistenceMaster registered for MobileSolutionDescriptor {0}", new Object[]{msd});
        }
        try {
            if (txManager == null) {
                txManager = (DBPersistenceManagerImpl)this.getDbManager().createTransactionManager(convId.getId(), cds);
            }
            this.txManagerAdapter = new DBTransactionManagerAdapter(cds, this, txManager);
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException("Persistence could not be started", (Throwable)e, false);
            throw new RuntimeException("Failed to generate TransactionManager Adapter");
        }
        this.txManagerPool.writeCache(convId.getId(), txManager);
        return new TransactionManagerTXWrapper(this.txManagerAdapter, this.txManagerAdapter.getTransaction());
    }

    public PersistenceManager getPersistenceManager(String convIdStr) throws PersistenceException {
        ConversationId convId = ConversationIdHandler.getInstance().getConversationId(convIdStr);
        if (convId == null) {
            throw new IllegalStateException("ConversationId not found for id: " + convIdStr);
        }
        return this.getPersistenceManager(convId);
    }

    private synchronized PersistenceManager getPersistenceManager(ConversationId convId) throws PersistenceException {
        DBPersistenceManager txManager = this.txManagerPool.readCache(convId.getId());
        if (txManager == null) {
            MobileSolutionDescriptor msd = convId.getMsd();
            Hashtable cds = (Hashtable)this.persistenceMasters.get(msd);
            if (cds == null) {
                throw new PersistenceException("No PackagePersistenceMaster registered for MobileSolutionDescriptor {0}", new Object[]{msd});
            }
            try {
                txManager = this.getDbManager().createTransactionManager(convId.getId(), cds);
            }
            catch (SQLException e) {
                this.processSQLException(e, msd.getName() + " sql");
                AppLog.getInstance("MI/Persistence").logException("Persistence could not be initialized for Application " + msd.getName(), (Throwable)e, false);
                throw new PersistenceException("Failed to generate PersistenceManager");
            }
            this.txManagerPool.writeCache(convId.getId(), txManager);
        }
        return new PersistenceManagerTXWrapper(txManager);
    }

    public void registerPersistenceMaster(PackagePersistenceMaster pm) throws PersistenceException {
        MobileSolutionDescriptor msd = ConversationIdHandler.getInstance().getCurrentConversationId().getMsd();
        this.registerPersistenceMaster(pm, msd);
    }

    private void adjustPersistenceManager(MobileSolutionDescriptor msd) throws PersistenceException {
        try {
            Enumeration enumeration = this.txManagerPool.convIds();
            while (enumeration.hasMoreElements()) {
                String convId = (String)enumeration.nextElement();
                ConversationId conv = ConversationIdHandler.getInstance().getConversationId(convId);
                if (conv != null) {
                    if (!conv.getMsd().equals(msd)) continue;
                    DBPersistenceManager pm = this.txManagerPool.readCache(convId);
                    this.getDbManager().setTableMap(pm, convId, (Hashtable)this.persistenceMasters.get(msd));
                    continue;
                }
                this.txManagerPool.removeCache(convId);
            }
        }
        catch (SQLException e) {
            this.processSQLException(e, "sql");
            throw new DBPersistenceException(e);
        }
    }

    private void registerPersistenceMaster(PackagePersistenceMaster pm, MobileSolutionDescriptor msd) throws PersistenceException {
        Hashtable cds = (Hashtable)this.persistenceMasters.get(msd);
        if (cds == null) {
            cds = new Hashtable();
            this.persistenceMasters.put(msd, cds);
        }
        this.fillClassDescriptors(cds, pm);
        this.adjustPersistenceManager(msd);
    }

    private Hashtable fillClassDescriptors(Hashtable cds, PackagePersistenceMaster ppm) {
        String[] classtypes = ppm.getClasstypes();
        int numberOfOld = 0;
        int numberOfNew = 0;
        int i = 0;
        while (i < classtypes.length) {
            if (!cds.containsKey(classtypes[i])) {
                cds.put(classtypes[i], ppm.getClassDescriptor(classtypes[i]));
                ++numberOfNew;
            } else {
                ++numberOfOld;
            }
            ++i;
        }
        if (Trace.getInstance("MI/Persistence").isLogging(90)) {
            Trace.getInstance("MI/Persistence").log(90, "PersistenceMaster " + ppm.hashCode() + " registration status: classytpes new/skipped/overall {0}/{1}/{2}", Integer.toString(numberOfNew), Integer.toString(numberOfOld), Integer.toString(cds.size()));
        }
        return cds;
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        Enumeration e = this.persistenceMasters.elements();
        while (e.hasMoreElements()) {
            Hashtable cds = (Hashtable)e.nextElement();
            ClassDescriptor cdes = (ClassDescriptor)cds.get(classtype);
            if (cdes == null) continue;
            return cdes;
        }
        return null;
    }

    public static void _resetInstance() {
        if (INSTANCE != null) {
            DBPersistenceRuntimeImpl.INSTANCE.persistenceMasters.clear();
            DBPersistenceRuntimeImpl.INSTANCE.txManagerPool.release();
            if (DBPersistenceRuntimeImpl.INSTANCE.dbManager != null) {
                try {
                    DBPersistenceRuntimeImpl.INSTANCE.dbManager.closeStatement();
                    DBPersistenceRuntimeImpl.INSTANCE.dbManager.closeConnection();
                }
                catch (SQLException e) {
                    DBPersistenceManagerImpl.processSQLException(e, "_resetInstance()");
                }
                DBPersistenceRuntimeImpl.INSTANCE.dbManager = null;
            }
        }
    }

    DBManager getDbManager() {
        if (this.dbManager == null) {
            String dbManagerClassName = Configuration.getInstance().getProperty(DBMANAGERCLASSNAME);
            if (dbManagerClassName == null) {
                throw new RuntimeException("Cannot startup PersistenceRuntime property MobileEngine.Persist.Jdbc.DbManagerClass not defined");
            }
            try {
                Class<?> clazz = Class.forName(dbManagerClassName);
                this.dbManager = (DBManager)clazz.newInstance();
            }
            catch (Exception e) {
                Trace.getInstance("MI/Persistence").logException("Error while creating Instance of DBManager", (Throwable)e, true);
                throw new RuntimeException("DatabaseManager could not be instantiated");
            }
        }
        return this.dbManager;
    }

    public void deleteAllDataForConversationId(ConversationId convId) throws PersistenceException {
        try {
            this.dbManager.deleteAllDataForConversationId(convId.getId());
            this.getDbManager().getConnection().commit();
        }
        catch (SQLException e) {
            this.processSQLException(e, "deleteAllDataForConvId");
            throw new DBPersistenceException(e);
        }
    }

    protected DBTransactionManagerAdapter getTransactionManagerAdapter() {
        return this.txManagerAdapter;
    }

    private final void processSQLException(SQLException sqe, String msg) {
        Trace.getInstance("MI/Persistence").logException(sqe, true);
        Trace.getInstance("MI/Persistence").log(msg + " - error code: {0} SQL state: {1}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState());
    }

    public void _reset() {
        this.persistenceMasters.clear();
        this.txManagerPool.release();
        if (this.dbManager != null) {
            try {
                try {
                    this.dbManager.closeStatement();
                    this.dbManager.closeConnection();
                }
                catch (SQLException e) {
                    DBPersistenceManagerImpl.processSQLException(e, "_resetInstance()");
                    Object var3_2 = null;
                    this.dbManager = null;
                }
                Object var3_1 = null;
                this.dbManager = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.dbManager = null;
                throw throwable;
            }
        }
    }

    private class PersistenceManagerPool {
        private Hashtable cache = new Hashtable(4);
        private MeLinkedList fifoList = new MeLinkedList();
        private static final int POOL_SIZE = 4;

        private PersistenceManagerPool() {
        }

        private void writeCache(String convid, DBPersistenceManager txManager) {
            if (4 > 0 && this.cache.size() == 4) {
                this.releaseOldestManager();
            }
            this.fifoList.addLast(convid);
            this.cache.put(convid, txManager);
        }

        private void releaseOldestManager() {
            String deleteKey = (String)this.fifoList.removeFirst();
            DBPersistenceManager txManagerToClose = this.readCache(deleteKey);
            this.removeCache(deleteKey);
        }

        private DBPersistenceManager readCache(String convid) {
            return (DBPersistenceManager)this.cache.get(convid);
        }

        private DBPersistenceManager removeCache(String convid) {
            return (DBPersistenceManager)this.cache.remove(convid);
        }

        void release() {
            while (this.cache.size() > 0) {
                this.releaseOldestManager();
            }
        }

        private Enumeration convIds() {
            return this.cache.keys();
        }
    }
}

