/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.core.PersistedObjectFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.persist.jdbc.DBConnectionDelegate;
import com.sap.ip.me.persist.jdbc.DBConnectionManager;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactoryImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryImpl;
import com.sap.ip.me.persist.jdbc.DBPersistedObjectFactory;
import com.sap.ip.me.persist.jdbc.DBPersistenceException;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.SQLException;

public final class DBPersistenceManagerImpl
extends DBPersistenceManager {
    private DBConnectionManager connectionMngr;
    private DBConnectionDelegate delegate;
    private final DBEntityStoreFactoryImpl entityStoreFactory;

    public DBPersistenceManagerImpl(DBTableMap tableNameMap, DBConnectionManager connectionMngr, DBConnectionDelegate delegate) {
        this.connectionMngr = connectionMngr;
        this.delegate = delegate;
        this.entityStoreFactory = new DBEntityStoreFactoryImpl(tableNameMap, delegate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws PersistenceException {
        if (this.errorFlag) {
            this.rollback();
            throw new PersistenceException("Commit() was called after errors in transaction. Transaction has been rolled back.");
        }
        if (this.commitList.size() <= 0) {
            Trace.getInstance("MI/Persistence").log(90, "commit() skipped due to no changes");
            return;
        }
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            try {
                this.connectionMngr.getConnection().commit();
                super.commit();
            }
            catch (SQLException e) {
                DBPersistenceManagerImpl.processSQLException(e, "commit()");
                throw new DBPersistenceException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            PerformanceLog.methodFinished(perfLogTag, "commit on persistence level");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "commit on persistence level");
    }

    public void rollback() throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            try {
                this.connectionMngr.getConnection().rollback();
                super.rollback();
            }
            catch (SQLException e) {
                this.errorFlag = false;
                DBPersistenceManagerImpl.processSQLException(e, "rollback()");
                throw new DBPersistenceException(e);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            PerformanceLog.methodFinished(perfLogTag, "rollback");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "rollback");
    }

    protected DBEntityStoreFactory getEntityStoreFactory() {
        return this.entityStoreFactory;
    }

    public void registerEntityFactory(EntityFactory factory) {
        this.entityStoreFactory.setEntityFactory(factory);
    }

    public boolean entityFactoryIsRegistered() {
        return this.entityStoreFactory.entityFactoryIsSet();
    }

    public PersistedObjectFactory getPersistedObjectFactory() {
        return DBPersistedObjectFactory.getInstance();
    }

    public void setTableMap(DBTableMap map) {
        this.entityStoreFactory.setTableMap(map);
    }

    protected DBEntityStoreFactoryImpl getStoreFactory() {
        return this.entityStoreFactory;
    }

    static final void processSQLException(SQLException sqe, String msg) {
        Trace.getInstance("MI/Persistence").logException(sqe, true);
        Trace.getInstance("MI/Persistence").log(msg + " - error code: {0} SQL state: {1}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params, int startIdx, int maxCount) throws PersistenceException {
        JQueryResult jQueryResult;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            try {
                jQueryResult = ((DBJQueryImpl)query).execute(this.connectionMngr.getConnection(), this.entityStoreFactory, params, startIdx, maxCount);
                Object var8_8 = null;
            }
            catch (SQLException e) {
                DBPersistenceManagerImpl.processSQLException(e, "Cannot get connection");
                throw new PersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            PerformanceLog.methodFinished(perfLogTag, "executeQuery");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "executeQuery");
        return jQueryResult;
    }

    public JQueryResult executeQuery(JQuery query, JQueryParameterSet params) throws PersistenceException {
        return this.executeQuery(query, params, 0, -1);
    }

    public JQueryResult executeQuery(JQuery query, int startIdx, int maxCount) throws PersistenceException {
        return this.executeQuery(query, null, startIdx, maxCount);
    }

    public JQueryResult executeQuery(JQuery query) throws PersistenceException {
        return this.executeQuery(query, null, 0, -1);
    }
}

