/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObjectFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.persist.jdbc.DBEntityStore;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.util.Enumeration;
import java.util.Vector;

public abstract class DBPersistenceManager
implements PersistenceManager {
    final Vector commitList = new Vector();
    boolean errorFlag = false;

    protected abstract DBEntityStoreFactory getEntityStoreFactory();

    public void insert(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        boolean success = false;
        try {
            DBEntityStore store = this.validate(entity, treeOption);
            store.insert(entity, treeOption);
            this.addStoreToCommitList(store);
            store.clearInUseList();
            success = true;
            Object var7_6 = null;
            this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.errorFlag = !success;
            PerformanceLog.methodFinished(perfLogTag, "insert");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insert");
    }

    public void update(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        boolean success = false;
        try {
            DBEntityStore store = this.validate(entity, treeOption);
            store.insertOrUpdate(entity, treeOption);
            this.addStoreToCommitList(store);
            store.clearInUseList();
            success = true;
            Object var7_6 = null;
            this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.errorFlag = !success;
            PerformanceLog.methodFinished(perfLogTag, "update");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "update");
    }

    public void modify(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        boolean success = false;
        try {
            DBEntityStore store = this.validate(entity, treeOption);
            store.update(entity, treeOption);
            this.addStoreToCommitList(store);
            store.clearInUseList();
            success = true;
            Object var7_6 = null;
            this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.errorFlag = !success;
            PerformanceLog.methodFinished(perfLogTag, "modify");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "modify");
    }

    public PersistableEntity get(ClassDescriptor desc, String entityKey) throws PersistenceException {
        PersistableEntity persistableEntity;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            persistableEntity = this.validate(desc).get(entityKey, TreeOptionType.SKELETON);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PerformanceLog.methodFinished(perfLogTag, "get by desc, key");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by desc, key");
        return persistableEntity;
    }

    public MeIterator get(Query query) throws PersistenceException {
        MeIterator meIterator;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            meIterator = this.validate(query).get(query, TreeOptionType.SKELETON);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.methodFinished(perfLogTag, "get by query");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by query");
        return meIterator;
    }

    public int getCount(Query query) throws PersistenceException {
        int n;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            n = this.validate(query).getCount(query);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.methodFinished(perfLogTag, "getCount");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getCount");
        return n;
    }

    public MeIterator getAll(ClassDescriptor desc) throws PersistenceException {
        MeIterator meIterator;
        Object perfLogTag = PerformanceLog.methodStarted(this);
        try {
            meIterator = this.validate(desc).getAll(TreeOptionType.SKELETON);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            PerformanceLog.methodFinished(perfLogTag, "getAll");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getAll");
        return meIterator;
    }

    public abstract void registerEntityFactory(EntityFactory var1);

    public void commit() throws PersistenceException {
        Enumeration enumeration = this.commitList.elements();
        while (enumeration.hasMoreElements()) {
            DBEntityStore store = (DBEntityStore)enumeration.nextElement();
            store.commit();
        }
        this.commitList.removeAllElements();
    }

    public void rollback() throws PersistenceException {
        Enumeration enumeration = this.commitList.elements();
        while (enumeration.hasMoreElements()) {
            DBEntityStore store = (DBEntityStore)enumeration.nextElement();
            store.rollback();
        }
        this.commitList.removeAllElements();
        this.errorFlag = false;
    }

    public void delete(PersistableEntity entity, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        boolean success = false;
        try {
            DBEntityStore store = this.validate(entity, treeOption);
            store.delete(entity, treeOption);
            this.addStoreToCommitList(store);
            store.clearInUseList();
            success = true;
            Object var7_6 = null;
            this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.errorFlag = !success;
            PerformanceLog.methodFinished(perfLogTag, "delete");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete");
    }

    public void deleteAll(ClassDescriptor cdes, TreeOptionType treeOption) throws PersistenceException {
        Object perfLogTag = PerformanceLog.methodStarted(this);
        boolean success = false;
        try {
            DBEntityStore store = this.validate(cdes, treeOption);
            store.deleteAll(treeOption);
            this.addStoreToCommitList(store);
            store.clearInUseList();
            success = true;
            Object var7_6 = null;
            this.errorFlag = !success;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.errorFlag = !success;
            PerformanceLog.methodFinished(perfLogTag, "deleteAll");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "deleteAll");
    }

    public abstract void setTableMap(DBTableMap var1);

    private final void addStoreToCommitList(DBEntityStore store) {
        if (!this.commitList.contains(store)) {
            this.commitList.addElement(store);
        }
    }

    public void beginTransaction(boolean doWait) throws PersistenceException {
        throw new PersistenceException("No direct access to DBPersistenceManager alowed");
    }

    private final DBEntityStore validate(Query query) throws PersistenceException {
        if (query == null) {
            throw new NullPointerException("query parameter");
        }
        return this.getEntityStoreFactory().getEntityStore(query.getClasstype());
    }

    private final DBEntityStore validate(ClassDescriptor cdes) throws PersistenceException {
        if (cdes == null) {
            throw new NullPointerException("PersistenceManager class descriptor parameter");
        }
        return this.getEntityStoreFactory().getEntityStore(cdes.getClasstype());
    }

    private final DBEntityStore validate(ClassDescriptor cdes, TreeOptionType option) throws PersistenceException {
        if (option == null) {
            throw new NullPointerException("PersistenceManager treeoptiontype parameter");
        }
        return this.validate(cdes);
    }

    private final DBEntityStore validate(PersistableEntity ent, TreeOptionType option) throws PersistenceException {
        if (option == null) {
            throw new NullPointerException("PersistenceManager treeoptiontype parameter");
        }
        if (ent == null) {
            throw new NullPointerException("PersistenceManager entity parameter");
        }
        if (ent.getPersistedObject() == null) {
            throw new NullPointerException("PersistableEntity parameter invalid (persisted object null) entity=" + ent.getClass().getName());
        }
        return this.getEntityStoreFactory().getEntityStore(ent.getPersistedObject().getClasstype());
    }

    public abstract PersistedObjectFactory getPersistedObjectFactory();

    public abstract boolean entityFactoryIsRegistered();

    public abstract JQueryResult executeQuery(JQuery var1, int var2, int var3) throws PersistenceException;

    public abstract JQueryResult executeQuery(JQuery var1) throws PersistenceException;

    public abstract JQueryResult executeQuery(JQuery var1, JQueryParameterSet var2, int var3, int var4) throws PersistenceException;

    public abstract JQueryResult executeQuery(JQuery var1, JQueryParameterSet var2) throws PersistenceException;
}

