/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.core.PersistedObjectFactory;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import java.util.Hashtable;

public final class DBPersistedObjectFactory
implements PersistedObjectFactory {
    private static final DBPersistedObjectFactory INSTANCE = new DBPersistedObjectFactory();
    private final Hashtable factories = new Hashtable();

    public static final DBPersistedObjectFactory getInstance() {
        return INSTANCE;
    }

    public PersistenceContainer createPersistedObject(ClassDescriptor descripto, String key) {
        if (!(descripto instanceof DBClassDescriptorImpl)) {
            throw new IllegalArgumentException("ClassDescriptor is from type " + descripto.getClass().getName());
        }
        return new DBPersistedObject((DBClassDescriptor)descripto, key);
    }

    public PersistenceContainer createPersistedObject(PersistenceContainer persistedObject, String key) {
        this.validatePersistedObjectType(persistedObject);
        return ((DBPersistedObject)persistedObject).copy(key);
    }

    public PersistenceContainer createPersistedObject(PersistenceContainer persistedObject) {
        this.validatePersistedObjectType(persistedObject);
        return ((DBPersistedObject)persistedObject).copy();
    }

    private void validatePersistedObjectType(PersistenceContainer po) {
        if (!(po instanceof DBPersistedObject)) {
            throw new IllegalArgumentException("PersistedObject is from type " + po.getClass().getName());
        }
    }
}

