/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBEntityFactoryAdapter;
import com.sap.ip.me.persist.jdbc.DBLinkEntry;
import com.sap.ip.me.persist.jdbc.DBPersistableEntityAdapter;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl;
import java.util.Vector;

class DBPersistedObjectAdapter
extends DBPersistedObject
implements PersistedObject {
    DBPersistedObjectAdapter(ClassDescriptorImpl classDesc, String key) {
        super(classDesc, key);
    }

    final void insert() {
        if (this.state != DBPersistedObject.STATE_NEW) {
            throw new IllegalStateException("call DBPersistedObject.insert() with state=" + this.state);
        }
        this.state = DBPersistedObject.STATE_INSERT;
    }

    final void update() {
        if (this.state == DBPersistedObject.STATE_MODIFY) {
            this.state = DBPersistedObject.STATE_UPDATE;
        } else if (this.state == DBPersistedObject.STATE_CLEAN) {
            this.state = DBPersistedObject.STATE_CLEAN;
        } else {
            throw new IllegalStateException("call DBPersistedObject.update() with state=" + this.state);
        }
    }

    final void delete() {
        if (this.state == DBPersistedObject.STATE_NEW || this.state == DBPersistedObject.STATE_INSERT) {
            this.state = DBPersistedObject.STATE_REMOVE;
        } else if (this.state == DBPersistedObject.STATE_CLEAN || this.state == DBPersistedObject.STATE_MODIFY || this.state == DBPersistedObject.STATE_UPDATE) {
            this.state = DBPersistedObject.STATE_DELETE;
        } else {
            throw new IllegalStateException("call DBPersistedObject.delete() with state=" + this.state);
        }
    }

    private final void stateModify() {
        if (this.state == DBPersistedObject.STATE_CLEAN || this.state == DBPersistedObject.STATE_UPDATE || this.state == DBPersistedObject.STATE_MODIFY || this.state == DBPersistedObject.STATE_INSERT) {
            this.state = DBPersistedObject.STATE_MODIFY;
        } else if (this.state == DBPersistedObject.STATE_NEW) {
            this.state = DBPersistedObject.STATE_NEW;
        } else {
            throw new IllegalStateException("call DBPersistedObject.stateModify() with state=" + this.state);
        }
    }

    private final void stateClean() {
        if (this.state != DBPersistedObject.STATE_NEW && this.state != DBPersistedObject.STATE_CLEAN) {
            throw new IllegalStateException("call stateClean with state=" + this.state);
        }
        this.state = DBPersistedObject.STATE_CLEAN;
    }

    public Object getAttribute(int idx) {
        if (this.getEntity() instanceof DBPersistableEntityAdapter) {
            this.validateAtttributeIndex(idx);
        } else {
            this.validateSingleAttribute(idx, false);
            if (this.attributes[idx] == null) {
                AttributeDescriptor ad = this.classDesc.getAttributeDescriptor(idx);
                this.attributes[idx] = ad.getType().getDefaultValue(ad.getLength(), ad.getDecimals());
            }
        }
        return this.attributes[idx];
    }

    public void setAttribute(int idx, Object obj) {
        if (obj instanceof Object[]) {
            if (this.getEntity() instanceof DBPersistableEntityAdapter) {
                int i = this.classDesc.getAttributeDescriptor(idx).getMultiple();
                this.setAllMultipleAttributeValues(idx, i, (Object[])obj);
            }
        } else {
            this.validateAttributeType(idx, obj);
            this.stateModify();
            this.attributes[idx] = obj;
        }
    }

    void copyAttributes(Object[] attribs) {
        this.attributes = attribs;
    }

    void copyLinks(Object[] copy) {
        this.links = copy;
    }

    protected void setState(Object state, TreeOptionType option) {
        this.state = state;
        if (option.equals(TreeOptionType.COMPLETE)) {
            int i = 0;
            while (i < this.links.length) {
                if (this.links[i] instanceof Vector) {
                    Vector multilink = (Vector)this.links[i];
                    int x = 0;
                    while (x < multilink.size()) {
                        DBPersistedObject.LinkEntry link = (DBPersistedObject.LinkEntry)multilink.elementAt(x);
                        link.setStatus(DBLinkEntry.LSTAT_CLEAN);
                        DBPersistedObjectAdapter linkPo = (DBPersistedObjectAdapter)link.getEntity().getPersistedObject();
                        linkPo.setState(state, option);
                        ++x;
                    }
                } else {
                    ((DBPersistedObject.LinkEntry)this.links[i]).setStatus(DBLinkEntry.LSTAT_CLEAN);
                }
                ++i;
            }
        }
    }

    public Object[] getAttributes() {
        return this.attributes;
    }

    public PersistenceOperationType getOperation() {
        if (this.state.equals(DBPersistedObject.STATE_INSERT) || this.state.equals(DBPersistedObject.STATE_NEW)) {
            return PersistenceOperationType.INSERT;
        }
        if (this.state.equals(DBPersistedObject.STATE_MODIFY) || this.state.equals(DBPersistedObject.STATE_UPDATE)) {
            return PersistenceOperationType.MODIFY;
        }
        if (this.state.equals(DBPersistedObject.STATE_DELETE)) {
            return PersistenceOperationType.DELETE;
        }
        return PersistenceOperationType.NOOPER;
    }

    public String getEntityKey() {
        return super.getKey();
    }

    public Object getLink(int idx) {
        if (this.isMultipleLink(idx)) {
            Vector<Entity> linkVector = new Vector<Entity>();
            MeIterator it = this.getMultipleLink(idx);
            while (it.hasNext()) {
                PersistableEntity entityToConvert = (PersistableEntity)it.next();
                linkVector.addElement(this.getEntityFromFactory(entityToConvert));
            }
            return linkVector;
        }
        PersistableEntity entityToConvert = this.getSingleLink(idx);
        return this.getEntityFromFactory(entityToConvert);
    }

    private Object getLinkAsLinkEntry(int idx) {
        if (this.isMultipleLink(idx)) {
            return (Vector)this.links[idx];
        }
        return (DBPersistedObject.LinkEntry)this.links[idx];
    }

    private Entity getEntityFromFactory(PersistableEntity pe) {
        Entity entity = null;
        DBPersistedObject po = (DBPersistedObject)pe.getPersistedObject();
        try {
            DBPersistenceRuntimeImpl runtime = (DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance();
            entity = runtime.getTransactionManagerAdapter().getEntityFromFactory(po.getKey(), po.getClasstype(), po.getAttributes());
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Persistence").logException(50, e);
        }
        return entity;
    }

    public Object[] getLinks() {
        Object[] convertedLinks = new Object[this.links.length];
        int i = 0;
        while (i < this.links.length) {
            convertedLinks[i] = this.getLinkAsLinkEntry(i);
            ++i;
        }
        return convertedLinks;
    }

    public boolean isPersistent() {
        return this.state.equals(DBPersistedObject.STATE_CLEAN);
    }

    public void setAttributes(Object[] objects) {
        int i = 1;
        while (i <= objects.length) {
            if (this.sizeAttribute(i) > 1) {
                this.setAttribute(i, this.sizeAttribute(i), objects[i]);
            } else {
                this.setAttribute(i, objects[i]);
            }
            ++i;
        }
    }

    public void setLinks(Object[] objects) throws PersistenceException {
        int i = 0;
        while (i < objects.length) {
            boolean isMultiple;
            boolean bl = isMultiple = this.classDesc.getLinkDescriptor(i).getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR;
            if (isMultiple) {
                this.setLink(i, (Vector)objects[i]);
            } else {
                this.setLink(i, (Entity)objects[i]);
            }
            ++i;
        }
    }

    public void setLink(int idx, Entity link) {
        this.setSingleLink(idx, DBEntityFactoryAdapter.getEntity(link));
    }

    public void setLink(int idx, String linkKey) {
        this.setSingleLink(idx, DBEntityFactoryAdapter.getEntity(linkKey));
    }

    public void setLink(int idx, Vector link) throws PersistenceException {
        if (link != null) {
            if (this.links[idx] == null) {
                int i = 0;
                while (i < link.size()) {
                    DBPersistableEntityAdapter entity = DBEntityFactoryAdapter.getEntity((Entity)link.elementAt(i));
                    this.addMultipleLink(idx, entity);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < link.size()) {
                    DBPersistableEntityAdapter entity = DBEntityFactoryAdapter.getEntity((Entity)link.elementAt(i));
                    if (this.notContainsLink((Vector)this.links[idx], entity.getEntityKey())) {
                        this.setMultipleLink(idx, i, entity);
                    }
                    ++i;
                }
            }
        } else {
            throw new PersistenceException("Tried to set multiple link with null Vector. Linked Entities do not exist.");
        }
    }

    private void setAllMultipleAttributeValues(int idx, int mult, Object[] obj) {
        int i = 0;
        while (i < mult) {
            this.setAttribute(idx, i, obj[i]);
            ++i;
        }
    }

    private boolean notContainsLink(Vector vec, String key) {
        int i = 0;
        int max = vec.size();
        while (i < max) {
            if (key.equals(((DBPersistedObject.LinkEntry)vec.elementAt(i)).getEntity().getPersistedObject().getKey())) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

