/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBBinaryAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBlobHandle;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBLazyLoadDelegate;
import com.sap.ip.me.persist.jdbc.DBLinkEntry;
import java.util.Vector;

class DBPersistedObject
implements PersistenceContainer {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Boolean[] EMPTY_BOOLEAN = new Boolean[0];
    private static final Vector EMPTY_VECTOR = new Vector(1);
    static final Object STATE_NEW = new String("ST_NEW");
    static final Object STATE_CLEAN = new String("ST_CLN");
    static final Object STATE_MODIFY = new String("ST_MOD");
    static final Object STATE_INSERT = new String("ST_INS");
    static final Object STATE_UPDATE = new String("ST_UPD");
    static final Object STATE_DELETE = new String("ST_DEL");
    static final Object STATE_REMOVE = new String("ST_RMV");
    static final Object STATE_INVALID = new String("ST_INV");
    final ClassDescriptorImpl classDesc;
    private Vector deletionList = null;
    private DBLazyLoadDelegate delegate;
    private boolean hasBlobs = false;
    Object[] attributes;
    Object[] links;
    Boolean[] isLoaded;
    Object state = STATE_NEW;
    private final int keyPos;
    private DBPersistedObject anchor = null;
    private boolean inLookup = false;
    private PersistableEntity entity = null;

    DBPersistedObject(ClassDescriptorImpl classDesc, Object key) {
        if (classDesc == null) {
            throw new NullPointerException("classDescriptor is null");
        }
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.classDesc = classDesc;
        this.attributes = this.createInitialValueArray(classDesc.getAttributeDescriptorArray().length);
        this.keyPos = classDesc.getKeyAttributePosition();
        this.attributes[this.keyPos] = key;
        this.links = DBPersistedObject.createValueArray(classDesc.getLinkDescriptorArray().length);
        this.isLoaded = DBPersistedObject.createLazyLoadArray(this.links.length);
    }

    private static final Object[] createValueArray(int size) {
        if (size > 0) {
            return new Object[size];
        }
        return EMPTY_ARRAY;
    }

    private final Object[] createInitialValueArray(int size) {
        if (size > 0) {
            Object[] atts = new Object[size];
            int i = 0;
            while (i < size) {
                AttributeDescriptor att = this.classDesc.getAttributeDescriptorArray()[i];
                int mult = att.getMultiple();
                if (mult > 1) {
                    atts[i] = new Object[mult];
                    int j = 0;
                    while (j < mult) {
                        ((Object[])atts[i])[j] = att.getType().getDefaultValue(att.getLength(), att.getDecimals());
                        ++j;
                    }
                } else {
                    atts[i] = att.getType().getDefaultValue(att.getLength(), att.getDecimals());
                }
                ++i;
            }
            return atts;
        }
        return EMPTY_ARRAY;
    }

    private static final Boolean[] createLazyLoadArray(int size) {
        Boolean[] arr = EMPTY_BOOLEAN;
        if (size > 0) {
            arr = new Boolean[size];
            int i = 0;
            while (i < size) {
                arr[i] = Boolean.FALSE;
                ++i;
            }
        }
        return arr;
    }

    final void setLazyLoadDelegate(DBLazyLoadDelegate delegate) {
        this.delegate = delegate;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DBPersistedObject) {
            DBPersistedObject that = (DBPersistedObject)obj;
            return this.classDesc == that.classDesc && this.attributes[this.keyPos].equals(that.attributes[that.keyPos]);
        }
        return false;
    }

    Object[] getAttributes() {
        return this.attributes;
    }

    Object[] getLinks() {
        return this.links;
    }

    final Object getState() {
        return this.state;
    }

    void insert() {
        if (this.state != STATE_NEW) {
            throw new IllegalStateException("call DBPersistedObject.insert() with state=" + this.state);
        }
        this.state = STATE_INSERT;
    }

    void update() {
        if (this.state == STATE_MODIFY) {
            this.state = STATE_UPDATE;
        } else if (this.state == STATE_CLEAN) {
            this.state = STATE_CLEAN;
        } else {
            throw new IllegalStateException("call DBPersistedObject.update() with state=" + this.state);
        }
    }

    void delete() {
        if (this.state == STATE_NEW || this.state == STATE_INSERT) {
            this.state = STATE_REMOVE;
        } else if (this.state == STATE_CLEAN || this.state == STATE_MODIFY || this.state == STATE_UPDATE) {
            this.state = STATE_DELETE;
        } else {
            throw new IllegalStateException("call DBPersistedObject.delete() with state=" + this.state);
        }
        if (this.hasBlobs) {
            this.deleteAllBlobs();
        }
    }

    private final void stateModify() {
        if (this.state == STATE_CLEAN || this.state == STATE_UPDATE || this.state == STATE_MODIFY || this.state == STATE_INSERT) {
            this.state = STATE_MODIFY;
        } else if (this.state == STATE_NEW) {
            this.state = STATE_NEW;
        } else {
            throw new IllegalStateException("call DBPersistedObject.stateModify() with state=" + this.state);
        }
    }

    private final void stateClean() {
        if (this.state != STATE_NEW && this.state != STATE_CLEAN) {
            throw new IllegalStateException("call stateClean with state=" + this.state);
        }
        this.state = STATE_CLEAN;
    }

    final void commit() {
        if (this.state == STATE_CLEAN || this.state == STATE_INSERT || this.state == STATE_UPDATE) {
            this.state = STATE_CLEAN;
        } else if (this.state == STATE_DELETE || this.state == STATE_REMOVE) {
            this.state = STATE_INVALID;
        } else if (this.state == STATE_MODIFY) {
            if (Trace.getInstance("MI/Persistence").isOn()) {
                StringBuffer str = new StringBuffer(128);
                str.append("DBPersistedObject.commit() with STATE_MODIFY was called. Object stays dirty: ");
                str.append(this.getClasstype());
                str.append("/KEY ");
                str.append(this.attributes[this.keyPos].toString());
                Trace.getInstance("MI/Persistence").log(60, str.toString());
            }
        } else {
            throw new IllegalStateException("call DBPersistedObject.commit() with state=" + this.state);
        }
        int i = 0;
        int max = this.links.length;
        while (i < max) {
            if (this.links[i] instanceof Vector) {
                Vector vec = (Vector)this.links[i];
                int k = 0;
                int kmax = vec.size();
                while (k < kmax) {
                    ((LinkEntry)vec.elementAt(k)).commit();
                    ++k;
                }
            } else if (this.links[i] != null) {
                ((LinkEntry)this.links[i]).commit();
            }
            ++i;
        }
    }

    final void rollback() {
        this.state = STATE_INVALID;
        int i = 0;
        int max = this.links.length;
        while (i < max) {
            if (this.links[i] instanceof Vector) {
                Vector vec = (Vector)this.links[i];
                int k = 0;
                int kmax = vec.size();
                while (k < kmax) {
                    ((LinkEntry)vec.elementAt(k)).rollback();
                    ++k;
                }
            } else if (this.links[i] != null) {
                ((LinkEntry)this.links[i]).rollback();
            }
            ++i;
        }
    }

    public final void setEntity(PersistableEntity entity) {
        this.entity = entity;
    }

    final PersistableEntity getEntity() {
        return this.entity;
    }

    final DBPersistedObject getAnchor() {
        if (this.anchor == null) {
            return this;
        }
        return this.anchor.getAnchor();
    }

    final void setAnchor(DBPersistedObject po) {
        this.anchor = po;
    }

    private final void removeAnchor() {
        this.anchor = null;
    }

    final DBPersistedObject lookupPersistedObject(String key, DBClassDescriptor cdes) {
        DBPersistedObject po = null;
        if (!this.inLookup) {
            this.inLookup = true;
            if (this.attributes[this.keyPos].equals(key) && this.classDesc.equals(cdes)) {
                po = this;
            }
            int i = 0;
            int max = this.links.length;
            while (po == null && i < max) {
                MeIterator it = this.getLinkEntries(i);
                while (po == null && it.hasNext()) {
                    PersistableEntity ent = ((DBLinkEntry)it.next()).getEntity();
                    po = ((DBPersistedObject)ent.getPersistedObject()).lookupPersistedObject(key, cdes);
                }
                ++i;
            }
            this.inLookup = false;
        }
        return po;
    }

    public String getClasstype() {
        return this.classDesc.getClasstype();
    }

    public String getKey() {
        return this.attributes[this.keyPos].toString();
    }

    public Object getAttribute(int idx) {
        return this.internalGetAttribute(idx, false);
    }

    Object internalGetAttribute(int idx, boolean internalCall) {
        this.validateSingleAttribute(idx, false);
        if (this.attributes[idx] instanceof DBBlobHandle && !internalCall) {
            return ((DBBlobHandle)this.attributes[idx]).getBytes();
        }
        return this.attributes[idx];
    }

    public void setAttribute(int idx, Object obj) {
        this.validateSingleAttribute(idx, true);
        this.validateAttributeType(idx, obj);
        this.stateModify();
        if (this.classDesc.getAttributeDescriptorArray()[idx].getType() == AttributeType.BINARY) {
            if (this.attributes[idx] instanceof DBBlobHandle) {
                ((DBBlobHandle)this.attributes[idx]).update((byte[])obj);
                return;
            }
            DBBinaryAttributeDescriptor attDesc = (DBBinaryAttributeDescriptor)((Object)this.classDesc.getAttributeDescriptor(idx));
            obj = attDesc.toBlobHandle((byte[])obj, this.classDesc.getClasstype());
            this.hasBlobs = true;
        }
        this.attributes[idx] = obj;
    }

    final void loadAttribute(int idx, Object obj) {
        this.validateSingleAttribute(idx, false);
        this.validateAttributeType(idx, obj);
        this.stateClean();
        this.attributes[idx] = obj;
    }

    public Object getAttribute(int idx, int m) {
        return this.internalGetAttribute(idx, m, false);
    }

    Object internalGetAttribute(int idx, int m, boolean internalCall) {
        this.validateMultipleAtttribute(idx, m);
        return this.checkForInitializedAttribute(idx, m, internalCall);
    }

    public void setAttribute(int idx, int m, Object obj) {
        this.validateMultipleAtttribute(idx, m);
        this.validateAttributeType(idx, obj);
        if (this.attributes[idx] == null) {
            this.attributes[idx] = new Object[this.classDesc.getAttributeDescriptor(idx).getMultiple()];
        }
        this.stateModify();
        if (this.classDesc.getAttributeDescriptorArray()[idx].getType() == AttributeType.BINARY) {
            if (((Object[])this.attributes[idx])[m] instanceof DBBlobHandle) {
                ((DBBlobHandle)((Object[])this.attributes[idx])[m]).update((byte[])obj);
            } else {
                DBBinaryAttributeDescriptor attDesc = (DBBinaryAttributeDescriptor)((Object)this.classDesc.getAttributeDescriptor(idx));
                obj = attDesc.toBlobHandle((byte[])obj, this.classDesc.getClasstype());
                this.hasBlobs = true;
            }
        }
        ((Object[])this.attributes[idx])[m] = obj;
    }

    final void loadAttribute(int idx, int m, Object obj) {
        this.validateMultipleAtttribute(idx, m);
        this.validateAttributeType(idx, obj);
        if (this.attributes[idx] == null) {
            this.attributes[idx] = new Object[this.classDesc.getAttributeDescriptor(idx).getMultiple()];
        }
        this.stateClean();
        ((Object[])this.attributes[idx])[m] = obj;
    }

    public final int sizeAttribute() {
        return this.attributes.length;
    }

    public final int sizeAttribute(int idx) {
        this.validateAtttributeIndex(idx);
        return this.classDesc.getAttributeDescriptor(idx).getMultiple();
    }

    protected final void validateSingleAttribute(int idx, boolean checkKey) {
        if (checkKey && this.keyPos == idx && this.attributes[idx] != null) {
            throw new IllegalArgumentException("Invalid index for this operation, this attribute contains the key which may only be set once: " + idx);
        }
        this.validateAtttributeIndex(idx);
        if (this.classDesc.getAttributeDescriptor(idx).getMultiple() != 1) {
            throw new IllegalArgumentException("attribute index is not a single attribute idx=" + idx);
        }
    }

    protected final void validateMultipleAtttribute(int idx, int m) {
        this.validateAtttributeIndex(idx);
        int mult = this.classDesc.getAttributeDescriptor(idx).getMultiple();
        if (mult <= 1) {
            throw new IllegalArgumentException("attribute index is not a multiple attribute idx=" + idx);
        }
        if (m < 0 || m >= mult) {
            throw new IndexOutOfBoundsException("multiple index is out of bound m=" + m + " max=" + mult);
        }
    }

    protected final void validateAtttributeIndex(int idx) {
        if (idx < 0 || idx >= this.attributes.length) {
            throw new IndexOutOfBoundsException("attribute index=" + idx + " max=" + this.attributes.length);
        }
    }

    protected final void validateAttributeType(int idx, Object obj) {
        if (obj == null) {
            return;
        }
        if (!this.classDesc.getAttributeDescriptor(idx).getType().isValidType(obj)) {
            if (obj instanceof DBBlobHandle) {
                this.hasBlobs = true;
                return;
            }
            String type = obj == null ? "null" : obj.getClass().getName();
            throw new IllegalArgumentException("value type is invalid type=" + type);
        }
    }

    private Object checkForInitializedAttribute(int idx, int m, boolean internal) {
        if (((Object[])this.attributes[idx])[m] instanceof DBBlobHandle && !internal) {
            return ((DBBlobHandle)((Object[])this.attributes[idx])[m]).getBytes();
        }
        return ((Object[])this.attributes[idx])[m];
    }

    public PersistableEntity getSingleLink(int idx) {
        this.validateSingleLinkAndLoad(idx);
        return this.links[idx] == null ? null : ((LinkEntry)this.links[idx]).getEntity();
    }

    public void setSingleLink(int idx, PersistableEntity link) {
        this.validateSingleLinkAndLoad(idx);
        this.validateEntity(idx, link);
        String key = link.getPersistedObject().getKey();
        if (this.links[idx] == null) {
            this.links[idx] = new LinkEntry(idx, link, true);
            return;
        }
        if (((LinkEntry)this.links[idx]).getStatus() == DBLinkEntry.LSTAT_NEW) {
            ((LinkEntry)this.links[idx]).setEntity(link);
            return;
        }
        if (link.getPersistedObject().getKey().equals(((LinkEntry)this.links[idx]).getEntity().getPersistedObject().getKey())) {
            ((LinkEntry)this.links[idx]).setEntity(link);
            return;
        }
        this.addToDeletionList((LinkEntry)this.links[idx]);
        this.links[idx] = new LinkEntry(idx, link, true);
    }

    public void removeSingleLink(int idx) {
        this.validateSingleLinkAndLoad(idx);
        this.addToDeletionList((LinkEntry)this.links[idx]);
        this.links[idx] = null;
    }

    final void loadSingleLink(int idx, PersistableEntity link) {
        if (link == null) {
            return;
        }
        this.validateSingleLink(idx);
        this.validateEntity(idx, link);
        this.links[idx] = new LinkEntry(idx, link, false);
    }

    final DBLinkEntry getSimpleLinkEntry(int idx) {
        this.validateSingleLink(idx);
        return (DBLinkEntry)this.links[idx];
    }

    public PersistableEntity getMultipleLink(int idx, int m) {
        this.validateMultipleLinkAndLoad(idx, m);
        return ((LinkEntry)((Vector)this.links[idx]).elementAt(m)).getEntity();
    }

    public MeIterator getMultipleLink(int idx) {
        this.validateMultipleLinkAndLoad(idx);
        return new MultipleLinkIterator(idx);
    }

    public void setMultipleLink(int idx, int m, PersistableEntity link) {
        this.validateMultipleLinkAndLoad(idx, m);
        this.validateEntity(idx, link);
        this.validateEntityKey((Vector)this.links[idx], m, link.getPersistedObject().getKey());
        LinkEntry le = (LinkEntry)((Vector)this.links[idx]).elementAt(m);
        if (le.getStatus() == DBLinkEntry.LSTAT_NEW) {
            le.setEntity(link);
            return;
        }
        if (link.getPersistedObject().getKey().equals(le.getEntity().getPersistedObject().getKey())) {
            le.setEntity(link);
            return;
        }
        this.addToDeletionList(le);
        ((Vector)this.links[idx]).setElementAt(new LinkEntry(idx, link, true), m);
    }

    public void addMultipleLink(int idx, PersistableEntity link) {
        this.validateMultipleLinkAndLoad(idx);
        this.validateEntity(idx, link);
        if (this.links[idx] == null) {
            this.links[idx] = new Vector();
        } else {
            this.validateEntityKey((Vector)this.links[idx], -1, link.getPersistedObject().getKey());
        }
        ((Vector)this.links[idx]).addElement(new LinkEntry(idx, link, true));
    }

    public void removeMultipleLink(int idx, int m) {
        this.validateMultipleLinkAndLoad(idx, m);
        this.addToDeletionList((LinkEntry)((Vector)this.links[idx]).elementAt(m));
        ((Vector)this.links[idx]).removeElementAt(m);
    }

    public void removeAllMultipleLink(int idx) {
        this.validateMultipleLinkAndLoad(idx);
        if (this.links[idx] != null) {
            Vector vec = (Vector)this.links[idx];
            while (vec.size() > 0) {
                this.removeMultipleLink(idx, 0);
            }
            this.links[idx] = null;
        }
    }

    final void loadMultipleLink(int idx, PersistableEntity[] vec) {
        this.validateMultipleLink(idx);
        if (this.links[idx] != null) {
            throw new IllegalStateException("loadMultipleLinks detect already set link entries idx=" + idx);
        }
        Vector<LinkEntry> list = new Vector<LinkEntry>();
        String classType = this.classDesc.getLinkDescriptor(idx).getClasstype();
        int i = 0;
        int max = vec.length;
        while (i < max) {
            if (!classType.equals(vec[i].getPersistedObject().getClasstype())) {
                throw new IllegalArgumentException("loadMultipleLink: classtype is valid type" + vec[i].getPersistedObject().getClasstype());
            }
            this.validateEntityKey(list, -1, vec[i].getPersistedObject().getKey());
            list.addElement(new LinkEntry(idx, vec[i], false));
            ++i;
        }
        this.links[idx] = list;
    }

    final DBLinkEntry getMultipleLinkEntry(int idx, int m) {
        this.validateMultipleLink(idx, m);
        return (DBLinkEntry)((Vector)this.links[idx]).elementAt(m);
    }

    public boolean isMultipleLink(int idx) {
        this.validateLinkIndex(idx);
        return this.classDesc.getLinkDescriptor(idx).getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR;
    }

    public int sizeLink() {
        return this.links.length;
    }

    public int sizeLink(int idx) {
        this.validateLinkIndex(idx);
        if (!this.isMultipleLink(idx)) {
            this.validateSingleLinkAndLoad(idx);
            return this.links[idx] == null ? 0 : 1;
        }
        this.validateMultipleLinkAndLoad(idx);
        return this.links[idx] == null ? 0 : ((Vector)this.links[idx]).size();
    }

    final Vector getDeletedLinkEntries() {
        return this.deletionList != null ? this.deletionList : EMPTY_VECTOR;
    }

    final void clearDeletionList() {
        if (this.deletionList != null) {
            this.deletionList.removeAllElements();
        }
    }

    private final void addToDeletionList(LinkEntry entry) {
        if (entry != null) {
            ((DBPersistedObject)entry.getEntity().getPersistedObject()).removeAnchor();
            if (entry.getStatus() == DBLinkEntry.LSTAT_CLEAN) {
                if (this.deletionList == null) {
                    this.deletionList = new Vector();
                }
                this.deletionList.addElement(entry);
            }
        }
    }

    final MeIterator getLinkEntries(int idx) {
        this.validateLinkIndex(idx);
        return this.isMultipleLink(idx) ? new MultipleLinkEntryIterator(idx) : new SingleLinkEntryIterator(idx);
    }

    private final void validateEntityKey(Vector vec, int skip, String key) {
        int i = 0;
        int max = vec.size();
        while (i < max) {
            if (i != skip && key.equals(((LinkEntry)vec.elementAt(i)).getEntity().getPersistedObject().getKey())) {
                throw new IllegalArgumentException("entity key is already available key=" + key);
            }
            ++i;
        }
    }

    private final void validateEntity(int idx, PersistableEntity ent) {
        if (ent == null) {
            throw new NullPointerException("entity parameter");
        }
        if (ent.getPersistedObject() == null) {
            throw new NullPointerException("entity has no PersistedObject");
        }
        if (!this.classDesc.getLinkDescriptor(idx).getClasstype().equals(ent.getPersistedObject().getClasstype())) {
            throw new IllegalArgumentException("link entity has wrong type=" + ent.getPersistedObject().getClasstype());
        }
    }

    private final void validateSingleLinkAndLoad(int idx) {
        this.validateSingleLink(idx);
        if (this.delegate != null && this.isLoaded[idx] == Boolean.FALSE) {
            this.loadSingleLink(idx, this.delegate.fetchSingleLink(idx, this));
            this.isLoaded[idx] = Boolean.TRUE;
        }
    }

    private final void validateSingleLink(int idx) {
        this.validateLinkIndex(idx);
        if (this.classDesc.getLinkDescriptor(idx).getMultiplicity() != MultiplicityType.SINGLE) {
            throw new IllegalArgumentException("link multiplicity type is not simple");
        }
    }

    final void validateMultipleLinkAndLoad(int idx) {
        this.validateMultipleLink(idx);
        if (this.delegate != null && this.isLoaded[idx] == Boolean.FALSE) {
            this.loadMultipleLink(idx, this.delegate.fetchMultipleLink(idx, this));
            this.isLoaded[idx] = Boolean.TRUE;
        }
    }

    private final void validateMultipleLink(int idx) {
        this.validateLinkIndex(idx);
        if (this.classDesc.getLinkDescriptor(idx).getMultiplicity() != MultiplicityType.MULTIPLE_VECTOR) {
            throw new IllegalArgumentException("link multiplicity type is not multiple");
        }
    }

    final void validateMultipleLinkAndLoad(int idx, int m) {
        this.validateMultipleLinkAndLoad(idx);
        Vector vec = (Vector)this.links[idx];
        if (vec == null || m < 0 || m >= vec.size()) {
            throw new IndexOutOfBoundsException("mult link idx=" + m + " max=" + (vec == null ? 0 : vec.size()));
        }
    }

    private final void validateMultipleLink(int idx, int m) {
        this.validateMultipleLink(idx);
        Vector vec = (Vector)this.links[idx];
        if (vec == null || m < 0 || m >= vec.size()) {
            throw new IndexOutOfBoundsException("mult link idx=" + m + " max=" + (vec == null ? 0 : vec.size()));
        }
    }

    private final void validateLinkIndex(int idx) {
        if (idx < 0 || idx >= this.links.length) {
            throw new IndexOutOfBoundsException("link index=" + idx + " max=" + this.links.length);
        }
    }

    DBPersistedObject copy(Object key) {
        DBPersistedObject po = new DBPersistedObject(this.classDesc, key);
        boolean isClone = !key.equals(this.attributes[this.keyPos]);
        po.delegate = this.delegate;
        po.anchor = this.anchor;
        po.hasBlobs = this.hasBlobs;
        po.state = STATE_NEW;
        int i = 0;
        int max = po.attributes.length;
        while (i < max) {
            if (i != this.classDesc.getKeyAttributePosition()) {
                if (this.attributes[i] instanceof Object[]) {
                    po.attributes[i] = new Object[this.attributes.length];
                    System.arraycopy(this.attributes, 0, po.attributes, 0, this.attributes.length);
                } else {
                    po.attributes[i] = this.attributes[i];
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.isLoaded.length) {
            po.isLoaded[i2] = new Boolean(true);
            ++i2;
        }
        if (!isClone && this.deletionList != null) {
            po.deletionList = new Vector();
            int i3 = 0;
            int max2 = this.deletionList.size();
            while (i3 < max2) {
                po.deletionList.addElement(((LinkEntry)this.deletionList.elementAt(i3)).copy(false));
                ++i3;
            }
        }
        return po;
    }

    DBPersistedObject copy() {
        return this.copy(this.attributes[this.keyPos]);
    }

    void deleteAllBlobs() {
        int i = 0;
        int max = this.attributes.length;
        while (i < max) {
            if (this.attributes[i] instanceof Object[]) {
                int j = 0;
                int m = ((Object[])this.attributes[i]).length;
                while (j < m) {
                    if (((Object[])this.attributes[i])[j] instanceof DBBlobHandle) {
                        ((DBBlobHandle)((Object[])this.attributes[i])[j]).delete();
                        ++j;
                        continue;
                    }
                    break;
                }
            } else if (this.attributes[i] instanceof DBBlobHandle) {
                ((DBBlobHandle)this.attributes[i]).delete();
            }
            ++i;
        }
    }

    class MultipleLinkEntryIterator
    implements MeIterator {
        private final int idxLink;
        private int idx = 0;

        MultipleLinkEntryIterator(int idxLink) {
            this.idxLink = idxLink;
        }

        public boolean hasNext() {
            return this.idx < this.elementCount();
        }

        public Object next() {
            return DBPersistedObject.this.getMultipleLinkEntry(this.idxLink, this.idx++);
        }

        public int elementCount() {
            return DBPersistedObject.this.links[this.idxLink] == null ? 0 : ((Vector)DBPersistedObject.this.links[this.idxLink]).size();
        }

        public void reset() {
            this.idx = 0;
        }
    }

    class SingleLinkEntryIterator
    implements MeIterator {
        private final int idxLink;
        private boolean canRead;

        SingleLinkEntryIterator(int idxLink) {
            this.idxLink = idxLink;
            this.reset();
        }

        public boolean hasNext() {
            return this.canRead;
        }

        public Object next() {
            this.canRead = false;
            return DBPersistedObject.this.getSimpleLinkEntry(this.idxLink);
        }

        public int elementCount() {
            DBPersistedObject.this.validateLinkIndex(this.idxLink);
            return DBPersistedObject.this.links[this.idxLink] == null ? 0 : 1;
        }

        public void reset() {
            this.canRead = this.elementCount() == 1;
        }
    }

    class MultipleLinkIterator
    implements MeIterator {
        private final int idxLink;
        private int idx = 0;

        MultipleLinkIterator(int idxLink) {
            this.idxLink = idxLink;
        }

        public boolean hasNext() {
            return this.idx < DBPersistedObject.this.sizeLink(this.idxLink);
        }

        public Object next() {
            return DBPersistedObject.this.getMultipleLink(this.idxLink, this.idx++);
        }

        public int elementCount() {
            return DBPersistedObject.this.sizeLink(this.idxLink);
        }

        public void reset() {
            this.idx = 0;
        }
    }

    class LinkEntry
    implements DBLinkEntry {
        private final int index;
        private Object status;
        private PersistableEntity entity;

        LinkEntry(int index, PersistableEntity entity, boolean isNew) {
            this(index, entity, isNew ? DBLinkEntry.LSTAT_NEW : DBLinkEntry.LSTAT_CLEAN);
        }

        private LinkEntry(int index, PersistableEntity entity, Object status) {
            this.index = index;
            this.status = status;
            this.entity = entity;
        }

        public final int getIndex() {
            return this.index;
        }

        public final Object getStatus() {
            return this.status;
        }

        final void setStatus(Object status) {
            this.status = status;
        }

        public final PersistableEntity getEntity() {
            return this.entity;
        }

        public Object getForeignKey() {
            return this.entity.getPersistedObject().getKey();
        }

        public void delete() {
            if (this.status == DBLinkEntry.LSTAT_NEW || this.status == DBLinkEntry.LSTAT_INSERT) {
                this.status = DBLinkEntry.LSTAT_REMOVE;
            } else if (this.status == DBLinkEntry.LSTAT_CLEAN) {
                this.status = DBLinkEntry.LSTAT_DELETE;
            } else {
                throw new IllegalStateException("call DBEntryLink delete with status=" + this.status);
            }
        }

        public void persist() {
            if (this.status == DBLinkEntry.LSTAT_NEW) {
                this.status = DBLinkEntry.LSTAT_INSERT;
            } else if (this.status == DBLinkEntry.LSTAT_CLEAN) {
                this.status = DBLinkEntry.LSTAT_CLEAN;
            } else {
                throw new IllegalStateException("call DBEntryLink persist with status=" + this.status);
            }
        }

        public void commit() {
            if (this.status == DBLinkEntry.LSTAT_CLEAN || this.status == DBLinkEntry.LSTAT_INSERT) {
                this.status = DBLinkEntry.LSTAT_CLEAN;
            } else if (this.status == DBLinkEntry.LSTAT_DELETE || this.status == DBLinkEntry.LSTAT_REMOVE) {
                this.status = DBLinkEntry.LSTAT_INVALID;
            } else {
                throw new IllegalStateException("call DBLinkEntry.commit() with status=" + this.status);
            }
        }

        public void rollback() {
            if (this.status == DBLinkEntry.LSTAT_CLEAN || this.status == DBLinkEntry.LSTAT_DELETE) {
                this.status = DBLinkEntry.LSTAT_CLEAN;
            } else if (this.status == DBLinkEntry.LSTAT_INSERT || this.status == DBLinkEntry.LSTAT_REMOVE || this.status == DBLinkEntry.LSTAT_NEW) {
                this.status = DBLinkEntry.LSTAT_NEW;
            } else {
                throw new IllegalStateException("call DBLinkEntry.rollback() with status=" + this.status);
            }
        }

        final void setEntity(PersistableEntity entity) {
            if (this.entity.getPersistedObject() != entity.getPersistedObject()) {
                this.entity = entity;
            }
        }

        final LinkEntry copy(boolean isClone) {
            return new LinkEntry(this.index, this.entity, !isClone ? this.status : DBLinkEntry.LSTAT_NEW);
        }
    }
}

