/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl;
import com.sap.ip.me.persist.jdbc.DBTransactionManagerAdapter;

final class DBPersistableEntityAdapter
implements PersistableEntity,
Entity {
    private static DBTransactionManagerAdapter tmAdapter = ((DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance()).getTransactionManagerAdapter();
    private PersistenceContainer pc = null;
    private PersistedObject po = null;

    protected DBPersistableEntityAdapter(PersistenceContainer pc) {
        tmAdapter = ((DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance()).getTransactionManagerAdapter();
        this.pc = pc;
        this.pc.setEntity(this);
    }

    protected DBPersistableEntityAdapter(Entity entity) {
        try {
            tmAdapter = ((DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance()).getTransactionManagerAdapter();
            this.pc = tmAdapter.entityToPersistableEntity(entity).getPersistedObject();
            this.pc.setEntity(this);
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Persistence").logException(e);
        }
    }

    protected DBPersistableEntityAdapter(String key) {
        try {
            tmAdapter = ((DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance()).getTransactionManagerAdapter();
            this.pc = tmAdapter.entityToPersistableEntity(tmAdapter.get(key, TreeOptionType.SKELETON)).getPersistedObject();
            this.pc.setEntity(this);
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Persistence").logException(e);
        }
    }

    public PersistenceContainer getPersistedObject() {
        return this.pc;
    }

    public String getEntityKey() {
        return this.pc.getKey();
    }

    public String getClasstype() {
        return this.pc.getClasstype();
    }

    public void setInstance(PersistedObject persistedObject) {
        this.po = persistedObject;
    }

    public void getInstance(PersistedObject persistedObject) {
        this.po = persistedObject;
    }

    public Entity getEntity() {
        try {
            return tmAdapter.persistableEntityToEntity(this);
        }
        catch (PersistenceException e) {
            Trace.getInstance("MI/Persistence").logException(e);
            return null;
        }
    }
}

