/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.query.CompositeCondition;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SingleCondition;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBConnectionDelegate;
import com.sap.ip.me.persist.jdbc.DBLinkTableDescriptor;
import com.sap.ip.me.persist.jdbc.DBObjectTable;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;

final class DBObjectTableImpl
implements DBObjectTable {
    private static final DBPersistedObject[] EMPTY_POARRAY = new DBPersistedObject[0];
    private static final Vector EMPTY_VECTOR = new Vector();
    private final String entTabName;
    private DBConnectionDelegate delegate;
    private final DBAttributeDescriptor[] entAttributes;
    private final DBClassDescriptor classDesc;
    private final Hashtable namedAttributeDescs = new Hashtable();
    private String lnkTabName;
    private DBLinkTableDescriptor lnkDesc;
    private final int keyPos;
    private final Vector vecSort = new Vector();

    DBObjectTableImpl(String tabName, DBClassDescriptor classDesc) {
        if (tabName == null || tabName.length() == 0) {
            throw new NullPointerException("tabName is null");
        }
        if (classDesc == null) {
            throw new NullPointerException("DBClassDescriptor is null");
        }
        this.entTabName = tabName;
        this.classDesc = classDesc;
        this.entAttributes = this.classDesc.getDBAttributeDescriptorArray();
        int i = 0;
        int max = this.entAttributes.length;
        while (i < max) {
            this.namedAttributeDescs.put(this.entAttributes[i].getName(), this.entAttributes[i]);
            ++i;
        }
        this.keyPos = classDesc.getKeyAttributePosition();
    }

    public final void setLinkAttributes(String tabName, DBLinkTableDescriptor lnkDesc) {
        if (tabName == null) {
            throw new NullPointerException("link table name is null");
        }
        if (lnkDesc == null) {
            throw new NullPointerException("DBLinkTableDescriptor is null");
        }
        this.lnkTabName = tabName;
        this.lnkDesc = lnkDesc;
    }

    public final void setConnectionDelegate(DBConnectionDelegate delegate) {
        if (delegate == null) {
            throw new NullPointerException("ConnectionDelegate is null");
        }
        this.delegate = delegate;
    }

    private DBAttributeDescriptor getDBAttributeDescriptor(AttributeDescriptor descr) throws PersistenceException {
        if (descr instanceof DBAttributeDescriptor) {
            return (DBAttributeDescriptor)descr;
        }
        if (this.namedAttributeDescs.get(descr.getName()) != null) {
            return (DBAttributeDescriptor)this.namedAttributeDescs.get(descr.getName());
        }
        throw new PersistenceException("DBAttributeDescriptor with the name " + descr.getName() + " is not available!");
    }

    private final StringBuffer createWhereClauseForKey(StringBuffer sql, Object key) throws SQLException {
        sql.append(this.entAttributes[this.keyPos].getColumnName()).append('=');
        this.entAttributes[this.keyPos].toSQLValue(sql, key);
        return sql;
    }

    private final StringBuffer createColumnList(StringBuffer sql, String prefix) {
        prefix = prefix == null ? "" : prefix + ".";
        int i = 0;
        int max = this.entAttributes.length;
        while (i < max) {
            if (this.entAttributes[i].getMultiple() == 1) {
                sql.append(i == 0 ? (char)' ' : ',');
                sql.append(prefix).append(this.entAttributes[i].getColumnName());
            } else {
                int m = 0;
                int mmax = this.entAttributes[i].getMultiple();
                while (m < mmax) {
                    sql.append((char)(i == 0 && m == 0 ? 32 : 44));
                    sql.append(prefix).append(this.entAttributes[i].getColumnName(m));
                    ++m;
                }
            }
            ++i;
        }
        return sql;
    }

    private final void processSQLException(SQLException sqe, String msg) throws PersistenceException {
        if (Trace.getInstance("MI/Persistence").isOn()) {
            Trace.getInstance("MI/Persistence").logException(sqe, false);
            Trace.getInstance("MI/Persistence").log(msg + " - error code: {0} SQL state: {1}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState());
        }
        throw new PersistenceException(sqe);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insert(DBPersistedObject pObj) throws PersistenceException {
        Object perfLogTag = null;
        try {
            try {
                String stmtString = this.createInsertStatement(pObj);
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(stmtString);
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "insert");
                Object var6_7 = null;
                PerformanceLog.methodFinished(perfLogTag, "insert");
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            PerformanceLog.methodFinished(perfLogTag, "insert");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insert");
    }

    final String createInsertStatement(DBPersistedObject pObj) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("insert into ").append(this.entTabName).append(" (");
        this.createColumnList(sql, null);
        sql.append(") values (");
        this.createValueList(sql, pObj);
        sql.append(')');
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(sqlStr);
        return sqlStr;
    }

    private final StringBuffer createValueList(StringBuffer sql, DBPersistedObject pObj) throws SQLException {
        int i = 0;
        int max = this.entAttributes.length;
        while (i < max) {
            if (this.entAttributes[i].getMultiple() == 1) {
                sql.append(i == 0 ? (char)' ' : ',');
                this.entAttributes[i].toSQLValue(sql, pObj.internalGetAttribute(i, true));
            } else {
                int m = 0;
                int mmax = this.entAttributes[i].getMultiple();
                while (m < mmax) {
                    sql.append((char)(i == 0 && m == 0 ? 32 : 44));
                    this.entAttributes[i].toSQLValue(sql, pObj.internalGetAttribute(i, m, true));
                    ++m;
                }
            }
            ++i;
        }
        return sql;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(DBPersistedObject pObj) throws PersistenceException {
        Object perfLogTag = null;
        try {
            block4: {
                try {
                    if (this.entAttributes.length <= 1) break block4;
                    String stmtString = this.createUpdateStatement(pObj);
                    perfLogTag = PerformanceLog.methodStarted(this);
                    Statement stmt = this.delegate.getStatement();
                    stmt.executeUpdate(stmtString);
                }
                catch (SQLException sqe) {
                    this.processSQLException(sqe, "update");
                    Object var6_7 = null;
                    PerformanceLog.methodFinished(perfLogTag, "update");
                    return;
                }
            }
            Object var6_6 = null;
            PerformanceLog.methodFinished(perfLogTag, "update");
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            PerformanceLog.methodFinished(perfLogTag, "update");
            throw throwable;
        }
    }

    final String createUpdateStatement(DBPersistedObject pObj) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("update ").append(this.entTabName).append(" set ");
        boolean firstField = true;
        int i = 0;
        int max = this.entAttributes.length;
        while (i < max) {
            if (i != this.keyPos) {
                if (this.entAttributes[i].getMultiple() == 1) {
                    if (!firstField) {
                        sql.append(',');
                    } else {
                        firstField = false;
                    }
                    sql.append(this.entAttributes[i].getColumnName()).append('=');
                    this.entAttributes[i].toSQLValue(sql, pObj.internalGetAttribute(i, true));
                } else {
                    int m = 0;
                    int mmax = this.entAttributes[i].getMultiple();
                    while (m < mmax) {
                        if (!firstField) {
                            sql.append(',');
                        } else {
                            firstField = false;
                        }
                        sql.append(this.entAttributes[i].getColumnName(m)).append('=');
                        this.entAttributes[i].toSQLValue(sql, pObj.internalGetAttribute(i, m, true));
                        ++m;
                    }
                }
            }
            ++i;
        }
        sql.append(" where ");
        this.createWhereClauseForKey(sql, pObj.getKey());
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(DBPersistedObject pObj) throws PersistenceException {
        Object perfLogTag = null;
        try {
            try {
                String stmtString = this.createDeleteStatement(pObj);
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(stmtString);
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "delete");
                Object var6_7 = null;
                PerformanceLog.methodFinished(perfLogTag, "delete");
                return;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            PerformanceLog.methodFinished(perfLogTag, "delete");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete");
    }

    final String createDeleteStatement(DBPersistedObject pObj) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("delete from ").append(this.entTabName).append(" where ");
        this.createWhereClauseForKey(sql, pObj.getKey());
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteAll() throws PersistenceException {
        Object perfLogTag = null;
        try {
            try {
                String stmtString = this.createDeleteAllStatement();
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(stmtString);
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "deleteAll");
                Object var5_6 = null;
                PerformanceLog.methodFinished(perfLogTag, "deleteAll");
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            PerformanceLog.methodFinished(perfLogTag, "deleteAll");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "deleteAll");
    }

    final String createDeleteAllStatement() throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("delete from ").append(this.entTabName);
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    public void deleteAll(Object clid) throws PersistenceException {
        try {
            String sql = this.createDeleteAllStatement(clid);
            if (sql != null) {
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(sql);
            }
        }
        catch (SQLException sqe) {
            this.processSQLException(sqe, "deleteAll for clid");
        }
    }

    final String createDeleteAllStatement(Object clid) throws SQLException, PersistenceException {
        Statement stmt = this.delegate.getStatement();
        ResultSet rset = stmt.executeQuery(this.createDeleteSubSelect(clid));
        if (!rset.next()) {
            return null;
        }
        StringBuffer sql = new StringBuffer(1024);
        sql.append("delete from ").append(this.entTabName);
        sql.append(" where ").append(this.entAttributes[this.keyPos].getColumnName());
        sql.append(" in ");
        int ch = 40;
        DBAttributeDescriptor ad = this.lnkDesc.getForeignKeyDescriptor();
        do {
            sql.append((char)ch);
            ad.toSQLValue(sql, rset.getObject(1));
            ch = 44;
        } while (rset.next());
        sql.append(')');
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    final String createDeleteSubSelect(Object clid) throws SQLException {
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ");
        sql.append(this.lnkDesc.getForeignKeyDescriptor().getColumnName());
        sql.append(" from ").append(this.lnkTabName).append(" where ");
        sql.append(this.lnkDesc.getClassIdDescriptor().getColumnName()).append('=');
        this.lnkDesc.getClassIdDescriptor().toSQLValue(sql, clid);
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DBPersistedObject get(String key) throws PersistenceException {
        DBPersistedObject dBPersistedObject;
        Object perfLogTag = null;
        try {
            try {
                DBPersistedObject pObj = null;
                Statement stmt = this.delegate.getStatement();
                String stmtString = this.createSelectStatement(key);
                perfLogTag = PerformanceLog.methodStarted(this);
                ResultSet rset = stmt.executeQuery(stmtString);
                if (rset.next()) {
                    pObj = new DBPersistedObject(this.classDesc, key);
                    this.resultSetToPersistedObject(pObj, rset);
                }
                rset.close();
                dBPersistedObject = pObj;
                Object var9_10 = null;
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "get(" + key + ")");
                DBPersistedObject dBPersistedObject2 = null;
                Object var9_11 = null;
                PerformanceLog.methodFinished(perfLogTag, "get by key");
                return dBPersistedObject2;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            PerformanceLog.methodFinished(perfLogTag, "get by key");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by key");
        return dBPersistedObject;
    }

    private final void resultSetToPersistedObject(DBPersistedObject pObj, ResultSet rset) throws SQLException, PersistenceException {
        int i = 0;
        int ridx = 1;
        int max = this.entAttributes.length;
        while (i < max) {
            if (this.entAttributes[i].getMultiple() == 1) {
                pObj.loadAttribute(i, this.entAttributes[i].toValue(rset, ridx++));
            } else {
                int m = 0;
                int mmax = this.entAttributes[i].getMultiple();
                while (m < mmax) {
                    pObj.loadAttribute(i, m, this.entAttributes[i].toValue(rset, ridx++));
                    ++m;
                }
            }
            ++i;
        }
    }

    final String createSelectStatement(Object key) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select ");
        this.createColumnList(sql, null);
        sql.append(" from ").append(this.entTabName).append(" where ");
        this.createWhereClauseForKey(sql, key);
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector get(DBPersistedObject pObj, Object clid, boolean isSingleLink) throws PersistenceException {
        Vector vector;
        if (this.lnkTabName == null) {
            throw new NullPointerException("no link handling possible");
        }
        Object perfLogTag = null;
        try {
            try {
                String stmtString = isSingleLink ? this.createSelectStatement(clid) : this.createRelatedSelectStatement(pObj.getKey(), clid);
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                ResultSet rset = stmt.executeQuery(stmtString);
                Vector vec = this.buildResultVector(rset, pObj);
                rset.close();
                vector = vec;
                Object var11_11 = null;
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "get(pObj,clid)");
                throw new PersistenceException(sqe);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            PerformanceLog.methodFinished(perfLogTag, "get linked");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get linked");
        return vector;
    }

    private final Vector buildResultVector(ResultSet rset, DBPersistedObject pObj) throws SQLException, PersistenceException {
        if (!rset.next()) {
            return EMPTY_VECTOR;
        }
        Vector<DBPersistedObject> vec = new Vector<DBPersistedObject>();
        DBPersistedObject anchor = pObj.getAnchor();
        boolean flag = true;
        while (flag) {
            String key = (String)this.entAttributes[this.keyPos].toValue(rset, this.keyPos + 1);
            DBPersistedObject po = anchor.lookupPersistedObject(key, this.classDesc);
            if (po == null) {
                po = new DBPersistedObject(this.classDesc, key);
                po.setAnchor(pObj);
                this.resultSetToPersistedObject(po, rset);
            }
            vec.addElement(po);
            flag = rset.next();
        }
        return vec;
    }

    final String createRelatedSelectStatement(Object pkey, Object clid) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select ");
        this.createColumnList(sql, this.entTabName);
        sql.append(',').append(this.lnkTabName).append('.').append(this.lnkDesc.getOrderDescriptor().getColumnName());
        sql.append(" from ").append(this.lnkTabName);
        sql.append(',').append(this.entTabName);
        sql.append(" where ");
        sql.append(this.entTabName).append('.').append(this.entAttributes[this.keyPos].getColumnName());
        sql.append('=');
        sql.append(this.lnkTabName).append('.').append(this.lnkDesc.getForeignKeyDescriptor().getColumnName());
        sql.append(" and ");
        this.createLinkWhereClause(sql, this.lnkDesc.getPrimaryKeyDescriptor(), pkey);
        sql.append(" and ");
        this.createLinkWhereClause(sql, this.lnkDesc.getClassIdDescriptor(), clid);
        sql.append(" order by ");
        sql.append(this.lnkTabName).append('.');
        sql.append(this.lnkDesc.getOrderDescriptor().getColumnName());
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private final StringBuffer createLinkWhereClause(StringBuffer sql, DBAttributeDescriptor ad, Object obj) throws SQLException {
        sql.append(this.lnkTabName).append('.').append(ad.getColumnName()).append('=');
        ad.toSQLValue(sql, obj);
        return sql;
    }

    final int rowCount() throws SQLException {
        int rc = 0;
        Statement stmt = this.delegate.getStatement();
        ResultSet rset = stmt.executeQuery("select count(*) from " + this.entTabName);
        if (rset.next()) {
            rc = rset.getInt(1);
        }
        rset.close();
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getCountByQuery(Query query) throws PersistenceException {
        int n;
        Object perfLogTag = null;
        try {
            try {
                String stmtString = this.createQueryStatement(query, true);
                int count = 0;
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                ResultSet rset = stmt.executeQuery(stmtString);
                if (rset.next()) {
                    count = rset.getInt(1);
                }
                rset.close();
                n = count;
                Object var9_10 = null;
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "getCount(Query)");
                int n2 = 0;
                Object var9_11 = null;
                PerformanceLog.methodFinished(perfLogTag, "getCount by Query");
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            PerformanceLog.methodFinished(perfLogTag, "getCount by Query");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "getCount by Query");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getByQuery(Query query) throws PersistenceException {
        Vector vector;
        Object perfLogTag = null;
        try {
            try {
                String stmtString = this.createQueryStatement(query, false);
                int off = query == null ? 0 : Math.max(0, query.getStartIndex());
                int max = query == null ? Integer.MAX_VALUE : query.getMaxResults();
                max = max == -1 ? Integer.MAX_VALUE : max;
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                ResultSet rset = stmt.executeQuery(stmtString);
                Vector vec = this.buildResultVector(rset, off, max);
                rset.close();
                vector = vec;
                Object var11_12 = null;
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "get(Query)");
                Vector vector2 = EMPTY_VECTOR;
                Object var11_13 = null;
                PerformanceLog.methodFinished(perfLogTag, "get by Query");
                return vector2;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            PerformanceLog.methodFinished(perfLogTag, "get by Query");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "get by Query");
        return vector;
    }

    /*
     * Unable to fully structure code
     */
    private final Vector buildResultVector(ResultSet rset, int off, int len) throws SQLException, PersistenceException {
        if (rset.next()) ** GOTO lbl6
        return DBObjectTableImpl.EMPTY_VECTOR;
lbl-1000:
        // 1 sources

        {
            if (!rset.next()) {
                return DBObjectTableImpl.EMPTY_VECTOR;
            }
            --off;
lbl6:
            // 2 sources

            ** while (off > 0)
        }
lbl7:
        // 1 sources

        vec = new Vector<DBPersistedObject>();
        flag = true;
        while (len > 0 && flag) {
            key = (String)this.entAttributes[this.keyPos].toValue(rset, this.keyPos + 1);
            pObj = new DBPersistedObject(this.classDesc, key);
            this.resultSetToPersistedObject(pObj, rset);
            vec.addElement(pObj);
            flag = rset.next();
            --len;
        }
        return vec;
    }

    final String createQueryStatement(Query query, boolean isCount) throws SQLException, PersistenceException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("select");
        if (isCount) {
            sql.append(" count(*)");
        } else {
            this.createColumnList(sql, null);
        }
        sql.append(" from ").append(this.entTabName);
        this.createQueryWhereClause(sql, query);
        if (!isCount) {
            this.createQueryOrderClause(sql, query);
        }
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    final StringBuffer createQueryOrderClause(StringBuffer sql, Query query) throws SQLException, PersistenceException {
        if (query == null || query.getSortOrder() == null) {
            return sql;
        }
        sql.append(" ORDER BY ");
        if (query.getSortOrder().isMultiple()) {
            this.createQueryOrderClauseMultipleOrder(sql, this.getMultipleOrder(this.vecSort, query.getSortOrder()));
            this.vecSort.removeAllElements();
        } else {
            this.createQueryOrderClauseSingleOrder(sql, query.getSortOrder());
        }
        return sql;
    }

    private void createQueryOrderClauseSingleOrder(StringBuffer sql, SortOrder order) throws PersistenceException {
        if (!(order instanceof SingleSortOrder)) {
            throw new IllegalArgumentException("order not a SingleOrder");
        }
        SingleSortOrder sOrder = (SingleSortOrder)order;
        DBAttributeDescriptor descr = null;
        descr = this.getDBAttributeDescriptor(sOrder.getAttributeDescriptor());
        if (descr.getMultiple() != 1) {
            throw new PersistenceException("No order by with Multiple Columns possible!");
        }
        sql.append(descr.getColumnName());
        sql.append(sOrder.isAscending() ? " ASC" : " DESC");
    }

    private void createQueryOrderClauseMultipleOrder(StringBuffer sql, Vector v) throws PersistenceException {
        int i = 0;
        int max = v.size();
        while (i < max) {
            sql.append(i == 0 ? "" : ", ");
            this.createQueryOrderClauseSingleOrder(sql, (SortOrder)v.elementAt(i));
            ++i;
        }
    }

    private Vector getMultipleOrder(Vector v, SortOrder order) {
        if (!(order instanceof MultipleSortOrder)) {
            throw new IllegalArgumentException("order is not a MultipleSortOrder");
        }
        MeIterator iter = ((MultipleSortOrder)order).getSortOrders();
        while (iter.hasNext()) {
            SortOrder sOrder = (SortOrder)iter.next();
            if (sOrder.isMultiple()) {
                this.getMultipleOrder(v, sOrder);
                continue;
            }
            v.addElement(sOrder);
        }
        return v;
    }

    final StringBuffer createQueryWhereClause(StringBuffer sql, Query query) throws SQLException, PersistenceException {
        if (query == null || query.getCondition() == null) {
            return sql;
        }
        if (query.getCondition().isComposite()) {
            if (!((CompositeCondition)query.getCondition()).isEmpty()) {
                sql.append(" where ");
                this.createQueryWhereClauseCompositeCondition(sql, query.getCondition());
            }
        } else {
            sql.append(" where ");
            this.createQueryWhereClauseSingleCondition(sql, query.getCondition());
        }
        return sql;
    }

    final void createQueryWhereClauseCompositeCondition(StringBuffer sql, Condition cond) throws PersistenceException, SQLException {
        if (!(cond instanceof CompositeCondition)) {
            throw new IllegalArgumentException("conditon is not CompositeCondition");
        }
        MeIterator iter = ((CompositeCondition)cond).getComponents();
        LogicalOperatorType operator = ((CompositeCondition)cond).getLogicalOperator();
        int i = 0;
        while (iter.hasNext()) {
            Condition c = (Condition)iter.next();
            if (i != 0) {
                sql.append(' ').append(operator.toString()).append(' ');
            }
            if (c.isComposite()) {
                sql.append("(");
                this.createQueryWhereClauseCompositeCondition(sql, c);
                sql.append(")");
            } else {
                this.createQueryWhereClauseSingleCondition(sql, c);
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createQueryWhereClauseSingleCondition(StringBuffer sql, Condition cond) throws PersistenceException, SQLException {
        if (!(cond instanceof SingleCondition)) {
            throw new IllegalArgumentException("conditon is not a SingleCondition");
        }
        DBAttributeDescriptor attDesc = null;
        attDesc = this.getDBAttributeDescriptor(((SingleCondition)cond).getAttributeDescriptor());
        RelationalOperatorType op = ((SingleCondition)cond).getRelationalOperator();
        Object value = ((SingleCondition)cond).getValue();
        if (attDesc.getMultiple() != 1) {
            throw new PersistenceException("Cannot compare value with a multiple field!");
        }
        if (op.equals(RelationalOperatorType.STARTS_WITH)) {
            sql.append(attDesc.getColumnName());
            sql.append(" LIKE ");
            attDesc.toSQLValueStartsWith(sql, value);
            return;
        } else if (op.equals(RelationalOperatorType.CONTAINS)) {
            sql.append(attDesc.getColumnName());
            sql.append(" LIKE ");
            attDesc.toSQLValueContains(sql, value);
            return;
        } else if (op.equals(RelationalOperatorType.LIKE)) {
            sql.append(attDesc.getColumnName());
            sql.append(" LIKE ");
            attDesc.toSQLValueAsterisk(sql, value);
            return;
        } else if (op.equals(RelationalOperatorType.LIKE_INSENSITIVE)) {
            attDesc.appendWithUpper(sql, attDesc.getColumnName());
            sql.append(" LIKE ");
            attDesc.toSQLValueUpper(sql, value);
            return;
        } else if (op.equals(RelationalOperatorType.SQL_LIKE)) {
            sql.append(attDesc.getColumnName());
            sql.append(" LIKE ");
            attDesc.toSQLValueLike(sql, value);
            return;
        } else if (value == null) {
            sql.append(attDesc.getColumnName());
            if (op == RelationalOperatorType.EQUALS) {
                sql.append(" IS NULL ");
                return;
            } else {
                if (op != RelationalOperatorType.NOT_EQUALS) throw new IllegalArgumentException("OperationType doesn't work for null op=" + op);
                sql.append(" IS NOT NULL ");
            }
            return;
        } else {
            sql.append(attDesc.getColumnName());
            sql.append(" " + op.toString() + " ");
            attDesc.toSQLValue(sql, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateLinkColumn(DBPersistedObject pObj, int index, String fkey) throws PersistenceException {
        Object perfLogTag = null;
        try {
            try {
                StringBuffer sql = new StringBuffer(1024);
                sql.append("update ").append(this.entTabName).append(" set link").append(index);
                sql.append('=');
                if (fkey == null) {
                    sql.append(fkey);
                } else {
                    sql.append("'").append(fkey).append("'");
                }
                sql.append(" where ");
                sql.append(this.entAttributes[this.keyPos].getColumnName()).append(" = '");
                sql.append(pObj.getKey()).append("'");
                String sqlStr = sql.toString();
                Trace.getInstance("MI/Persistence").log(90, sqlStr);
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(sqlStr);
            }
            catch (SQLException sqe) {
                this.processSQLException(sqe, "update link column");
                Object var9_10 = null;
                PerformanceLog.methodFinished(perfLogTag, "update link column");
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            PerformanceLog.methodFinished(perfLogTag, "update link column");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "update link column");
    }

    public Object getLinkKey(DBPersistedObject pObj, int index) throws PersistenceException {
        Object link;
        StringBuffer sql = new StringBuffer(256);
        sql.append("select link").append(index).append(" from ");
        sql.append(this.entTabName).append(" where ");
        sql.append(this.entAttributes[this.keyPos].getColumnName()).append(" = '");
        sql.append(pObj.getKey()).append("'");
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        try {
            Statement stmt = this.delegate.getStatement();
            ResultSet rset = stmt.executeQuery(sqlStr);
            link = this.getColumnFromResult(rset, 1);
            rset.close();
        }
        catch (SQLException sqe) {
            this.processSQLException(sqe, "getLinkKey)");
            return null;
        }
        return link;
    }

    private Object getColumnFromResult(ResultSet rset, int idx) throws SQLException {
        if (!rset.next()) {
            return null;
        }
        Object result = rset.getObject(idx);
        return result;
    }

    private MeIterator getIteratorFromResult(ResultSet rset) throws SQLException {
        Vector<String> result = new Vector<String>();
        while (rset.next()) {
            String res = rset.getString(1);
            if (res == null) continue;
            result.addElement(res);
        }
        return new MeIteratorVectorImpl(result);
    }

    public MeIterator getAllLinkKeys(int index) throws PersistenceException {
        MeIterator results;
        StringBuffer sql = new StringBuffer(128);
        sql.append("select link").append(index).append(" from ");
        sql.append(this.entTabName);
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        try {
            Statement stmt = this.delegate.getStatement();
            ResultSet rset = stmt.executeQuery(sqlStr);
            results = this.getIteratorFromResult(rset);
            rset.close();
        }
        catch (SQLException sqe) {
            this.processSQLException(sqe, "getAllLinkKeys for index" + index);
            return null;
        }
        return results;
    }

    public boolean isExisting(String key) throws PersistenceException {
        StringBuffer sql = new StringBuffer(128);
        sql.append("select ").append(this.entAttributes[this.keyPos].getColumnName()).append(" from ");
        sql.append(this.entTabName).append(" where ").append(this.entAttributes[this.keyPos].getColumnName());
        sql.append(" = '").append(key).append("'");
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        try {
            Statement stmt = this.delegate.getStatement();
            ResultSet rset = stmt.executeQuery(sqlStr);
            if (rset.next()) {
                return true;
            }
        }
        catch (SQLException sqe) {
            this.processSQLException(sqe, "check existence of entity");
            return false;
        }
        return false;
    }
}

