/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.SecurityManager;
import com.sap.ip.me.persist.jdbc.DBConnectionDelegate;
import com.sap.ip.me.persist.jdbc.DBConnectionManager;
import com.sap.ip.me.persist.jdbc.DBEncryptionManager;
import com.sap.ip.me.persist.jdbc.DBPersistenceManager;
import com.sap.ip.me.persist.jdbc.DBTableManager;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public abstract class DBManager
implements DBConnectionManager,
DBEncryptionManager,
DBConnectionDelegate {
    private static final String DBNAME_KEY = "MobileEngine.Persist.Jdbc.DbName";
    private static final String JDBC_DRIVER_KEY = "MobileEngine.Persist.Jdbc.Driver";
    private static final String DB_URL_KEY = "MobileEngine.Persist.Jdbc.DbUrl";
    private static final String DB_USER_KEY = "MobileEngine.Persist.Jdbc.DbUser";
    private static final String DB_ENCRYPTION_KEY = "MobileEngine.Persist.Encryption";
    private static final String ROOTDIR_ISABSOLUTE_KEY = "MobileEngine.Persist.RootDir.isAbsolute";
    private static final String ROOTDIR_KEY = "MobileEngine.Persist.Rootdir";
    private boolean isEncrypted = this.readIsEncrypted();
    private DBTableManager tableAdmin;
    private static Statement statement;

    public DBPersistenceManager createTransactionManager(String convIdStr, Hashtable cds) throws SQLException {
        return this.createConcreteTransactionManager(this.getTableMap(convIdStr, cds));
    }

    public DBPersistenceManager setTableMap(DBPersistenceManager pm, String convIdStr, Hashtable cds) throws SQLException {
        pm.setTableMap(this.getTableMap(convIdStr, cds));
        return pm;
    }

    private DBTableMap getTableMap(String convIdStr, Hashtable cds) throws SQLException {
        if (this.tableAdmin == null) {
            this.tableAdmin = this.createTableAdmin();
        }
        return this.tableAdmin.getTableMap(convIdStr, cds);
    }

    protected DBManager() {
    }

    protected abstract DBPersistenceManager createConcreteTransactionManager(DBTableMap var1);

    protected abstract DBTableManager createTableAdmin() throws SQLException;

    protected String getDriverClassName() {
        String ret = this.getProperty(JDBC_DRIVER_KEY);
        if (ret == null) {
            throw new RuntimeException(this.getKeyErrorString(JDBC_DRIVER_KEY));
        }
        return ret;
    }

    private String getKeyErrorString(String key) {
        StringBuffer sb = new StringBuffer("Cannot startup Jdbc implementation: property ");
        sb.append(JDBC_DRIVER_KEY);
        sb.append(" not defined");
        return sb.toString();
    }

    protected String getDBUrl() {
        String ret = this.getProperty(DB_URL_KEY);
        if (ret == null) {
            throw new RuntimeException(this.getKeyErrorString(DB_URL_KEY));
        }
        return ret;
    }

    protected String getUserName() {
        return this.getProperty(DB_USER_KEY);
    }

    protected String getPassword() {
        return SecurityManager.getInstance().getDBPassword();
    }

    protected File getRootDir() {
        File rootdir = new File(new File(this.getRootDirPath()).getAbsolutePath());
        if (!rootdir.exists()) {
            rootdir.mkdirs();
        }
        return rootdir;
    }

    private boolean readIsEncrypted() {
        Configuration conf = Configuration.getInstance();
        return conf.getBoolean(DB_ENCRYPTION_KEY, false);
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    private String getRootDirPath() {
        StringBuffer sbDir = new StringBuffer(200);
        Configuration conf = Configuration.getInstance();
        boolean isAbsoluteDir = conf.getBoolean(ROOTDIR_ISABSOLUTE_KEY, false);
        if (!isAbsoluteDir) {
            this.getRelativeDir(conf, sbDir);
        }
        sbDir.append(conf.getProperty(ROOTDIR_KEY));
        return sbDir.toString();
    }

    private StringBuffer getRelativeDir(Configuration conf, StringBuffer sbDir) {
        String instDir = conf.getProperty("MobileEngine.InstallationPath");
        sbDir.append(instDir);
        sbDir.append(File.separator);
        return sbDir;
    }

    private String getProperty(String key) {
        Configuration conf = Configuration.getInstance();
        String ret = conf.getProperty(key);
        return ret;
    }

    void deleteAllDataForConversationId(String convId) throws SQLException {
        this.tableAdmin.deleteAllDataForConversationId(convId);
    }

    DBTableManager _getTableAdmin() {
        return this.tableAdmin;
    }

    public Statement getStatement() throws SQLException {
        if (statement == null) {
            statement = this.getConnection().createStatement();
        }
        return statement;
    }

    public void closeStatement() throws SQLException {
        if (statement != null) {
            statement.close();
            statement = null;
            Trace.getInstance("MI/Persistence").log(70, "Statement was closed");
        }
    }

    public abstract void closeConnection() throws SQLException;

    public abstract Connection restoreConnection() throws SQLException;

    public abstract Connection getConnection() throws SQLException;
}

