/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBLongFormatter
extends DBSqlFormatter {
    public final StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof Long) {
            return buf.append(((Long)obj).toString()).append(".0");
        }
        throw new SQLException("DBSqlFormatter: value is not a long");
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        long lv = rset.getLong(idx);
        if (rset.wasNull()) {
            return null;
        }
        return new Long(lv);
    }

    private void checkLenDec(int len, int dec) {
        if (dec != 0) {
            throw new IllegalArgumentException("It is not allowed to specify DECIMALS for LONG");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("LENGTH must be larger than zero");
        }
        if (len > 19) {
            throw new IllegalArgumentException("Maximum length for LONG is 19");
        }
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        this.checkLenDec(len, dec);
        return buf.append("DECIMAL(").append(len).append(",0)");
    }
}

