/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBConnectionDelegate;
import com.sap.ip.me.persist.jdbc.DBLinkTable;
import com.sap.ip.me.persist.jdbc.DBLinkTableDescriptor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

class DBLinkTableImpl
implements DBLinkTable {
    private static final int IDX_PKEY = 0;
    private static final int IDX_CLID = 1;
    private static final int IDX_ORDR = 2;
    private static final int IDX_FKEY = 3;
    private static final int IDX_TYPE = 4;
    private static final int IDX_FTYPE = 5;
    private final String lnkTabName;
    private DBConnectionDelegate delegate;
    private DBAttributeDescriptor[] lnkAttributes;
    private static final int KEY_LEN = 128;
    private int orderNumber = -1;

    DBLinkTableImpl(String tabName, DBLinkTableDescriptor ldesc) {
        if (tabName == null) {
            throw new NullPointerException("table name is null");
        }
        if (ldesc == null) {
            throw new NullPointerException("link table descriptor is null");
        }
        this.lnkTabName = tabName;
        this.lnkAttributes = new DBAttributeDescriptor[6];
        this.lnkAttributes[0] = ldesc.getPrimaryKeyDescriptor();
        this.lnkAttributes[3] = ldesc.getForeignKeyDescriptor();
        this.lnkAttributes[1] = ldesc.getClassIdDescriptor();
        this.lnkAttributes[2] = ldesc.getOrderDescriptor();
        this.lnkAttributes[4] = ldesc.getClasstypeDescriptor();
        this.lnkAttributes[5] = ldesc.getForeignClasstypeDescriptor();
    }

    public final void setConnectionDelegate(DBConnectionDelegate cDelegate) {
        if (cDelegate == null) {
            throw new NullPointerException("delegate is null");
        }
        this.delegate = cDelegate;
    }

    public final void insert(Object pkey, Object clid, Object fkey, Object pkeyClasstype, Object fkeyClasstype) throws PersistenceException {
        this.validateInsertParameter(pkey, clid, fkey, pkeyClasstype, fkeyClasstype);
        Object perfLogTag = null;
        try {
            try {
                Object ordr = this.getNextOrderNumber(pkey, clid);
                String stmtString = this.createInsertStatement(pkey, clid, fkey, ordr, pkeyClasstype, fkeyClasstype);
                perfLogTag = PerformanceLog.methodStarted(this);
                Statement stmt = this.delegate.getStatement();
                stmt.executeUpdate(stmtString);
            }
            catch (SQLException sqe) {
                Trace.getInstance("MI/Persistence").logException(sqe, true);
                Trace.getInstance("MI/Persistence").log("insert link - error code: {0} SQL state: {1}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState());
                throw new PersistenceException(sqe);
            }
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            PerformanceLog.methodFinished(perfLogTag, "insert");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "insert");
    }

    final String createInsertStatement(Object pkey, Object clid, Object fkey, Object ordr, Object pClasstype, Object fClasstype) throws SQLException {
        StringBuffer sql = new StringBuffer(1024);
        sql.append("insert into ").append(this.lnkTabName).append(" (");
        this.createColumnList(sql).append(") values (");
        this.lnkAttributes[0].toSQLValue(sql, pkey).append(',');
        this.lnkAttributes[1].toSQLValue(sql, clid).append(',');
        this.lnkAttributes[2].toSQLValue(sql, ordr).append(',');
        this.lnkAttributes[3].toSQLValue(sql, fkey).append(',');
        this.lnkAttributes[4].toSQLValue(sql, pClasstype).append(',');
        this.lnkAttributes[5].toSQLValue(sql, fClasstype);
        sql.append(')');
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    final StringBuffer createColumnList(StringBuffer sql) {
        sql.append(this.lnkAttributes[0].getColumnName()).append(',');
        sql.append(this.lnkAttributes[1].getColumnName()).append(',');
        sql.append(this.lnkAttributes[2].getColumnName()).append(',');
        sql.append(this.lnkAttributes[3].getColumnName()).append(',');
        sql.append(this.lnkAttributes[4].getColumnName()).append(',');
        sql.append(this.lnkAttributes[5].getColumnName());
        return sql;
    }

    private void validateInsertParameter(Object pkey, Object clid, Object fkey, Object pClasstype, Object fClasstype) {
        if (this.delegate == null) {
            throw new NullPointerException("link insert: delegate is null");
        }
        if (pkey == null) {
            throw new NullPointerException("link insert: pkey is null");
        }
        if (fkey == null) {
            throw new NullPointerException("link insert: fkey is null");
        }
        if (clid == null) {
            throw new NullPointerException("link insert: class id is null");
        }
        if (pClasstype == null) {
            throw new NullPointerException("link insert: classtype is null");
        }
        if (fClasstype == null) {
            throw new NullPointerException("link insert: classtype is null");
        }
    }

    public void delete(Object pkey, Object clid) throws PersistenceException {
        if (pkey == null || clid == null) {
            throw new NullPointerException("link table delete: pkey=" + pkey + " clid=" + clid);
        }
        this.deleteIntern(pkey, clid, null, null, null);
    }

    public void deleteForeign(Object fkey, String Classtype) throws PersistenceException {
        if (fkey == null) {
            throw new NullPointerException("link table delete: fkey is null");
        }
        this.deleteIntern(null, null, fkey, null, Classtype);
    }

    public void delete(Object pkey, Object clid, Object fkey, Object classtype) throws PersistenceException {
        if (pkey == null || clid == null || fkey == null || classtype == null) {
            throw new NullPointerException("link table delete: pkey=" + pkey + " clid=" + clid + " fkey=" + fkey + "classtype=" + classtype);
        }
        this.deleteIntern(pkey, clid, fkey, classtype, null);
    }

    public void delete(Object pkey, String classtype) throws PersistenceException {
        if (pkey == null || classtype == null) {
            throw new NullPointerException("link table delete: pkey=" + pkey + "classtype=" + classtype);
        }
        this.deleteIntern(pkey, null, null, classtype, null);
    }

    public void deleteAll(Object clid) throws PersistenceException {
        if (clid == null) {
            throw new NullPointerException("link table deleteAll: clid is null");
        }
        if (clid instanceof DBClassDescriptor) {
            this.deleteIntern(null, null, null, ((DBClassDescriptor)clid).getClasstype(), null);
        } else {
            this.deleteIntern(null, clid, null, null, null);
        }
    }

    private final void deleteIntern(Object pkey, Object clid, Object fkey, Object pClasstype, Object fClasstype) throws PersistenceException {
        Object perfLogTag = null;
        try {
            try {
                Statement stmt = this.delegate.getStatement();
                perfLogTag = PerformanceLog.methodStarted(this);
                String stmtString = this.createDeleteStatement(pkey, clid, fkey, pClasstype, fClasstype);
                stmt.executeUpdate(stmtString);
            }
            catch (SQLException sqe) {
                Trace.getInstance("MI/Persistence").logException(sqe, true);
                Trace.getInstance("MI/Persistence").log("delete link - error code: {0} SQL state: {1}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState());
                throw new PersistenceException(sqe);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            PerformanceLog.methodFinished(perfLogTag, "delete");
            throw throwable;
        }
        PerformanceLog.methodFinished(perfLogTag, "delete");
    }

    final String createDeleteStatement(Object pkey, Object clid, Object fkey, Object pClasstype, Object fClasstype) throws SQLException {
        StringBuffer sql = new StringBuffer(128);
        sql.append("delete from ").append(this.lnkTabName);
        if (pkey != null || clid != null || fkey != null || pClasstype != null) {
            boolean hasClause = false;
            sql.append(" where ");
            hasClause = this.createDeleteWhereClause(sql, hasClause, 0, pkey);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 1, clid);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 3, fkey);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 4, pClasstype);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 5, fClasstype);
        }
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private final boolean createDeleteWhereClause(StringBuffer sql, boolean hasClause, int idx, Object obj) throws SQLException {
        if (obj == null) {
            return hasClause;
        }
        sql.append(!hasClause ? "" : " and ");
        sql.append(this.lnkAttributes[idx].getColumnName()).append('=');
        this.lnkAttributes[idx].toSQLValue(sql, obj);
        return true;
    }

    private final Object getNextOrderNumber(Object pkey, Object clid) throws SQLException {
        if (this.orderNumber == -1) {
            Statement stmt = this.delegate.getStatement();
            ResultSet rset = stmt.executeQuery(this.createMaxOrderString(pkey, clid));
            this.orderNumber = !rset.next() ? ++this.orderNumber : rset.getInt(1);
            rset.close();
        }
        return new Integer(++this.orderNumber);
    }

    final String createMaxOrderString(Object pkey, Object clid) throws SQLException {
        StringBuffer sql = new StringBuffer(196);
        sql.append("select ").append(this.lnkAttributes[2].getColumnName());
        sql.append(" from ").append(this.lnkTabName);
        sql.append(" order by ");
        sql.append(this.lnkAttributes[2].getColumnName()).append(" desc");
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    final Vector select() throws SQLException {
        return this.select(null, null, null);
    }

    final Vector select(Object fkey) throws SQLException {
        return this.select(null, null, fkey);
    }

    final Vector select(Object pkey, Object clid) throws SQLException {
        return this.select(pkey, clid, null);
    }

    final Vector select(Object pkey, Object clid, Object fkey) throws SQLException {
        Statement stmt = this.delegate.getStatement();
        ResultSet rset = stmt.executeQuery(this.createSelectStatement(pkey, clid, fkey));
        Vector vec = this.processResultSet(rset);
        rset.close();
        return vec;
    }

    private final Vector processResultSet(ResultSet rset) throws SQLException {
        Vector<Object[]> vec = new Vector<Object[]>();
        while (rset.next()) {
            Object pkey = this.lnkAttributes[0].toValue(rset, 1);
            Object clid = this.lnkAttributes[1].toValue(rset, 2);
            Object ordr = this.lnkAttributes[2].toValue(rset, 3);
            Object fkey = this.lnkAttributes[3].toValue(rset, 4);
            vec.addElement(new Object[]{pkey, clid, ordr, fkey});
        }
        return vec;
    }

    final String createSelectStatement(Object pkey, Object clid, Object fkey) throws SQLException {
        StringBuffer sql = new StringBuffer(128);
        boolean hasClause = false;
        sql.append("select ");
        this.createColumnList(sql).append(" from ").append(this.lnkTabName);
        if (pkey != null || clid != null || fkey != null) {
            sql.append(" where ");
            hasClause = this.createDeleteWhereClause(sql, hasClause, 0, pkey);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 1, clid);
            hasClause = this.createDeleteWhereClause(sql, hasClause, 3, fkey);
        }
        String sqlStr = sql.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    final int rowCount() throws SQLException {
        int rc = 0;
        Statement stmt = this.delegate.getStatement();
        Trace.getInstance("MI/Persistence").log(stmt.toString());
        ResultSet rset = stmt.executeQuery("select count(*) from " + this.lnkTabName);
        if (rset.next()) {
            rc = rset.getInt(1);
        }
        rset.close();
        return rc;
    }
}

