/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBLinkDescriptor;
import com.sap.ip.me.persist.jdbc.DBLinkTableDescriptor;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

class DBLinkAdmin {
    private static final String LINKTABLE_PKEY_FIELD = "PKEY";
    private static final String LINKTABLE_CLID_FIELD = "CLID";
    private static final String LINKTABLE_ORDR_FIELD = "ORDR";
    private static final String LINKTABLE_FKEY_FIELD = "FKEY";
    private static final String LINKTABLE_TYPE_FIELD = "CLASSTYPE";
    private static final String LINKTABLE_FTYPE_FIELD = "FCLASSTYPE";
    private static final int LINK_PKEY_POS = 0;
    private static final int LINK_CLID_POS = 1;
    private static final int LINK_ORDR_POS = 2;
    private static final int LINK_FKEY_POS = 3;
    private static final int LINK_TYPE_POS = 4;
    private static final int LINK_FTYPE_POS = 5;
    private static final int KEY_LEN = 64;
    private static DBAttributeDescriptor[] ads;
    private static LinkTableDescriptor lnkTableDesc;
    private Hashtable referencedPropertyPerClassType;

    DBLinkAdmin(Hashtable cds) {
        if (cds == null) {
            throw new IllegalArgumentException("PackagePersistenceMaster is null");
        }
        ads = this.getAttributeDescriptors();
        this.referencedPropertyPerClassType = this.getReferencedPropertyTable(cds);
    }

    void verifyLinkTable(DBRepresentor dbRep, String tablename) throws SQLException {
        if (dbRep == null) {
            throw new IllegalArgumentException("DBRepresentor is null");
        }
        if (tablename == null) {
            throw new IllegalArgumentException("tableName is null");
        }
        if (!dbRep.verifyTableExists(tablename, ads)) {
            dbRep.createSingleIndex(tablename, ads[2]);
        }
    }

    DBLinkTableDescriptor getLinkTableDescriptor() {
        if (lnkTableDesc == null) {
            lnkTableDesc = new LinkTableDescriptor();
        }
        return lnkTableDesc;
    }

    boolean isReferenced(ClassDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException("ClassDescriptor is null");
        }
        if (!this.referencedPropertyPerClassType.containsKey(cd)) {
            throw new IllegalArgumentException("ClassDescriptor not supported by PackagePersistenceMaster");
        }
        return (Boolean)this.referencedPropertyPerClassType.get(cd);
    }

    private DBAttributeDescriptor[] getAttributeDescriptors() {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            ads = new DBAttributeDescriptor[6];
            DBLinkAdmin.ads[0] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_PKEY_FIELD, AttributeType.STRING, 1, 64, true);
            DBLinkAdmin.ads[1] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_CLID_FIELD, AttributeType.INTEGER, 1, 10, true);
            DBLinkAdmin.ads[2] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_ORDR_FIELD, AttributeType.INTEGER, 1, 10, true);
            DBLinkAdmin.ads[3] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_FKEY_FIELD, AttributeType.STRING, 1, 64);
            DBLinkAdmin.ads[4] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_TYPE_FIELD, AttributeType.STRING, 1, 128, true);
            DBLinkAdmin.ads[5] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKTABLE_FTYPE_FIELD, AttributeType.STRING, 1, 128, true);
        }
        catch (DescriptorException e) {
            AppLog.getInstance("MI/Persistence").logException(e);
            throw new RuntimeException("Attribute descriptors for link table can't be created");
        }
        return ads;
    }

    private Hashtable getReferencedPropertyTable(Hashtable cds) {
        Hashtable<ClassDescriptor, Boolean> table = new Hashtable<ClassDescriptor, Boolean>(cds.size());
        Enumeration enumeration = cds.elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor cd = (ClassDescriptor)enumeration.nextElement();
            if (!table.containsKey(cd)) {
                table.put(cd, Boolean.FALSE);
            }
            MeIterator iterator = cd.getLinkDescriptors();
            while (iterator.hasNext()) {
                String referencedClassName = ((DBLinkDescriptor)iterator.next()).getClasstype();
                ClassDescriptor referencedClassDesc = (ClassDescriptor)cds.get(referencedClassName);
                table.put(referencedClassDesc, Boolean.TRUE);
            }
        }
        return table;
    }

    private class LinkTableDescriptor
    implements DBLinkTableDescriptor {
        private LinkTableDescriptor() {
        }

        public DBAttributeDescriptor getPrimaryKeyDescriptor() {
            return ads[0];
        }

        public DBAttributeDescriptor getForeignKeyDescriptor() {
            return ads[3];
        }

        public DBAttributeDescriptor getClassIdDescriptor() {
            return ads[1];
        }

        public DBAttributeDescriptor getOrderDescriptor() {
            return ads[2];
        }

        public DBAttributeDescriptor getClasstypeDescriptor() {
            return ads[4];
        }

        public DBAttributeDescriptor getForeignClasstypeDescriptor() {
            return ads[5];
        }
    }
}

