/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.query.JQueryAttribute;
import com.sap.ip.me.api.persist.query.JQueryResultRow;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBlobHandle;
import com.sap.ip.me.persist.jdbc.DBJQueryAttributeImpl;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBJQueryResultRowImpl
implements JQueryResultRow {
    private final JQueryAttribute[] attributes;
    private final Object[] data;

    DBJQueryResultRowImpl(JQueryAttribute[] attributes) {
        this.attributes = attributes;
        this.data = new Object[attributes.length];
    }

    void loadAttributes(ResultSet results) throws SQLException {
        int i = 0;
        while (i < this.attributes.length) {
            this.data[i] = ((DBAttributeDescriptor)((DBJQueryAttributeImpl)this.attributes[i]).getAttributeDescriptor()).toValue(results, i + 1);
            if (this.data[i] instanceof DBBlobHandle) {
                this.data[i] = ((DBBlobHandle)this.data[i]).getBytes();
            }
            ++i;
        }
    }

    public int size() {
        return this.attributes.length;
    }

    public Object get(JQueryAttribute attr) throws IllegalArgumentException {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i] == attr) {
                return this.data[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No such attribute");
    }

    public Object get(int index) throws ArrayIndexOutOfBoundsException {
        return this.data[index];
    }

    public Object get(Object tag) throws IllegalArgumentException {
        int i = 0;
        while (i < this.attributes.length) {
            if (((DBJQueryAttributeImpl)this.attributes[i]).hasTag(tag)) {
                return this.data[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No such attribute");
    }

    public Object[] getAll() {
        return this.data;
    }

    public JQueryAttribute[] getAttributes() {
        return this.attributes;
    }
}

