/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.query.JQueryResultBuilder;
import com.sap.ip.me.api.persist.query.JQueryResultRow;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.jdbc.DBJQueryResultImpl;

public class DBJQueryResultIterator
implements MeIterator {
    private final DBJQueryResultImpl results;
    private final JQueryResultBuilder resultBuilder;
    private boolean closed = false;

    DBJQueryResultIterator(DBJQueryResultImpl results, JQueryResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
        this.results = results;
    }

    public boolean hasNext() {
        this.assertOpen();
        return this.results.hasNext();
    }

    public Object next() {
        this.assertOpen();
        JQueryResultRow row = this.results.next();
        if (this.resultBuilder != null) {
            return this.resultBuilder.buildQueryResultObject(row);
        }
        return row;
    }

    public int elementCount() {
        this.assertOpen();
        return this.results.size();
    }

    public void reset() {
        this.assertOpen();
        this.results.rewind();
    }

    void close() {
        this.assertOpen();
        if (this.resultBuilder != null) {
            this.resultBuilder.endProcessing();
        }
        this.closed = true;
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Using already closed iterator");
        }
    }
}

