/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.JQueryResultBuilder;
import com.sap.ip.me.api.persist.query.JQueryResultRow;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.persist.jdbc.DBJQueryImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryResultIterator;
import com.sap.ip.me.persist.jdbc.DBJQueryResultRowImpl;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class DBJQueryResultImpl
implements JQueryResult {
    private final DBJQueryImpl query;
    private Statement stat;
    private final String sql;
    private ResultSet results;
    private boolean canCacheResult = true;
    private Vector cachedRows = null;
    private boolean cache = false;
    private boolean hasCurrent;
    private int current = 0;
    private int size = -1;
    private DBJQueryResultIterator currentIter = null;
    private DBJQueryResultRowImpl cachedRow = null;
    private final int start;
    private final int maxCount;

    DBJQueryResultImpl(DBJQueryImpl query, Statement stat, String sql, int start, int maxCount) throws SQLException {
        this.query = query;
        this.stat = stat;
        this.sql = sql;
        this.start = start;
        this.maxCount = maxCount < 0 ? Integer.MAX_VALUE : maxCount;
        this.doQuery();
    }

    private void doQuery() throws SQLException {
        this.results = this.stat.executeQuery(this.sql);
        int skip = this.start;
        while (--skip >= 0) {
            if (this.results.next()) continue;
            this.hasCurrent = false;
            return;
        }
        this.hasCurrent = this.results.next();
    }

    public MeIterator iterator() {
        return this.iterator(null);
    }

    public MeIterator iterator(JQueryResultBuilder resultBuilder) {
        this.canCacheResult = false;
        DBJQueryResultIterator iter = new DBJQueryResultIterator(this, resultBuilder);
        if (resultBuilder != null) {
            resultBuilder.startProcessing(this.query.getAttributes());
        }
        if (this.currentIter != null) {
            this.currentIter.close();
        }
        this.currentIter = iter;
        return iter;
    }

    public int size() {
        if (this.size < 0) {
            if (this.cachedRows != null) {
                this.size = this.cachedRows.size();
                return this.size;
            }
            try {
                int savedPos = this.current;
                while (this.hasCurrent) {
                    this.hasCurrent = this.results.next();
                    ++this.current;
                    if (this.current != this.maxCount) continue;
                    this.hasCurrent = false;
                }
                this.size = this.current;
                if (savedPos != this.current) {
                    this.rewind();
                    this.current = 0;
                    while (--savedPos >= 0) {
                        this.hasCurrent = this.results.next();
                        ++this.current;
                    }
                }
                this.current = savedPos;
            }
            catch (SQLException e) {
                DBPersistenceManagerImpl.processSQLException(e, "Cannot determine size");
                throw new RuntimeException("Cannot determine size");
            }
        }
        return this.size;
    }

    JQueryResultRow next() {
        if (!this.hasCurrent) {
            throw new IllegalStateException("Iterating past end of data");
        }
        if (this.cachedRows != null) {
            JQueryResultRow row = (JQueryResultRow)this.cachedRows.elementAt(this.current++);
            this.hasCurrent = this.current < this.cachedRows.size();
            return row;
        }
        try {
            DBJQueryResultRowImpl row = this.cache ? (this.cachedRow == null ? this.cachedRow : new DBJQueryResultRowImpl(this.query.getAttributes())) : new DBJQueryResultRowImpl(this.query.getAttributes());
            row.loadAttributes(this.results);
            this.cachedRow = this.cache ? row : null;
            this.hasCurrent = this.results.next();
            ++this.current;
            if (this.current == this.maxCount) {
                this.hasCurrent = false;
            }
            return row;
        }
        catch (SQLException e) {
            DBPersistenceManagerImpl.processSQLException(e, "Cannot load next object");
            throw new RuntimeException("Cannot load next object");
        }
    }

    /*
     * Unable to fully structure code
     */
    void rewind() {
        if (this.cachedRows == null) {
            try {
                if (this.current == 0) ** GOTO lbl12
                this.results.close();
                this.doQuery();
                this.current = 0;
            }
            catch (SQLException e) {
                DBPersistenceManagerImpl.processSQLException(e, "Cannot rewind query results");
                throw new RuntimeException("Cannot rewind query results");
            }
        } else {
            this.hasCurrent = this.cachedRows.size() > 0;
        }
lbl12:
        // 3 sources

        this.current = 0;
    }

    boolean hasNext() {
        return this.hasCurrent;
    }

    public boolean setEnableCache(boolean on) {
        boolean old = this.cache;
        this.cache = on;
        return old;
    }

    public void release() {
        Trace.getInstance("MI/Persistence").log(90, "release() called on JQueryResult");
        try {
            if (this.currentIter != null) {
                this.currentIter.close();
            }
            if (this.stat != null) {
                this.stat.close();
                this.stat = null;
            }
            if (this.results != null) {
                this.results.close();
                this.results = null;
            }
        }
        catch (SQLException e) {
            DBPersistenceManagerImpl.processSQLException(e, "Cannot close query results");
            throw new RuntimeException("Cannot close query results");
        }
    }

    public void prefetchAllRows() {
        if (!this.canCacheResult) {
            throw new IllegalStateException("Cannot cache rows when query already executed.");
        }
        this.canCacheResult = false;
        boolean savedCache = this.cache;
        this.cache = false;
        Vector<JQueryResultRow> v = new Vector<JQueryResultRow>();
        while (this.hasNext()) {
            v.addElement(this.next());
        }
        try {
            this.stat.close();
            this.stat = null;
            this.results = null;
        }
        catch (SQLException e) {
            DBPersistenceManagerImpl.processSQLException(e, "Cannot close SQL results");
            throw new RuntimeException("Cannot close SQL results");
        }
        this.results = null;
        this.cachedRows = v;
        this.current = 0;
        this.size = v.size();
        this.hasCurrent = this.size > 0;
        this.cache = savedCache;
    }
}

