/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.query.JQueryParameter;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import java.sql.SQLException;

class DBJQueryParameterImpl
implements JQueryParameter {
    private Object defaultValue;
    private final Object tag;
    private DBAttributeDescriptor attr;
    private RelationalOperatorType operator;

    DBJQueryParameterImpl(Object defaultValue, Object tag) {
        this.defaultValue = defaultValue;
        this.tag = tag;
    }

    public Object getTag() {
        return this.tag;
    }

    boolean hasTag(Object tag) {
        return this.tag == tag;
    }

    public void setDefaultValue(Object value) {
        this.setDefaultValueImpl(value);
    }

    void setDefaultValueImpl(Object value) {
        this.checkValue(value, false);
        this.defaultValue = value;
    }

    Object getDefaultValue() {
        return this.defaultValue;
    }

    void adviseCondition(AttributeDescriptor attr, RelationalOperatorType operator) {
        if (this.attr != null) {
            if (this.attr != attr || this.operator != operator) {
                throw new IllegalArgumentException("Parameter already bound to condition with attribute " + this.attr + " and operator " + this.operator);
            }
            return;
        }
        this.attr = (DBAttributeDescriptor)attr;
        this.operator = operator;
        this.checkValue(this.defaultValue, true);
    }

    void checkValue(Object value, boolean allowNull) {
        if (value == null) {
            if (!allowNull) {
                throw new NullPointerException("Null values for parameters are not allowed.");
            }
            return;
        }
        if (this.attr == null) {
            return;
        }
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            if (this.operator == RelationalOperatorType.IN) {
                cls = cls.getComponentType();
            } else {
                throw new IllegalArgumentException("Array assignment allowed only for operator IN");
            }
        }
        if (!this.attr.getType().javaType.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Trying to compare wrong type to attribute " + this.attr);
        }
    }

    StringBuffer toSQL(StringBuffer buffer, Object value) throws SQLException {
        if (value == null) {
            throw new NullPointerException("Cannot compare " + this.attr.getColumnName() + " with null value");
        }
        return this.attr.toSQLValue(buffer, value);
    }

    StringBuffer toSQLLike(StringBuffer buffer, Object value, boolean uppercase, boolean asterisk) throws SQLException {
        if (value == null) {
            throw new NullPointerException("Cannot compare " + this.attr.getColumnName() + " with null value");
        }
        if (uppercase) {
            return this.attr.toSQLValueUpper(buffer, value);
        }
        if (asterisk) {
            return this.attr.toSQLValueAsterisk(buffer, value);
        }
        return this.attr.toSQLValue(buffer, value);
    }

    static StringBuffer appendEscaped(StringBuffer buffer, String value, char[] toEscape, char escape, boolean withReplace) {
        int len = value.length();
        int i = 0;
        while (i < len) {
            char c = value.charAt(i);
            int j = 0;
            while (j < toEscape.length) {
                if (c == toEscape[j]) {
                    buffer.append(escape);
                    break;
                }
                ++j;
            }
            if (c == '*' && withReplace) {
                c = '%';
            }
            buffer.append(c);
            ++i;
        }
        return buffer;
    }
}

