/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.query.JQueryAttribute;
import com.sap.ip.me.api.persist.query.JQueryParameter;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBJQueryAttributeImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryConditionImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterSetImpl;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.SQLException;

public class DBJQueryParameterConditionImpl
extends DBJQueryConditionImpl {
    private final DBJQueryAttributeImpl left;
    private final RelationalOperatorType operator;
    private final DBJQueryParameterImpl right;
    private final char[] LIKE_CHARS = new char[]{'%', '?', '_', '\'', '\\', '\"'};
    private final char[] SQL_LIKE_CHARS = new char[]{'?', '_', '\'', '\\', '\"'};

    DBJQueryParameterConditionImpl(JQueryAttribute left, RelationalOperatorType operator, JQueryParameter right) {
        this.left = (DBJQueryAttributeImpl)left;
        this.checkOperator(this.left, operator);
        this.right = (DBJQueryParameterImpl)right;
        this.operator = operator;
        if (this.left.getAggregator() != null) {
            throw new IllegalArgumentException("Cannot place condition on aggregated attribute " + this.left.getAttributeDescriptor());
        }
        this.right.adviseCondition(this.left.getAttributeDescriptor(), operator);
    }

    public void setParameterDefaultValue(Object value) throws IllegalStateException {
        this.right.setDefaultValueImpl(value);
    }

    public Object getParameterTag() throws IllegalStateException {
        return this.right.getTag();
    }

    void extractMetadata(DBJQueryImpl query) {
        query.appendParameter(this.right);
    }

    StringBuffer toSQL(StringBuffer buffer, DBJQueryParameterSetImpl params, DBEntityStoreFactory entityStoreFactory) throws SQLException {
        Object value;
        Object object = value = params == null ? this.right.getDefaultValue() : params.getParameter(this.right);
        if (this.operator == RelationalOperatorType.IN) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(' ');
            if (value instanceof Object[]) {
                buffer.append("IN (");
                Object[] data = (Object[])value;
                int i = 0;
                while (i < data.length) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    this.right.toSQL(buffer, data[i]);
                    ++i;
                }
                return buffer.append(')');
            }
            return this.right.toSQL(buffer.append("= "), value);
        }
        if (this.operator == RelationalOperatorType.CONTAINS) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(' ');
            return DBJQueryParameterImpl.appendEscaped(buffer.append("LIKE '%"), (String)value, this.LIKE_CHARS, '\\', false).append("%'");
        }
        if (this.operator == RelationalOperatorType.STARTS_WITH) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(' ');
            return DBJQueryParameterImpl.appendEscaped(buffer.append("LIKE '"), (String)value, this.LIKE_CHARS, '\\', false).append("%'");
        }
        if (this.operator == RelationalOperatorType.LIKE) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(" LIKE ");
            return this.right.toSQLLike(buffer, value, false, true);
        }
        if (this.operator == RelationalOperatorType.LIKE_INSENSITIVE) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), true).append("  LIKE ");
            return this.right.toSQLLike(buffer, value, true, true);
        }
        if (this.operator == RelationalOperatorType.SQL_LIKE) {
            this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(" LIKE ");
            return this.right.toSQLLike(buffer, value, false, false);
        }
        this.left.toSQL(buffer, entityStoreFactory.getTableMap(), false).append(' ');
        return this.right.toSQL(buffer.append(this.operator.toString()).append(' '), value);
    }

    boolean toSQLOrder(StringBuffer buffer, boolean hasOrder, DBTableMap tableMap) {
        return hasOrder;
    }
}

