/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBJQueryConditionImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryLinkAttributeImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterSetImpl;
import com.sap.ip.me.persist.jdbc.DBTableMap;

class DBJQueryLinkConditionImpl
extends DBJQueryConditionImpl {
    private final DBJQueryLinkAttributeImpl link;

    DBJQueryLinkConditionImpl(DBJQueryLinkAttributeImpl link) {
        this.link = link;
    }

    void extractMetadata(DBJQueryImpl query) {
        LinkDescriptor link = this.link.getLinkDesc();
        query.appendTable(link.getClasstype());
        query.appendTable(this.link.getClassDesc().getClasstype());
    }

    StringBuffer toSQL(StringBuffer buffer, DBJQueryParameterSetImpl params, DBEntityStoreFactory entityStoreFactory) throws PersistenceException {
        LinkDescriptor link = this.link.getLinkDesc();
        DBTableMap tableMap = entityStoreFactory.getTableMap();
        DBClassDescriptor source = (DBClassDescriptor)this.link.getClassDesc();
        String srcTabName = tableMap.getTablename(source);
        String srcKeyName = ((DBAttributeDescriptor)source.getKeyAttributeDescriptor()).getColumnName();
        String dstTabName = tableMap.getTablename(link.getClasstype());
        String dstKeyName = ((DBAttributeDescriptor)tableMap.getClassDescriptor(link.getClasstype()).getKeyAttributeDescriptor()).getColumnName();
        int linkPos = source.getLinkPosition(link.getName());
        if (link.getMultiplicity() == MultiplicityType.SINGLE) {
            buffer.append(tableMap.getTablename(source)).append(".link").append(linkPos).append(" = ").append(dstTabName).append('.').append(dstKeyName);
            return buffer;
        }
        String linkTable = tableMap.getLinkTablename();
        buffer.append(srcTabName).append('.').append(srcKeyName).append(" = ").append(linkTable).append(".pkey AND ").append(dstTabName).append('.').append(dstKeyName).append(" = ").append(linkTable).append(".fkey");
        return buffer;
    }

    boolean toSQLOrder(StringBuffer buffer, boolean hasOrder, DBTableMap tableMap) {
        return hasOrder;
    }

    boolean toSQLFrom(StringBuffer buffer, DBTableMap tableMap, boolean hasBigLink) {
        if (this.link.getLinkDesc().getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR && !hasBigLink) {
            String linkTable = tableMap.getLinkTablename();
            buffer.append(',').append(linkTable);
            hasBigLink = true;
        }
        return hasBigLink;
    }
}

