/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.JQuery;
import com.sap.ip.me.api.persist.query.JQueryAttribute;
import com.sap.ip.me.api.persist.query.JQueryGroupBy;
import com.sap.ip.me.api.persist.query.JQueryParameter;
import com.sap.ip.me.api.persist.query.JQueryParameterSet;
import com.sap.ip.me.api.persist.query.JQueryResult;
import com.sap.ip.me.api.persist.query.JQuerySortOrder;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBJQueryAttributeImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryConditionImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryGroupByImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterSetImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryResultImpl;
import com.sap.ip.me.persist.jdbc.DBJQuerySortOrderImpl;
import com.sap.ip.me.persist.jdbc.DBPersistenceManagerImpl;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class DBJQueryImpl
implements JQuery {
    private final JQueryAttribute[] attributes;
    private final DBJQueryConditionImpl cond;
    private final JQuerySortOrder[] sortOrders;
    private final JQueryGroupBy groupBy;
    private final boolean distinct;
    private DBJQueryParameterImpl[] params = new DBJQueryParameterImpl[8];
    private int paramCount = 0;
    private String[] tables = new String[8];
    private int tableCount = 0;

    DBJQueryImpl(JQueryAttribute[] attributes, DBJQueryConditionImpl cond, boolean distinct, JQuerySortOrder[] sortOrders, JQueryGroupBy groupBy) {
        this.attributes = attributes;
        this.cond = cond;
        this.distinct = distinct;
        this.sortOrders = sortOrders;
        this.groupBy = groupBy;
        int i = 0;
        while (i < attributes.length) {
            this.appendAttribute((DBJQueryAttributeImpl)attributes[i]);
            ++i;
        }
        if (cond != null) {
            cond.extractMetadata(this);
        }
    }

    public void setParameterDefaultValue(Object tag, Object value) throws IllegalArgumentException {
        int i = 0;
        while (i < this.paramCount) {
            if (this.params[i].hasTag(tag)) {
                this.params[i].setDefaultValueImpl(value);
                break;
            }
            ++i;
        }
    }

    public void setParameterDefaultValue(JQueryParameter param, Object value) throws IllegalArgumentException {
        ((DBJQueryParameterImpl)param).setDefaultValueImpl(value);
    }

    public JQueryParameterSet newParameterSet() {
        return new DBJQueryParameterSetImpl(this.params, this.paramCount);
    }

    void appendParameter(DBJQueryParameterImpl param) {
        int i = 0;
        while (i < this.paramCount) {
            if (this.params[i] == param) {
                return;
            }
            ++i;
        }
        if (this.paramCount == this.params.length) {
            DBJQueryParameterImpl[] newParam = new DBJQueryParameterImpl[this.paramCount * 2];
            System.arraycopy(this.params, 0, newParam, 0, this.paramCount);
            this.params = newParam;
        }
        this.params[this.paramCount++] = param;
    }

    void appendAttribute(DBJQueryAttributeImpl attr) {
        ClassDescriptor table = attr.getClassDescriptor();
        this.appendTable(table.getClasstype());
    }

    void appendTable(String table) {
        int i = 0;
        while (i < this.tableCount) {
            if (this.tables[i].equals(table)) {
                return;
            }
            ++i;
        }
        if (this.tableCount == this.tables.length) {
            String[] newtable = new String[this.tableCount * 2];
            System.arraycopy(this.tables, 0, newtable, 0, this.tableCount);
            this.tables = newtable;
        }
        this.tables[this.tableCount++] = table;
    }

    StringBuffer toSQL(StringBuffer buffer, DBEntityStoreFactory entityStoreFactory, DBJQueryParameterSetImpl params, int start, int count) throws SQLException, PersistenceException {
        DBTableMap tableMap = entityStoreFactory.getTableMap();
        if (this.distinct) {
            buffer.append("SELECT DISTINCT ");
        } else {
            buffer.append("SELECT ");
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            ((DBJQueryAttributeImpl)this.attributes[i]).toSQL(buffer, tableMap, false);
            ++i;
        }
        buffer.append(" FROM ");
        int i2 = 0;
        while (i2 < this.tableCount) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(DBJQueryAttributeImpl.getSQLTable(tableMap, this.tables[i2]));
            ++i2;
        }
        if (this.cond != null) {
            this.cond.toSQLFrom(buffer, tableMap, false);
        }
        if (this.cond != null) {
            this.cond.toSQL(buffer.append(" WHERE "), params, entityStoreFactory);
        }
        if (this.groupBy != null) {
            buffer.append(" GROUP BY ");
            ((DBJQueryGroupByImpl)this.groupBy).toSQL(buffer, tableMap);
        }
        boolean hasOrder = false;
        if (this.sortOrders != null && this.sortOrders.length > 0) {
            buffer.append(" ORDER BY ");
            int i3 = 0;
            while (i3 < this.sortOrders.length) {
                if (i3 > 0) {
                    buffer.append(", ");
                }
                ((DBJQuerySortOrderImpl)this.sortOrders[i3]).toSQL(buffer, tableMap);
                ++i3;
            }
            hasOrder = true;
        }
        if (this.cond != null) {
            this.cond.toSQLOrder(buffer, hasOrder, tableMap);
        }
        return buffer;
    }

    JQueryResult execute(Connection sqlConn, DBEntityStoreFactory entityStoreFactory, JQueryParameterSet params, int start, int count) throws PersistenceException {
        try {
            String sql = this.toSQL(new StringBuffer(1024), entityStoreFactory, (DBJQueryParameterSetImpl)params, start, count).toString();
            Trace.getInstance("MI/Persistence").log(90, "JQuery SQL {0}", (Object)sql);
            Statement stat = sqlConn.createStatement();
            return new DBJQueryResultImpl(this, stat, sql, start, count);
        }
        catch (SQLException e) {
            DBPersistenceManagerImpl.processSQLException(e, "Cannot execute JQuery");
            throw new PersistenceException(e);
        }
    }

    JQueryAttribute[] getAttributes() {
        return this.attributes;
    }
}

