/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.query.JQueryCondition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBJQueryConditionImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryImpl;
import com.sap.ip.me.persist.jdbc.DBJQueryParameterSetImpl;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.SQLException;

class DBJQueryCompositeConditionImpl
extends DBJQueryConditionImpl {
    private final DBJQueryConditionImpl left;
    private final LogicalOperatorType operator;
    private final DBJQueryConditionImpl right;

    DBJQueryCompositeConditionImpl(JQueryCondition left, LogicalOperatorType operator, JQueryCondition right) {
        if (operator == LogicalOperatorType.NOT) {
            if (left != null) {
                throw new IllegalArgumentException("Unary logical operator specified for binary condition");
            }
        } else if (left == null) {
            throw new IllegalArgumentException("Binary logical operator missing left condition branch");
        }
        if (right == null) {
            throw new IllegalArgumentException("Logical operator missing right condition branch");
        }
        this.left = (DBJQueryConditionImpl)left;
        this.right = (DBJQueryConditionImpl)right;
        this.operator = operator;
    }

    void extractMetadata(DBJQueryImpl query) {
        if (this.left != null) {
            this.left.extractMetadata(query);
        }
        this.right.extractMetadata(query);
    }

    StringBuffer toSQL(StringBuffer buffer, DBJQueryParameterSetImpl params, DBEntityStoreFactory entityStoreFactory) throws SQLException, PersistenceException {
        buffer.append('(');
        if (this.operator == LogicalOperatorType.NOT) {
            this.right.toSQL(buffer.append("NOT "), params, entityStoreFactory);
        } else {
            this.right.toSQL(this.left.toSQL(buffer, params, entityStoreFactory).append(' ').append(this.operator.toString()).append(' '), params, entityStoreFactory);
        }
        return buffer.append(')');
    }

    boolean toSQLOrder(StringBuffer buffer, boolean hasOrder, DBTableMap tableMap) {
        if (this.left != null) {
            hasOrder = this.left.toSQLOrder(buffer, hasOrder, tableMap);
        }
        hasOrder = this.right.toSQLOrder(buffer, hasOrder, tableMap);
        return hasOrder;
    }

    boolean toSQLFrom(StringBuffer buffer, DBTableMap tableMap, boolean hasBigLink) {
        if (this.left != null) {
            hasBigLink = this.left.toSQLFrom(buffer, tableMap, hasBigLink);
        }
        return this.right.toSQLFrom(buffer, tableMap, hasBigLink);
    }
}

