/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.query.AggregationOperatorType;
import com.sap.ip.me.api.persist.query.JQueryAttribute;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.sql.SQLException;

class DBJQueryAttributeImpl
implements JQueryAttribute {
    private final ClassDescriptor cdesc;
    private final AttributeDescriptor attr;
    private final Object tag;
    private AggregationOperatorType aggreg;

    DBJQueryAttributeImpl(ClassDescriptor cdesc, AttributeDescriptor attr, Object tag) {
        this.cdesc = cdesc;
        this.attr = attr;
        this.tag = tag;
        this.aggreg = null;
    }

    public Object getTag() {
        return this.tag;
    }

    public AggregationOperatorType getAggregator() {
        return this.aggreg;
    }

    public AttributeDescriptor getAttributeDescriptor() {
        return this.attr;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.cdesc;
    }

    String getTableName(DBTableMap tableMap) {
        return DBJQueryAttributeImpl.getSQLTable(tableMap, this.cdesc.getClasstype());
    }

    static String getSQLTable(DBTableMap tableMap, String cdesc) {
        return tableMap.getTablename(cdesc);
    }

    JQueryAttribute makeAggregate(AggregationOperatorType aggreg) {
        AttributeType type;
        if (aggreg == null) {
            throw new IllegalArgumentException("Cannot aggregate aggregate attribute");
        }
        if (aggreg != AggregationOperatorType.COUNT && ((type = this.attr.getType()) == AttributeType.BINARY || type == AttributeType.BOOLEAN || type == AttributeType.DATE || type == AttributeType.SQLDATE || type == AttributeType.SQLTIME || type == AttributeType.STRING)) {
            throw new IllegalArgumentException("Aggregator " + aggreg + " is not supported for type " + type);
        }
        DBJQueryAttributeImpl nattr = new DBJQueryAttributeImpl(this.cdesc, this.attr, this.tag);
        nattr.aggreg = aggreg;
        return nattr;
    }

    StringBuffer toSQL(StringBuffer buffer, DBTableMap tableMap, boolean uppercase) throws SQLException {
        StringBuffer temp = new StringBuffer(this.getTableName(tableMap));
        temp.append('.').append(((DBAttributeDescriptor)this.attr).getColumnName());
        if (uppercase) {
            return ((DBAttributeDescriptor)this.attr).appendWithUpper(buffer, temp.toString());
        }
        if (this.aggreg != null) {
            return buffer.append(this.aggreg.getName()).append('(').append((Object)temp).append(')');
        }
        return buffer.append((Object)temp);
    }

    boolean hasTag(Object tag) {
        return this.tag == tag;
    }
}

