/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.persist.jdbc.DBClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBConnectionDelegate;
import com.sap.ip.me.persist.jdbc.DBEntityStore;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBLinkTable;
import com.sap.ip.me.persist.jdbc.DBLinkTableDescriptor;
import com.sap.ip.me.persist.jdbc.DBLinkTableImpl;
import com.sap.ip.me.persist.jdbc.DBObjectTableImpl;
import com.sap.ip.me.persist.jdbc.DBTableMap;
import java.util.Hashtable;

final class DBEntityStoreFactoryImpl
implements DBEntityStoreFactory {
    private DBTableMap tableMap;
    private final Hashtable entityStoreMap = new Hashtable();
    private final DBConnectionDelegate delegate;
    private EntityFactory factory;
    private DBLinkTable lnkTable;

    DBEntityStoreFactoryImpl(DBTableMap tableNameMap, DBConnectionDelegate delegate) {
        if (tableNameMap == null) {
            throw new NullPointerException("Table name map is null");
        }
        if (delegate == null) {
            throw new NullPointerException("Connection delegate is null");
        }
        this.tableMap = tableNameMap;
        this.delegate = delegate;
    }

    public DBEntityStore getEntityStore(String classType) throws PersistenceException {
        if (this.entityStoreMap.containsKey(classType)) {
            return (DBEntityStore)this.entityStoreMap.get(classType);
        }
        return this.createEntityStore(classType);
    }

    final void setTableMap(DBTableMap tableMap) {
        this.tableMap = tableMap;
    }

    final void setEntityFactory(EntityFactory entityFactory) {
        if (entityFactory == null) {
            throw new NullPointerException("EntityFactory is null");
        }
        if (this.factory == entityFactory) {
            return;
        }
        this.factory = entityFactory;
        if (this.entityStoreMap.size() > 0) {
            this.entityStoreMap.clear();
            Trace.getInstance("MI/Persistence").log(90, "EntityFactory replaced and EntityStoreMap cleared!");
        }
    }

    final boolean entityFactoryIsSet() {
        return this.factory != null;
    }

    private DBEntityStore createEntityStore(String classType) throws PersistenceException {
        if (this.factory == null) {
            throw new PersistenceException("EntityFactory is not set up");
        }
        if (!this.tableMap.contains(classType)) {
            throw new PersistenceException("no table maop infomation about " + classType);
        }
        DBClassDescriptorImpl classDesc = (DBClassDescriptorImpl)this.tableMap.getClassDescriptor(classType);
        if (classDesc == null) {
            throw new PersistenceException("class type " + classType + " not available");
        }
        DBEntityStore store = new DBEntityStore(classDesc, this.tableMap.getEntityIdentifiction(classDesc));
        store.setEntityFactory(this.factory);
        DBObjectTableImpl objTab = new DBObjectTableImpl(this.tableMap.getTablename(classDesc), classDesc);
        objTab.setConnectionDelegate(this.delegate);
        store.setDBObjectTable(objTab);
        DBLinkTableDescriptor lnkDesc = this.tableMap.getLinkTableDescriptor(classDesc);
        if (this.lnkTable == null) {
            this.lnkTable = new DBLinkTableImpl(this.tableMap.getLinkTablename(), lnkDesc);
            this.lnkTable.setConnectionDelegate(this.delegate);
        }
        if (this.tableMap.getBlobTable() != null) {
            store.setDBBlobTable(this.tableMap.getBlobTable());
        }
        objTab.setLinkAttributes(this.tableMap.getLinkTablename(), lnkDesc);
        store.setDBLinkTable(this.lnkTable);
        this.entityStoreMap.put(classType, store);
        store.resolveLinks(this);
        return store;
    }

    final DBConnectionDelegate getConnectionDelegate() {
        return this.delegate;
    }

    final Hashtable getEntityStoreMap() {
        return this.entityStoreMap;
    }

    public final DBTableMap getTableMap() {
        return this.tableMap;
    }
}

