/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.TreeOptionType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.persist.jdbc.DBBlobTable;
import com.sap.ip.me.persist.jdbc.DBClassDescriptor;
import com.sap.ip.me.persist.jdbc.DBEntityStoreFactory;
import com.sap.ip.me.persist.jdbc.DBLazyLoadDelegate;
import com.sap.ip.me.persist.jdbc.DBLinkEntry;
import com.sap.ip.me.persist.jdbc.DBLinkTable;
import com.sap.ip.me.persist.jdbc.DBObjectTable;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import java.util.Vector;

final class DBEntityStore
implements DBLazyLoadDelegate {
    private static final LinkItem[] ARRAY_LINKITEM = new LinkItem[0];
    private static final PersistableEntity[] ARRAY_ENTITY2 = new PersistableEntity[0];
    private static final Integer DEF_ENTITYID = new Integer(0);
    static boolean IS_LAZYLOAD = true;
    private final ClassDescriptor classDesc;
    private final Integer baseClassID;
    private final Vector commitList = new Vector();
    private final Vector inUseList = new Vector();
    private EntityFactory entityFactory;
    private DBObjectTable objectTable;
    private DBLinkTable linkTable;
    private DBBlobTable blobTable;
    private LinkItem[] arrLink;
    private boolean inRecursion = false;

    DBEntityStore(DBClassDescriptor classDesc, Object classID) throws PersistenceException {
        if (classDesc == null) {
            throw new NullPointerException("ClassDescriptor is null");
        }
        if (classID == null) {
            throw new NullPointerException("ClassID is null");
        }
        if (!(classID instanceof Integer)) {
            throw new IllegalArgumentException("classID is not an Integer type=" + classID.getClass().getName());
        }
        this.classDesc = classDesc;
        this.baseClassID = (Integer)classID;
    }

    final void setDBObjectTable(DBObjectTable objectTable) {
        if (this.objectTable != null) {
            throw new IllegalStateException("DBObjectTable is already set");
        }
        if (objectTable == null) {
            throw new NullPointerException("DBObjectTable parameter is null");
        }
        this.objectTable = objectTable;
    }

    final void setDBLinkTable(DBLinkTable linkTable) {
        if (this.linkTable != null) {
            throw new IllegalStateException("DBLinkTable is already set");
        }
        if (linkTable == null) {
            throw new NullPointerException("DBLinkTable  parameter is null");
        }
        this.linkTable = linkTable;
    }

    final void setDBBlobTable(DBBlobTable blobTab) {
        if (this.blobTable != null) {
            throw new IllegalStateException("DBBlobTable is already set");
        }
        if (blobTab == null) {
            throw new NullPointerException("DBBlobTable  parameter is null");
        }
        this.blobTable = blobTab;
    }

    final void resolveLinks(DBEntityStoreFactory factory) throws PersistenceException {
        LinkDescriptor[] larr = this.classDesc.getLinkDescriptorArray();
        this.arrLink = larr != null && larr.length > 0 ? this.createLinkItemArray(larr, factory) : ARRAY_LINKITEM;
    }

    static final void setIsLazyLoad(boolean isLazyLoad) {
        IS_LAZYLOAD = isLazyLoad;
    }

    final void setEntityFactory(EntityFactory entityFactory) {
        this.entityFactory = entityFactory;
    }

    final void commit() {
        this.endTransaction(true);
    }

    final void rollback() {
        this.endTransaction(false);
    }

    private final void endTransaction(boolean isCommit) {
        if (!this.inRecursion) {
            this.inRecursion = true;
            this.inUseList.removeAllElements();
            int i = 0;
            int max = this.commitList.size();
            while (i < max) {
                if (isCommit) {
                    ((DBPersistedObject)this.commitList.elementAt(i)).commit();
                } else {
                    ((DBPersistedObject)this.commitList.elementAt(i)).rollback();
                }
                ++i;
            }
            int i2 = 0;
            int max2 = this.arrLink.length;
            while (i2 < max2) {
                this.arrLink[i2].getStore().endTransaction(isCommit);
                ++i2;
            }
            this.commitList.removeAllElements();
            this.inRecursion = false;
        }
    }

    final void clearInUseList() {
        if (!this.inRecursion) {
            this.inRecursion = true;
            this.inUseList.removeAllElements();
            int i = 0;
            int max = this.arrLink.length;
            while (i < max) {
                this.arrLink[i].getStore().clearInUseList();
                ++i;
            }
            this.inRecursion = false;
        }
    }

    private final DBPersistedObject validateEntity(PersistableEntity entity) {
        if (entity == null) {
            throw new NullPointerException("entity paramter is null");
        }
        PersistenceContainer pObj = entity.getPersistedObject();
        if (pObj == null) {
            throw new NullPointerException("PersistedObject from entity is null");
        }
        if (!this.classDesc.getClasstype().equals(pObj.getClasstype())) {
            throw new IllegalArgumentException("classType of entity is invalid type=" + pObj.getClasstype());
        }
        if (!(pObj instanceof DBPersistedObject)) {
            throw new IllegalStateException("invalid type of PersistedObject type=" + pObj.getClass().getName());
        }
        ((DBPersistedObject)pObj).setEntity(entity);
        return (DBPersistedObject)pObj;
    }

    private final boolean matchTreeOptionType(TreeOptionType opt, LinkItem itm) {
        return opt == TreeOptionType.COMPLETE || opt == TreeOptionType.DEPENDENT && itm.isDependent();
    }

    final PersistableEntity get(String entityKey, TreeOptionType option) throws PersistenceException {
        return this.createEntity(this.objectTable.get(entityKey), option);
    }

    private final PersistableEntity createEntity(DBPersistedObject pObj, TreeOptionType option) throws PersistenceException {
        if (pObj == null) {
            return null;
        }
        if (pObj.getEntity() != null) {
            return pObj.getEntity();
        }
        if (IS_LAZYLOAD) {
            pObj.setLazyLoadDelegate(this);
        } else {
            this.getLinks(pObj, option);
        }
        PersistableEntity ent = this.entityFactory.createEntity(pObj);
        pObj.setEntity(ent);
        return ent;
    }

    private final void getLinks(DBPersistedObject pObj, TreeOptionType opt) throws PersistenceException {
        int i = 0;
        int max = this.arrLink.length;
        while (i < max) {
            if (this.matchTreeOptionType(opt, this.arrLink[i])) {
                if (this.arrLink[i].isMultiple()) {
                    pObj.loadMultipleLink(i, this.arrLink[i].getStore().getMultipleLink(pObj, this.arrLink[i].getClID(), opt));
                } else {
                    String key = (String)this.objectTable.getLinkKey(pObj, i);
                    pObj.loadSingleLink(i, this.arrLink[i].getStore().getSingleLink(pObj, key, opt));
                }
            }
            ++i;
        }
    }

    private final PersistableEntity[] getMultipleLink(DBPersistedObject pObj, Object clid, TreeOptionType opt) throws PersistenceException {
        Vector vec = this.objectTable.get(pObj, clid, false);
        if (vec.size() == 0) {
            return ARRAY_ENTITY2;
        }
        PersistableEntity[] arr = new PersistableEntity[vec.size()];
        int i = 0;
        int max = vec.size();
        while (i < max) {
            arr[i] = this.createEntity((DBPersistedObject)vec.elementAt(i), opt);
            ++i;
        }
        return arr;
    }

    private final PersistableEntity getSingleLink(DBPersistedObject pObj, String key, TreeOptionType opt) throws PersistenceException {
        Vector vec = this.objectTable.get(pObj, key, true);
        if (vec.size() == 0) {
            return null;
        }
        if (vec.size() > 1) {
            throw new PersistenceException("multiple single link error");
        }
        return this.createEntity((DBPersistedObject)vec.elementAt(0), opt);
    }

    public PersistableEntity fetchSingleLink(int idx, DBPersistedObject pObj) {
        this.validateSingleLink(idx);
        try {
            String key = (String)this.objectTable.getLinkKey(pObj, idx);
            if (key == null) {
                return null;
            }
            return this.arrLink[idx].getStore().getSingleLink(pObj, key, TreeOptionType.SKELETON);
        }
        catch (PersistenceException pe) {
            StringBuffer errorMsg = new StringBuffer("lazy loading failed for single idx=");
            errorMsg.append(idx).append(" and pkey=").append(pObj.getKey());
            Trace.getInstance("MI/Persistence").log(50, errorMsg.toString());
            Trace.getInstance("MI/Persistence").logException(pe, true);
            throw new RuntimeException(errorMsg.toString());
        }
    }

    public PersistableEntity[] fetchMultipleLink(int idx, DBPersistedObject pObj) {
        this.validateMultipleLink(idx);
        try {
            return this.arrLink[idx].getStore().getMultipleLink(pObj, this.arrLink[idx].getClID(), TreeOptionType.SKELETON);
        }
        catch (PersistenceException pe) {
            throw new RuntimeException("lazy loading failed for multiple idx=" + idx + " and pkey=" + pObj);
        }
    }

    private final void validateSingleLink(int idx) {
        this.validateLinkIndex(idx);
        if (this.classDesc.getLinkDescriptor(idx).getMultiplicity() != MultiplicityType.SINGLE) {
            throw new IllegalArgumentException("link multiplicity type is not simple");
        }
    }

    private final void validateMultipleLink(int idx) {
        this.validateLinkIndex(idx);
        if (this.classDesc.getLinkDescriptor(idx).getMultiplicity() != MultiplicityType.MULTIPLE_VECTOR) {
            throw new IllegalArgumentException("link multiplicity type is not multiple");
        }
    }

    private final void validateLinkIndex(int idx) {
        if (idx < 0 || idx >= this.arrLink.length) {
            throw new IndexOutOfBoundsException("link index=" + idx + " max=" + this.arrLink.length);
        }
    }

    Object getLinkClID(int linkIndex) {
        return this.arrLink[linkIndex].getClID();
    }

    MeIterator get(Query query, TreeOptionType option) throws PersistenceException {
        return this.prepareIterator(this.objectTable.getByQuery(query), option);
    }

    private final MeIterator prepareIterator(Vector vec, TreeOptionType opt) throws PersistenceException {
        Object[] arr = ARRAY_ENTITY2;
        if (vec.size() > 0) {
            arr = new PersistableEntity[vec.size()];
            int i = 0;
            int max = vec.size();
            while (i < max) {
                arr[i] = this.createEntity((DBPersistedObject)vec.elementAt(i), opt);
                ++i;
            }
        }
        return new MeIteratorArrayImpl(arr);
    }

    MeIterator getAll(TreeOptionType option) throws PersistenceException {
        return this.get((Query)null, option);
    }

    boolean contains(String entityKey) throws PersistenceException {
        MeIterator it = this.get((Query)null, TreeOptionType.SKELETON);
        while (it.hasNext()) {
            if (!((PersistableEntity)it.next()).getPersistedObject().getKey().equals(entityKey)) continue;
            return true;
        }
        return false;
    }

    int getCount(Query query) throws PersistenceException {
        return this.objectTable.getCountByQuery(query);
    }

    final void insert(PersistableEntity entity, TreeOptionType option) throws PersistenceException {
        DBPersistedObject pObj = this.validateEntity(entity);
        if (!this.inUseList.contains(pObj.getKey())) {
            this.inUseList.addElement(pObj.getKey());
            this.addToCommitList(pObj);
            pObj.insert();
            this.objectTable.insert(pObj);
            this.modifyLinks(pObj, option);
        }
    }

    final void update(PersistableEntity entity, TreeOptionType option) throws PersistenceException {
        DBPersistedObject pObj = this.validateEntity(entity);
        if (!this.inUseList.contains(pObj.getKey())) {
            this.inUseList.addElement(pObj.getKey());
            this.addToCommitList(pObj);
            this.modifyLinks(pObj, option);
            if (!DBPersistedObject.STATE_NEW.equals(pObj.getState())) {
                if (DBPersistedObject.STATE_MODIFY.equals(pObj.getState())) {
                    this.objectTable.update(pObj);
                    pObj.update();
                } else if (Trace.getInstance("MI/Persistence").isOn()) {
                    Trace.getInstance("MI/Persistence").log("Unneded modify operation wasn't executed for entity with state: " + pObj.getState());
                }
            } else {
                throw new IllegalStateException("tried to modify entity with STATE_NEW");
            }
        }
    }

    void insertOrUpdate(PersistableEntity entity, TreeOptionType option) throws PersistenceException {
        DBPersistedObject pObj = this.validateEntity(entity);
        if (!this.inUseList.contains(pObj.getKey())) {
            if (pObj.getState() == DBPersistedObject.STATE_NEW) {
                if (this.objectTable.isExisting(pObj.getKey())) {
                    pObj.state = DBPersistedObject.STATE_MODIFY;
                    this.update(entity, option);
                } else {
                    this.insert(entity, option);
                }
            } else if (pObj.getState() == DBPersistedObject.STATE_MODIFY) {
                this.update(entity, option);
            } else {
                this.inUseList.addElement(pObj.getKey());
                this.addToCommitList(pObj);
                this.modifyLinks(pObj, option);
            }
        }
    }

    private final void addToCommitList(DBPersistedObject pObj) {
        if (!this.commitList.contains(pObj)) {
            this.commitList.addElement(pObj);
        }
    }

    private final void modifyLinks(DBPersistedObject pObj, TreeOptionType opt) throws PersistenceException {
        this.removeDeletedLinks(pObj);
        int i = 0;
        int max = pObj.sizeLink();
        while (i < max) {
            MeIterator it = pObj.getLinkEntries(i);
            while (it.hasNext()) {
                DBLinkEntry le = (DBLinkEntry)it.next();
                DBPersistedObject po = (DBPersistedObject)le.getEntity().getPersistedObject();
                if (this.matchTreeOptionType(opt, this.arrLink[i])) {
                    this.arrLink[i].getStore().insertOrUpdate(le.getEntity(), opt);
                }
                if (le.getStatus() != DBLinkEntry.LSTAT_NEW) continue;
                MultiplicityType mt = this.classDesc.getLinkDescriptor(le.getIndex()).getMultiplicity();
                if (mt == MultiplicityType.MULTIPLE_VECTOR) {
                    this.arrLink[i].getStore().linkTable.insert(pObj.getKey(), this.arrLink[i].getClID(), po.getKey(), pObj.getClasstype(), po.getClasstype());
                } else if (((DBClassDescriptor)this.classDesc).getSingleLinkCount() > i) {
                    this.objectTable.updateLinkColumn(pObj, le.getIndex(), po.getKey());
                } else {
                    throw new PersistenceException("SingleLink index out of bounds: is " + i + " max: " + ((DBClassDescriptor)this.classDesc).getSingleLinkCount() + "for classtype " + this.classDesc.getClasstype());
                }
                le.persist();
            }
            ++i;
        }
    }

    private final void removeDeletedLinks(DBPersistedObject pObj) throws PersistenceException {
        Vector vec = pObj.getDeletedLinkEntries();
        int i = 0;
        int max = vec.size();
        while (i < max) {
            DBLinkEntry le = (DBLinkEntry)vec.elementAt(i);
            int index = le.getIndex();
            if (this.classDesc.getLinkDescriptor(index).getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR) {
                this.arrLink[index].getStore().linkTable.delete(pObj.getKey(), this.arrLink[index].getClID(), le.getForeignKey(), pObj.getClasstype());
            } else {
                this.objectTable.updateLinkColumn(pObj, index, null);
            }
            ++i;
        }
        pObj.clearDeletionList();
    }

    final void delete(PersistableEntity entity, TreeOptionType option) throws PersistenceException {
        DBPersistedObject pObj = this.validateEntity(entity);
        if (!this.inUseList.contains(pObj.getKey())) {
            this.inUseList.addElement(pObj.getKey());
            this.addToCommitList(pObj);
            this.deleteLinks(pObj, option);
            if (this.linkTable != null) {
                this.linkTable.delete((Object)pObj.getKey(), pObj.getClasstype());
            }
            this.objectTable.delete(pObj);
            pObj.delete();
        }
    }

    private final void deleteLinks(DBPersistedObject pObj, TreeOptionType opt) throws PersistenceException {
        this.removeDeletedLinks(pObj);
        int i = 0;
        int max = pObj.sizeLink();
        while (i < max) {
            if (!this.matchTreeOptionType(opt, this.arrLink[i])) {
                this.arrLink[i].getStore().linkTable.delete((Object)pObj.getKey(), this.arrLink[i].getClID());
            } else {
                pObj.sizeLink(i);
                MeIterator it = pObj.getLinkEntries(i);
                while (it.hasNext()) {
                    DBLinkEntry le = (DBLinkEntry)it.next();
                    DBPersistedObject po = (DBPersistedObject)le.getEntity().getPersistedObject();
                    this.arrLink[i].getStore().delete(le.getEntity(), opt);
                    le.delete();
                }
            }
            ++i;
        }
    }

    void deleteAll(TreeOptionType option) throws PersistenceException {
        this.inRecursion = true;
        this.deleteAllSingleLinks(option);
        this.deleteAllMultipleLinks(option);
        this.objectTable.deleteAll();
        if (this.linkTable != null) {
            this.linkTable.deleteAll(this.classDesc);
        }
        if (this.blobTable != null) {
            this.blobTable.deleteAll(this.classDesc.getClasstype());
        }
        this.inRecursion = false;
    }

    private void deleteAllMultipleLinks(TreeOptionType option) throws PersistenceException {
        int i = 0;
        int max = this.arrLink.length;
        while (i < max) {
            boolean isSingleLink;
            boolean bl = isSingleLink = this.classDesc.getLinkDescriptor(i).getMultiplicity() == MultiplicityType.SINGLE;
            if (this.matchTreeOptionType(option, this.arrLink[i]) && !isSingleLink) {
                this.arrLink[i].getStore().deleteAll(this.arrLink[i].getClID(), option);
            }
            ++i;
        }
    }

    private void deleteAll(Object clid, TreeOptionType option) throws PersistenceException {
        if (!this.inRecursion) {
            this.inRecursion = true;
            this.deleteAllSingleLinks(option);
            this.objectTable.deleteAll(clid);
            this.linkTable.deleteAll(clid);
            this.deleteAllMultipleLinks(option);
            this.inRecursion = false;
        }
    }

    private void deleteAllSingleLinks(TreeOptionType option) throws PersistenceException {
        int i = 0;
        int max = this.arrLink.length;
        while (i < max) {
            boolean isSingleLink;
            boolean bl = isSingleLink = this.classDesc.getLinkDescriptor(i).getMultiplicity() == MultiplicityType.SINGLE;
            if (this.matchTreeOptionType(option, this.arrLink[i]) && isSingleLink) {
                MeIterator keys = this.objectTable.getAllLinkKeys(i);
                while (keys.hasNext()) {
                    PersistableEntity pe = this.arrLink[i].getStore().get((String)keys.next(), TreeOptionType.SKELETON);
                    this.arrLink[i].getStore().delete(pe, option);
                }
            }
            ++i;
        }
    }

    final DBObjectTable objectTable() {
        return this.objectTable;
    }

    final DBLinkTable linkTable() {
        return this.linkTable;
    }

    final int sizeCommitList() {
        return this.commitList.size();
    }

    private final LinkItem[] createLinkItemArray(LinkDescriptor[] larr, DBEntityStoreFactory factory) throws PersistenceException {
        LinkItem[] arr = new LinkItem[larr.length];
        int i = 0;
        int max = larr.length;
        while (i < max) {
            LinkDescriptor desc = larr[i];
            DBEntityStore store = factory.getEntityStore(desc.getClasstype());
            int clid = (this.baseClassID << 9) + (i & 0x1FF);
            arr[i] = new LinkItem(desc, store, new Integer(clid));
            ++i;
        }
        return arr;
    }

    private final class LinkItem {
        private final LinkDescriptor desc;
        private final DBEntityStore store;
        private final Object clid;

        LinkItem(LinkDescriptor desc, DBEntityStore store, Object clid) {
            this.desc = desc;
            this.store = store;
            this.clid = clid;
        }

        final DBEntityStore getStore() {
            return this.store;
        }

        final Object getClID() {
            return this.clid;
        }

        final boolean isDependent() {
            return this.desc.isDependent();
        }

        final boolean isMultiple() {
            return this.desc.getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR;
        }
    }
}

