/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.EntityFactory;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBPersistableEntityAdapter;
import com.sap.ip.me.persist.jdbc.DBPersistedObject;
import com.sap.ip.me.persist.jdbc.DBPersistedObjectAdapter;
import com.sap.ip.me.persist.jdbc.DBPersistenceRuntimeImpl;
import java.util.Hashtable;

public final class DBEntityFactoryAdapter
implements EntityFactory {
    private static Hashtable keyLookupList = new Hashtable(10);

    public PersistableEntity createEntity(PersistenceContainer o) {
        DBPersistableEntityAdapter newAdapter = null;
        if (!(o instanceof DBPersistedObjectAdapter)) {
            DBPersistenceRuntimeImpl runtime = (DBPersistenceRuntimeImpl)PersistenceRuntime.getInstance();
            DBPersistedObjectAdapter poa = new DBPersistedObjectAdapter((ClassDescriptorImpl)runtime.getTransactionManagerAdapter().getClassDescriptorForKey(o.getClasstype()), o.getKey());
            poa.copyAttributes(((DBPersistedObject)o).getAttributes());
            poa.copyLinks(((DBPersistedObject)o).getLinks());
            newAdapter = new DBPersistableEntityAdapter(poa);
        } else {
            newAdapter = new DBPersistableEntityAdapter(o);
        }
        return newAdapter;
    }

    static DBPersistableEntityAdapter getEntity(String key) {
        DBPersistableEntityAdapter newAdapter = new DBPersistableEntityAdapter(key);
        return newAdapter;
    }

    static DBPersistableEntityAdapter getEntity(Entity entity) {
        if (keyLookupList.containsKey(entity.getEntityKey())) {
            return (DBPersistableEntityAdapter)keyLookupList.remove(entity.getEntityKey());
        }
        DBPersistableEntityAdapter newAdapter = new DBPersistableEntityAdapter(entity);
        keyLookupList.put(entity.getEntityKey(), newAdapter);
        keyLookupList.remove(entity.getEntityKey());
        return newAdapter;
    }

    static DBPersistableEntityAdapter getEntity(DBPersistedObjectAdapter pObject) {
        DBPersistableEntityAdapter newAdapter = new DBPersistableEntityAdapter(pObject);
        return newAdapter;
    }
}

