/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBDoubleFormatter
extends DBSqlFormatter {
    public final StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof Double) {
            BigDecimal bd = new BigDecimal((Double)obj);
            bd = bd.setScale(dec, 5);
            buf.append(bd.toString());
            return buf;
        }
        throw new IllegalArgumentException("DOUBLE: invalid value type");
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        BigDecimal res = rset.getBigDecimal(idx, dec);
        if (rset.wasNull()) {
            return null;
        }
        return new Double(res.doubleValue());
    }

    private void checkLenDec(int len, int dec) {
        if (len < dec) {
            throw new IllegalArgumentException("DECIMAL must be longer than LENGTH");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("LENGTH must be larger than zero");
        }
        if (dec < 0) {
            throw new IllegalArgumentException("DECIMAL must not be minus");
        }
        if (len + dec > 31) {
            throw new IllegalArgumentException("DECIMAL plus LENGTH must be smaller than 32");
        }
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        this.checkLenDec(len, dec);
        return buf.append("DECIMAL(").append(len).append(',').append(dec).append(')');
    }
}

