/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.DescriptorException;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.core.InternalDescriptorRuntime;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBLinkDescriptor;
import java.util.Hashtable;

public class DBDescriptorRuntimeImpl
extends DescriptorRuntime
implements InternalDescriptorRuntime {
    private static final DBAttributeDescriptorImpl[] EMPTY_ATTRIBS = new DBAttributeDescriptorImpl[0];
    private static final DBLinkDescriptor[] EMPTY_LINKS = new DBLinkDescriptor[0];
    private final Hashtable classDescriptors = new Hashtable();
    private final int DEFAULT_KEY_LEN;
    private static final String DEFAULT_KEYNAME = "PKEY";
    private static final AttributeType DEFAULT_KEYTYPE = AttributeType.STRING;

    public DBDescriptorRuntimeImpl() {
        int keyLen = 0;
        try {
            keyLen = Integer.parseInt(Configuration.getInstance().getProperty("MobileEngine.Persist.DefaultKeyLength"));
        }
        catch (Throwable t) {
            Trace.getInstance("MI/Persistence").log("Cannot obtain default key length, taking 128 as default");
        }
        this.DEFAULT_KEY_LEN = keyLen > 0 ? keyLen : 128;
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length) throws DescriptorException {
        return this.createAttributeDescriptor(name, type, mult, length, 0, false);
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length, boolean isIndex) throws DescriptorException {
        return this.createAttributeDescriptor(name, type, mult, length, 0, isIndex);
    }

    public AttributeDescriptor createAttributeDescriptor(String name, AttributeType type, int mult, int length, int dec, boolean isIndex) throws DescriptorException {
        return new DBAttributeDescriptorImpl(name, type, mult, length, dec, isIndex);
    }

    public LinkDescriptor createLinkDescriptor(String name, String classtype, MultiplicityType mult, boolean isDependent) throws DescriptorException {
        return new DBLinkDescriptor(name, classtype, mult, isDependent);
    }

    public LinkDescriptor createLinkDescriptor(String name, ClassDescriptor cdes, MultiplicityType mult, boolean isDependent) throws DescriptorException {
        if (cdes == null) {
            throw new DescriptorException("ClassDescriptor is null");
        }
        return this.createLinkDescriptor(name, cdes.getClasstype(), mult, isDependent);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes) throws DescriptorException {
        return this.createClassDescriptor(classtype, attributes, EMPTY_LINKS, this.DEFAULT_KEY_LEN);
    }

    public ClassDescriptor createClassDescriptor(String classtype, LinkDescriptor[] links) throws DescriptorException {
        return this.createClassDescriptor(classtype, EMPTY_ATTRIBS, links, this.DEFAULT_KEY_LEN);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes, LinkDescriptor[] links) throws DescriptorException {
        return this.createClassDescriptor(classtype, attributes, links, this.DEFAULT_KEY_LEN);
    }

    public ClassDescriptor createClassDescriptor(String classtype, AttributeDescriptor[] attributes, LinkDescriptor[] links, int keyLen) throws DescriptorException {
        DBClassDescriptorImpl cd = new DBClassDescriptorImpl(classtype, this.createAttributeDescriptorArray(attributes, this.createDefaultKeyDescriptor(keyLen)), attributes.length, links);
        this.classDescriptors.put(cd.getClasstype(), cd);
        return cd;
    }

    public ClassDescriptor createClassDescriptor(String classtype, int keyPos, AttributeDescriptor[] attributes) {
        DBClassDescriptorImpl cd = new DBClassDescriptorImpl(classtype, this.createAttributeDescriptorArray(attributes), keyPos, (LinkDescriptor[])EMPTY_LINKS);
        this.classDescriptors.put(cd.getClasstype(), cd);
        return cd;
    }

    private final DBAttributeDescriptor[] createAttributeDescriptorArray(AttributeDescriptor[] src) {
        DBAttributeDescriptor[] dst = new DBAttributeDescriptor[src.length];
        int i = 0;
        int max = src.length;
        while (i < max) {
            dst[i] = src[i] instanceof DBAttributeDescriptorImpl ? (DBAttributeDescriptor)src[i] : DBAttributeDescriptorImpl.create(src[i]);
            ++i;
        }
        return dst;
    }

    public ClassDescriptor getClassDescriptor(String classtype) {
        return (ClassDescriptor)this.classDescriptors.get(classtype);
    }

    public boolean containsClassDescriptor(String classtype) {
        return this.classDescriptors.containsKey(classtype);
    }

    private final DBAttributeDescriptor createDefaultKeyDescriptor(int len) {
        return new DBAttributeDescriptorImpl(DEFAULT_KEYNAME, DEFAULT_KEYTYPE, 1, len, 0, true);
    }

    private final DBAttributeDescriptor[] createAttributeDescriptorArray(AttributeDescriptor[] src, AttributeDescriptor key) {
        DBAttributeDescriptor[] dst = new DBAttributeDescriptor[src.length + 1];
        int i = 0;
        int max = src.length;
        while (i < max) {
            dst[i] = src[i] instanceof DBAttributeDescriptorImpl ? (DBAttributeDescriptor)src[i] : DBAttributeDescriptorImpl.create(src[i]);
            ++i;
        }
        dst[src.length] = key instanceof DBAttributeDescriptorImpl ? (DBAttributeDescriptor)key : DBAttributeDescriptorImpl.create(key);
        return dst;
    }
}

