/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBClassTableItem;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import com.sap.ip.me.persist.jdbc.DBTableNotFoundSQLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Vector;

class DBClassTableAdmin {
    private static final String MAP_TABNAME = "MI_TABMAP";
    private static final String CONVID_FIELDNAME = "CONVID";
    private static final String CLASSTYPE_FIELDNAME = "CLASSTYPE";
    private static final String LINKEXIST_FIELDNAME = "LINKEXIST";
    private static final String INCNO_FIELDNAME = "INCNO";
    private static final int MAP_INCNO_POS = 0;
    private static final int MAP_CONVID_POS = 1;
    private static final int MAP_CLASSTYPE_POS = 2;
    private static final int MAP_LINKEXIST_POS = 3;
    private static final DBAttributeDescriptor[] ATT_DESCRIPTORS;
    private Vector rows = new Vector();
    private String convId;
    private static int maxId;
    private DBRepresentor dbRep;

    DBClassTableAdmin(DBRepresentor dbRep, String convId) throws SQLException {
        this.dbRep = dbRep;
        this.convId = convId;
        try {
            this.readValues(MAP_TABNAME, ATT_DESCRIPTORS, ATT_DESCRIPTORS[1], convId);
            maxId = this.getMaxInt(MAP_TABNAME, ATT_DESCRIPTORS[0].getColumnName());
        }
        catch (DBTableNotFoundSQLException e) {
            this.dbRep.createTable(MAP_TABNAME, ATT_DESCRIPTORS);
            maxId = 0;
        }
    }

    private DBAttributeDescriptor[] createAttributeDescriptors() {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            DBAttributeDescriptor[] attDescriptors = new DBAttributeDescriptor[]{(DBAttributeDescriptor)runtime.createAttributeDescriptor(INCNO_FIELDNAME, AttributeType.INTEGER, 1, 10, false), (DBAttributeDescriptor)runtime.createAttributeDescriptor(CONVID_FIELDNAME, AttributeType.STRING, 1, 128, true), (DBAttributeDescriptor)runtime.createAttributeDescriptor(CLASSTYPE_FIELDNAME, AttributeType.STRING, 1, 128, true), (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKEXIST_FIELDNAME, AttributeType.BOOLEAN, 1, 10, false)};
            return attDescriptors;
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException("Attribute descriptors for TableMap could not be created");
        }
    }

    Enumeration elements() {
        return this.rows.elements();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMaxInt(String tablename, String columnname) throws SQLException {
        try {
            int n;
            Statement statement;
            block10: {
                int n2;
                block9: {
                    statement = this.dbRep.getStatement();
                    try {
                        ResultSet rs;
                        block8: {
                            block7: {
                                rs = this.dbRep.executeQuery(statement, this.getStatementForMaxValue(tablename, columnname));
                                try {
                                    if (rs.next()) {
                                        n2 = rs.getInt(1);
                                        Object var7_8 = null;
                                        break block7;
                                    }
                                    n = 0;
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    Object var7_10 = null;
                                    rs.close();
                                    throw throwable;
                                }
                            }
                            rs.close();
                            Object var9_11 = null;
                            break block9;
                        }
                        Object var7_9 = null;
                        rs.close();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        statement.close();
                        throw throwable;
                    }
                }
                statement.close();
                return n2;
            }
            Object var9_12 = null;
            statement.close();
            return n;
        }
        catch (SQLException e) {
            throw this.dbRep.getVerifiedSQLException(e, tablename);
        }
    }

    private String getStatementForMaxValue(String tableName, String columnName) {
        StringBuffer statementStr = new StringBuffer(200);
        statementStr.append("SELECT MAX(").append(columnName);
        statementStr.append(") FROM ").append(tableName);
        Trace.getInstance("MI/Persistence").log(90, statementStr.toString());
        return statementStr.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readValues(String tableName, DBAttributeDescriptor[] attDescs, DBAttributeDescriptor attDesc, String convId) throws SQLException {
        Statement statement = this.dbRep.getStatement();
        try {
            try {
                ResultSet rs = this.dbRep.executeQuery(statement, this.getSelectStatement(tableName, attDesc, convId));
                this.readValues(attDescs, rs);
            }
            catch (SQLException e) {
                throw this.dbRep.getVerifiedSQLException(e, tableName);
            }
            Object var8_8 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    private String getSelectStatement(String tableName, DBAttributeDescriptor whereAttDesc, Object whereValue) throws SQLException {
        StringBuffer statementStr = new StringBuffer(200);
        statementStr.append("SELECT * FROM ").append(tableName);
        if (whereValue != null) {
            statementStr.append(" WHERE ").append(whereAttDesc.getColumnName());
            statementStr.append(" = ");
            whereAttDesc.toSQLValue(statementStr, whereValue);
        }
        Trace.getInstance("MI/Persistence").log(90, statementStr.toString());
        return statementStr.toString();
    }

    private void readValues(DBAttributeDescriptor[] ads, ResultSet rs) throws SQLException {
        while (rs.next()) {
            String classtype = (String)ads[2].toValue(rs, 3);
            int id = (Integer)ads[0].toValue(rs, 1);
            boolean linkexist = (Boolean)ads[3].toValue(rs, 4);
            this.rows.addElement(new MapItem(classtype, id, linkexist));
        }
    }

    int insertTableName(String classtype, boolean linkexist) throws SQLException {
        if (classtype == null) {
            throw new IllegalArgumentException("classtype is null");
        }
        try {
            Object[] insertValues = new Object[]{new Integer(++maxId), this.convId, classtype, new Boolean(linkexist)};
            String insertStatement = this.getInsertValueStatement(MAP_TABNAME, ATT_DESCRIPTORS, insertValues);
            this.dbRep.executeUpdate(insertStatement);
            this.rows.addElement(new MapItem(classtype, maxId, linkexist));
        }
        catch (SQLException e) {
            --maxId;
            throw e;
        }
        return maxId;
    }

    private String getInsertValueStatement(String tablename, DBAttributeDescriptor[] ads, Object[] values) throws SQLException {
        if (ads == null || values == null || ads.length != values.length) {
            throw new RuntimeException("parameter invalid in inserValue!");
        }
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tablename);
        sb.append(" VALUES (");
        int i = 0;
        while (i < ads.length) {
            if (i > 0) {
                sb.append(",");
            }
            ads[i].toSQLValue(sb, values[i]);
            ++i;
        }
        sb.append(")");
        Trace.getInstance("MI/Persistence").log(90, sb.toString());
        return sb.toString();
    }

    void deleteAllTableNames() throws SQLException {
        String deleteAllValueStatement = this.getDeleteAllValueStatement();
        this.dbRep.executeUpdate(deleteAllValueStatement);
    }

    private String getDeleteAllValueStatement() {
        StringBuffer sb = new StringBuffer("DELETE FROM ");
        sb.append(MAP_TABNAME);
        sb.append(" WHERE ").append(CONVID_FIELDNAME);
        sb.append(" = '").append(this.convId).append("'");
        Trace.getInstance("MI/Persistence").log(90, sb.toString());
        return sb.toString();
    }

    static {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            ATT_DESCRIPTORS = new DBAttributeDescriptor[4];
            DBClassTableAdmin.ATT_DESCRIPTORS[0] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(INCNO_FIELDNAME, AttributeType.INTEGER, 1, 10, false);
            DBClassTableAdmin.ATT_DESCRIPTORS[1] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(CONVID_FIELDNAME, AttributeType.STRING, 1, 128, true);
            DBClassTableAdmin.ATT_DESCRIPTORS[2] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(CLASSTYPE_FIELDNAME, AttributeType.STRING, 1, 128, true);
            DBClassTableAdmin.ATT_DESCRIPTORS[3] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(LINKEXIST_FIELDNAME, AttributeType.BOOLEAN, 1, 10, false);
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException("Attribute descriptors for TableMap could not be created");
        }
        maxId = -1;
    }

    private class MapItem
    implements DBClassTableItem {
        private String classtype;
        private int id;
        private boolean linkexist;

        MapItem(String classtype, int id, boolean linkexist) {
            this.classtype = classtype;
            this.id = id;
            this.linkexist = linkexist;
        }

        public String getClassType() {
            return this.classtype;
        }

        public int getId() {
            return this.id;
        }

        public boolean isLinkAttached() {
            return this.linkexist;
        }
    }
}

