/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;

public abstract class DBClassDescriptor
extends ClassDescriptorImpl
implements ClassDescriptor {
    private int singleLinkCount = 0;

    DBClassDescriptor(String classtype, DBAttributeDescriptor[] attributes, int keyPos, LinkDescriptor[] links) {
        super(classtype, DBClassDescriptor.createAttributesArray(attributes), keyPos, links);
        this.countSingleLinks(links);
    }

    private static final AttributeDescriptor[] createAttributesArray(DBAttributeDescriptor[] buf) {
        AttributeDescriptor[] att = new AttributeDescriptor[buf.length];
        System.arraycopy(buf, 0, att, 0, buf.length);
        return att;
    }

    public DBAttributeDescriptor[] getDBAttributeDescriptorArray() {
        AttributeDescriptor[] att = super.getAttributeDescriptorArray();
        DBAttributeDescriptor[] dbatt = new DBAttributeDescriptor[att.length];
        System.arraycopy(att, 0, dbatt, 0, att.length);
        return dbatt;
    }

    public int getSingleLinkCount() {
        return this.singleLinkCount;
    }

    private void countSingleLinks(LinkDescriptor[] links) {
        int i = 0;
        while (i < links.length) {
            if (links[i].getMultiplicity() == MultiplicityType.SINGLE) {
                ++this.singleLinkCount;
            }
            ++i;
        }
    }
}

