/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBlobHandle;
import com.sap.ip.me.persist.jdbc.DBBlobHandleImpl;
import com.sap.ip.me.persist.jdbc.DBBlobTable;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

final class DBBlobTableImpl
implements DBBlobTable {
    private static final String KEY_FIELDNAME = "BLOBKEY";
    private static final String CLASSTYPE_FIELDNAME = "CLASSTYPE";
    private static final DBAttributeDescriptor[] ATT_DESCRIPTORS;
    private int maxKey = -1;
    private DBRepresentor dbRep;
    private final String tableName;

    public DBBlobTableImpl(String name, DBRepresentor representor) throws SQLException {
        representor.createBlobTable(name, ATT_DESCRIPTORS);
        this.dbRep = representor;
        this.tableName = name;
        this.maxKey = this.readMaxKey();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DBBlobHandle insert(byte[] blob, String classtype) throws SQLException {
        if (classtype == null) {
            throw new IllegalArgumentException("classtype is null");
        }
        Connection con = this.dbRep.getConnection();
        PreparedStatement insertStatement = con.prepareStatement(this.getPreparedInsertStatement());
        try {
            try {
                ++this.maxKey;
                insertStatement.setInt(1, this.maxKey);
                insertStatement.setString(2, classtype);
                insertStatement.setBytes(3, blob);
                insertStatement.execute();
            }
            catch (SQLException e) {
                --this.maxKey;
                this.processSQLException(e, "Insert into MI_BLOBTAB ");
                throw e;
            }
            Object var7_5 = null;
            if (insertStatement == null) return new DBBlobHandleImpl(this.maxKey, this);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (insertStatement == null) throw throwable;
            insertStatement.close();
            throw throwable;
        }
        insertStatement.close();
        return new DBBlobHandleImpl(this.maxKey, this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(int key, byte[] blob) throws SQLException {
        Connection con = this.dbRep.getConnection();
        PreparedStatement updateStatement = con.prepareStatement(this.getPreparedUpdateStatement(key));
        try {
            try {
                updateStatement.setBytes(1, blob);
                updateStatement.execute();
            }
            catch (SQLException e) {
                this.processSQLException(e, "Update MI_BLOBTAB key=" + key);
                throw e;
            }
            Object var7_5 = null;
            if (updateStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (updateStatement == null) throw throwable;
            updateStatement.close();
            throw throwable;
        }
        updateStatement.close();
    }

    public void delete(int key) throws SQLException {
        try {
            this.dbRep.executeUpdate(this.getDeleteStatement(key));
        }
        catch (SQLException e) {
            this.processSQLException(e, "Delete from MI_BLOBTAB key=" + key);
            throw e;
        }
    }

    public void deleteAll(String classtype) throws PersistenceException {
        try {
            this.dbRep.executeUpdate(this.getDeleteAllStatement(classtype));
        }
        catch (SQLException e) {
            this.processSQLException(e, "Delete from MI_BLOBTAB classtype=" + classtype);
            throw new PersistenceException("Database Error during BlobTable.deleteAll for classtype:" + classtype);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBlob(int key) throws SQLException, PersistenceException {
        byte[] byArray;
        Statement stmt = this.dbRep.getStatement();
        try {
            try {
                ResultSet rs = stmt.executeQuery(this.getSelectStatement(key));
                if (!rs.next()) {
                    rs.close();
                    throw new PersistenceException("No blob found for key " + key);
                }
                byArray = rs.getBytes(1);
                Object var6_6 = null;
                if (stmt == null) return byArray;
            }
            catch (SQLException e) {
                this.processSQLException(e, "Select from MI_BLOBTAB key=" + key);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (stmt == null) throw throwable;
            stmt.close();
            throw throwable;
        }
        stmt.close();
        return byArray;
    }

    private String getPreparedInsertStatement() throws SQLException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("insert into ").append(this.tableName).append(" (");
        sb.append(KEY_FIELDNAME).append(",").append(CLASSTYPE_FIELDNAME);
        sb.append(",BLOBJECT) values (?,?,?)");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getPreparedUpdateStatement(int key) throws SQLException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("update ").append(this.tableName).append(" set BLOBJECT = ? where BLOBKEY = ");
        sb.append(key);
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getDeleteStatement(int key) throws SQLException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("delete from ").append(this.tableName).append(" where BLOBKEY = ");
        sb.append(key);
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getDeleteAllStatement(String classtype) throws SQLException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("delete from ").append(this.tableName).append(" where ");
        sb.append(CLASSTYPE_FIELDNAME).append(" ='");
        sb.append(classtype).append("'");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private String getSelectStatement(int key) throws SQLException {
        StringBuffer sb = new StringBuffer(128);
        sb.append("select BLOBJECT from ").append(this.tableName).append(" where BLOBKEY = ");
        sb.append(key);
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int readMaxKey() throws SQLException {
        try {
            int n;
            Statement statement;
            block10: {
                int n2;
                block9: {
                    statement = this.dbRep.getStatement();
                    try {
                        ResultSet rs;
                        block8: {
                            block7: {
                                rs = this.dbRep.executeQuery(statement, this.getStatementForMaxValue());
                                try {
                                    if (rs.next()) {
                                        n2 = rs.getInt(1);
                                        Object var5_6 = null;
                                        break block7;
                                    }
                                    n = 0;
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    Object var5_8 = null;
                                    rs.close();
                                    throw throwable;
                                }
                            }
                            rs.close();
                            Object var7_9 = null;
                            break block9;
                        }
                        Object var5_7 = null;
                        rs.close();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var7_11 = null;
                        statement.close();
                        throw throwable;
                    }
                }
                statement.close();
                return n2;
            }
            Object var7_10 = null;
            statement.close();
            return n;
        }
        catch (SQLException e) {
            throw this.dbRep.getVerifiedSQLException(e, this.tableName);
        }
    }

    private String getStatementForMaxValue() {
        StringBuffer statementStr = new StringBuffer(200);
        statementStr.append("SELECT MAX(").append(KEY_FIELDNAME).append(") from ").append(this.tableName);
        String sqlStr = statementStr.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private final void processSQLException(SQLException sqe, String msg) {
        Trace.getInstance("MI/Persistence").logException(sqe, true);
        Trace.getInstance("MI/Persistence").log(msg + " - error code: {0} SQL state: {1} Message: {2}", (Object)Integer.toString(sqe.getErrorCode()), (Object)sqe.getSQLState(), (Object)sqe.getMessage());
    }

    static {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            ATT_DESCRIPTORS = new DBAttributeDescriptor[2];
            DBBlobTableImpl.ATT_DESCRIPTORS[0] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(KEY_FIELDNAME, AttributeType.INTEGER, 1, 10, true);
            DBBlobTableImpl.ATT_DESCRIPTORS[1] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(CLASSTYPE_FIELDNAME, AttributeType.STRING, 1, 128, false);
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException("Attribute descriptors for BlobTable could not be created");
        }
    }
}

