/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.logging.AppLog;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.api.persist.meta.DescriptorRuntime;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import com.sap.ip.me.persist.jdbc.DBTableNotFoundSQLException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;

class DBBlobTableAdmin {
    private static final String MAP_TABNAME = "MI_BLOBMAP";
    private static final String CONVID_FIELDNAME = "CONVID";
    private static final String TABLE_FIELDNAME = "TABLEINDEX";
    private static final int MAP_CONVID_POS = 0;
    private static final int MAP_TABLENAME_POS = 1;
    private static final DBAttributeDescriptor[] ATT_DESCRIPTORS;
    private Hashtable map = new Hashtable(10);
    private int maxId = 0;
    private DBRepresentor dbRep;

    DBBlobTableAdmin(DBRepresentor dbRep) throws SQLException {
        this.dbRep = dbRep;
        try {
            this.readValues(MAP_TABNAME, ATT_DESCRIPTORS);
            this.maxId = this.getMaxInt(MAP_TABNAME, ATT_DESCRIPTORS[1].getColumnName());
        }
        catch (DBTableNotFoundSQLException e) {
            this.dbRep.createTable(MAP_TABNAME, ATT_DESCRIPTORS);
        }
    }

    private DBAttributeDescriptor[] createAttributeDescriptors() {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            DBAttributeDescriptor[] attDescriptors = new DBAttributeDescriptor[]{(DBAttributeDescriptor)runtime.createAttributeDescriptor(CONVID_FIELDNAME, AttributeType.STRING, 1, 128, true), (DBAttributeDescriptor)runtime.createAttributeDescriptor(TABLE_FIELDNAME, AttributeType.STRING, 1, 128, false)};
            return attDescriptors;
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException("Attribute descriptors for BlobTableMap could not be created");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMaxInt(String tablename, String columnname) throws SQLException {
        try {
            int n;
            Statement statement;
            block10: {
                int n2;
                block9: {
                    statement = this.dbRep.getStatement();
                    try {
                        ResultSet rs;
                        block8: {
                            block7: {
                                rs = this.dbRep.executeQuery(statement, this.getStatementForMaxValue(tablename, columnname));
                                try {
                                    if (rs.next()) {
                                        n2 = rs.getInt(1);
                                        Object var7_8 = null;
                                        break block7;
                                    }
                                    n = 0;
                                    break block8;
                                }
                                catch (Throwable throwable) {
                                    Object var7_10 = null;
                                    rs.close();
                                    throw throwable;
                                }
                            }
                            rs.close();
                            Object var9_11 = null;
                            break block9;
                        }
                        Object var7_9 = null;
                        rs.close();
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        statement.close();
                        throw throwable;
                    }
                }
                statement.close();
                return n2;
            }
            Object var9_12 = null;
            statement.close();
            return n;
        }
        catch (SQLException e) {
            throw this.dbRep.getVerifiedSQLException(e, tablename);
        }
    }

    private String getStatementForMaxValue(String tableName, String columnName) {
        StringBuffer statementStr = new StringBuffer(200);
        statementStr.append("SELECT MAX(").append(columnName);
        statementStr.append(") FROM ").append(tableName);
        String sqlStr = statementStr.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    Enumeration elements() {
        return this.map.elements();
    }

    int getTableIndex(String convId) {
        Object temp = this.map.get(convId);
        if (temp != null) {
            return (Integer)this.map.get(convId);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readValues(String tableName, DBAttributeDescriptor[] attDescs) throws SQLException {
        Statement statement = this.dbRep.getStatement();
        try {
            try {
                ResultSet rs = this.dbRep.executeQuery(statement, this.getSelectStatement(tableName));
                this.readValues(attDescs, rs);
            }
            catch (SQLException e) {
                throw this.dbRep.getVerifiedSQLException(e, tableName);
            }
            Object var6_6 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    private String getSelectStatement(String tableName) throws SQLException {
        StringBuffer statementStr = new StringBuffer(200);
        statementStr.append("SELECT * FROM ").append(tableName);
        String sqlStr = statementStr.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    private void readValues(DBAttributeDescriptor[] ads, ResultSet rs) throws SQLException {
        while (rs.next()) {
            String convId = (String)ads[0].toValue(rs, 1);
            Integer tabname = (Integer)ads[1].toValue(rs, 2);
            this.map.put(convId, tabname);
        }
    }

    int insertTableName(String convId) throws SQLException {
        if (convId == null) {
            throw new IllegalArgumentException("ConvId is null");
        }
        ++this.maxId;
        Integer tableindex = new Integer(this.maxId);
        Object[] insertValues = new Object[]{convId, tableindex};
        String insertStatement = this.getInsertValueStatement(MAP_TABNAME, ATT_DESCRIPTORS, insertValues);
        this.dbRep.executeUpdate(insertStatement);
        this.map.put(convId, tableindex);
        return tableindex;
    }

    private String getInsertValueStatement(String tablename, DBAttributeDescriptor[] ads, Object[] values) throws SQLException {
        if (ads == null || values == null || ads.length != values.length) {
            throw new RuntimeException("parameter invalid in insertValue!");
        }
        StringBuffer sb = new StringBuffer("INSERT INTO ");
        sb.append(tablename);
        sb.append(" VALUES (");
        int i = 0;
        while (i < ads.length) {
            if (i > 0) {
                sb.append(",");
            }
            ads[i].toSQLValue(sb, values[i]);
            ++i;
        }
        sb.append(")");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    void deleteTableName(String convId) throws SQLException {
        String deleteAllValueStatement = this.getDeleteValueStatement(convId);
        this.dbRep.executeUpdate(deleteAllValueStatement);
        Object number = this.map.remove(convId);
        this.maxId = this.getMaxInt(MAP_TABNAME, ATT_DESCRIPTORS[1].getColumnName());
    }

    private String getDeleteValueStatement(String convId) {
        StringBuffer sb = new StringBuffer("DELETE FROM ");
        sb.append(MAP_TABNAME);
        sb.append(" WHERE ").append(CONVID_FIELDNAME);
        sb.append(" = '").append(convId).append("'");
        String sqlStr = sb.toString();
        Trace.getInstance("MI/Persistence").log(90, sqlStr);
        return sqlStr;
    }

    static {
        try {
            DescriptorRuntime runtime = DescriptorRuntime.getInstance();
            ATT_DESCRIPTORS = new DBAttributeDescriptor[2];
            DBBlobTableAdmin.ATT_DESCRIPTORS[0] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(CONVID_FIELDNAME, AttributeType.STRING, 1, 128, true);
            DBBlobTableAdmin.ATT_DESCRIPTORS[1] = (DBAttributeDescriptor)runtime.createAttributeDescriptor(TABLE_FIELDNAME, AttributeType.INTEGER, 1, 10, false);
        }
        catch (Exception e) {
            AppLog.getInstance("MI/Persistence").logException(e, true);
            throw new RuntimeException("Attribute descriptors for BlobTableMap could not be created");
        }
    }
}

