/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.persist.jdbc.DBBlobHandle;
import com.sap.ip.me.persist.jdbc.DBBlobTable;
import java.sql.SQLException;

public class DBBlobHandleImpl
implements DBBlobHandle {
    private final DBBlobTable blobTable;
    private final int key;
    private boolean isValid;

    DBBlobHandleImpl(int key, DBBlobTable table) {
        this.key = key;
        this.blobTable = table;
        this.isValid = true;
    }

    public byte[] getBytes() throws RuntimeException {
        byte[] blob = null;
        try {
            if (!this.isValid) {
                throw new RuntimeException("getBytes() called for Blob with invalid state");
            }
            blob = this.blobTable.getBlob(this.key);
        }
        catch (SQLException e) {
            throw new NestableRuntimeException("Database Error during read from blob table", e);
        }
        catch (PersistenceException f) {
            throw new NestableRuntimeException(f);
        }
        return blob;
    }

    public void update(byte[] blob) throws RuntimeException {
        try {
            if (!this.isValid) {
                throw new RuntimeException("update() called on BlobHandle with invalid state");
            }
            this.blobTable.update(this.key, blob);
        }
        catch (SQLException e) {
            throw new NestableRuntimeException("Database Error during update of blob table", e);
        }
    }

    public void delete() throws RuntimeException {
        this.isValid = false;
        try {
            this.blobTable.delete(this.key);
        }
        catch (SQLException e) {
            throw new NestableRuntimeException("Database Error during delete from blob table", e);
        }
    }

    public int getKey() {
        return this.key;
    }

    public final boolean equals(Object comp) {
        if (comp == this) {
            return true;
        }
        return comp instanceof DBBlobHandleImpl && this.key == ((DBBlobHandle)comp).getKey();
    }
}

