/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBBigIntegerFormatter
extends DBSqlFormatter {
    public final StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof BigInteger) {
            String s;
            buf.append("'");
            if (((BigInteger)obj).signum() < 0) {
                buf.append('-');
                s = this.complementOf(obj, len);
            } else {
                s = ((BigInteger)obj).abs().toString();
            }
            int zeros = len - s.length();
            StringBuffer zeroString = new StringBuffer(zeros + 1);
            int i = 0;
            while (i < zeros) {
                zeroString.append('0');
                ++i;
            }
            buf.append((Object)zeroString);
            buf.append(s);
            buf.append("'");
            return buf;
        }
        throw new IllegalArgumentException("BIGINTEGER: invalid value type " + obj.getClass().getName());
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        String st = rset.getString(idx);
        if (rset.wasNull()) {
            return null;
        }
        if (st.charAt(0) == '-') {
            return new BigInteger("-" + this.complementOf(new BigInteger(st), len));
        }
        return new BigInteger(st);
    }

    private final String complementOf(Object obj, int len) {
        int length = len + 1;
        char[] baseC = new char[length];
        baseC[0] = 49;
        int i = 1;
        while (i < length) {
            baseC[i] = 48;
            ++i;
        }
        BigInteger base = new BigInteger(new String(baseC));
        return base.subtract(((BigInteger)obj).abs()).toString();
    }

    private void checkLenDec(int len) {
        if (len <= 0) {
            throw new IllegalArgumentException("LENGTH must be larger than zero");
        }
        if (len > 32766) {
            throw new IllegalArgumentException("LENGTH must be smaller than 32766");
        }
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        this.checkLenDec(len);
        return buf.append("VARCHAR(").append(len + 1).append(")");
    }
}

