/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.persist.jdbc.DBSqlFormatter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBBigDecimalFormatter
extends DBSqlFormatter {
    public final StringBuffer internalToSQLValue(StringBuffer buf, Object obj, int len, int dec) throws SQLException {
        if (obj instanceof BigDecimal) {
            String s;
            obj = ((BigDecimal)obj).setScale(dec, 5);
            buf.append("'");
            if (((BigDecimal)obj).signum() < 0) {
                buf.append('-');
                s = this.complementOf(obj, len, dec);
            } else {
                s = ((BigDecimal)obj).abs().toString();
                if (s.length() > len + 3) {
                    throw new IllegalArgumentException("BIGDECIMAL: value has more digits as specified in meta data");
                }
            }
            int zeros = s.indexOf(46) == -1 ? len - s.length() : len - s.indexOf(46) - dec;
            StringBuffer zeroString = new StringBuffer(zeros);
            int i = 0;
            while (i < zeros) {
                zeroString.append('0');
                ++i;
            }
            buf.append(zeroString.toString());
            if (s.indexOf(46) == -1) {
                buf.append(s).append(".0");
            } else {
                buf.append(s);
            }
            buf.append("'");
            return buf;
        }
        throw new IllegalArgumentException("BIGDECIMAL: invalid value type " + obj.getClass().getName());
    }

    private final String complementOf(Object obj, int len, int dec) {
        int length = len - dec + 1;
        char[] baseC = new char[length];
        baseC[0] = 49;
        int i = 1;
        while (i < length) {
            baseC[i] = 48;
            ++i;
        }
        BigDecimal base = new BigDecimal(new String(baseC));
        return base.subtract(((BigDecimal)obj).abs()).toString();
    }

    public final Object toValue(ResultSet rset, int idx, int len, int dec) throws SQLException {
        String st = rset.getString(idx);
        if (rset.wasNull()) {
            return null;
        }
        if (st.charAt(0) == '-') {
            return new BigDecimal("-" + this.complementOf(new BigDecimal(st), len, dec));
        }
        return new BigDecimal(st);
    }

    private void checkLenDec(int len, int dec) {
        if (len < dec) {
            throw new IllegalArgumentException("LENGTH must be longer than DECIMALS");
        }
        if (len <= 0) {
            throw new IllegalArgumentException("LENGTH must be larger than zero");
        }
        if (dec < 0) {
            throw new IllegalArgumentException("DECIMALS must not be negative");
        }
    }

    public final StringBuffer toMetaCreate(StringBuffer buf, int len, int dec) {
        this.checkLenDec(len, dec);
        return buf.append("VARCHAR(").append(len + 3).append(')');
    }
}

