/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.jdbc;

import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.AttributeType;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.persist.core.AttributeDescriptorImpl;
import com.sap.ip.me.persist.jdbc.DBAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBinaryAttributeDescriptor;
import com.sap.ip.me.persist.jdbc.DBBlobHandle;
import com.sap.ip.me.persist.jdbc.DBRepresentor;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DBAttributeDescriptorImpl
extends AttributeDescriptorImpl
implements DBAttributeDescriptor,
DBBinaryAttributeDescriptor {
    private String colName;
    private static DBRepresentor representor;

    DBAttributeDescriptorImpl(String name, AttributeType type, int mult, int length, int dec, boolean isIndex) {
        super(name, type, mult, length, dec, isIndex);
    }

    static final DBAttributeDescriptor create(AttributeDescriptor desc) {
        return new DBAttributeDescriptorImpl(desc.getName(), desc.getType(), desc.getMultiple(), desc.getLength(), desc.getDecimals(), desc.isIndex());
    }

    public final void setColumnName(String colName) {
        this.colName = colName;
    }

    public final String getColumnName() {
        return this.colName == null ? super.getName() : this.colName;
    }

    public final String getColumnName(int i) {
        if (i < 0 || i >= super.getMultiple()) {
            throw new IllegalArgumentException("ColumnName: index is out of range");
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append(this.colName).append('_').append(i);
        return sb.toString();
    }

    public StringBuffer toSQLValue(StringBuffer buf, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValue(buf, obj, this.getLength(), this.getDecimals());
    }

    public StringBuffer toSQLValueStartsWith(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValueStartsWith(buffer, obj, this.getLength(), this.getDecimals());
    }

    public StringBuffer toSQLValueContains(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValueContains(buffer, obj, this.getLength(), this.getDecimals());
    }

    public Object toValue(ResultSet rset, int idx) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toValue(rset, idx, this.getLength(), this.getDecimals());
    }

    public String toMetaCreate() {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        StringBuffer buf = new StringBuffer(32);
        if (this.getMultiple() == 1) {
            buf.append(this.getColumnName()).append(' ');
            representor.getFormatter(this.getType()).toMetaCreate(buf, this.getLength(), this.getDecimals());
        } else {
            int m = 0;
            int mmax = this.getMultiple();
            while (m < mmax) {
                if (m > 0) {
                    buf.append(',');
                }
                buf.append(this.toMetaCreate(m));
                ++m;
            }
        }
        return buf.toString();
    }

    public String toMetaCreate(int idx) {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        StringBuffer buf = new StringBuffer(32);
        buf.append(this.getColumnName(idx)).append(' ');
        representor.getFormatter(this.getType()).toMetaCreate(buf, super.getLength(), super.getDecimals());
        return buf.toString();
    }

    public static void setDBRepresentor(DBRepresentor rep) {
        representor = rep;
    }

    public StringBuffer toSQLValueLike(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValueLike(buffer, obj, this.getLength(), this.getDecimals());
    }

    public StringBuffer toSQLValueAsterisk(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValueAsterisk(buffer, obj, this.getLength(), this.getDecimals());
    }

    public StringBuffer appendWithUpper(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLUpperCase(buffer, obj);
    }

    public StringBuffer toSQLValueUpper(StringBuffer buffer, Object obj) throws SQLException {
        if (representor == null) {
            throw new NullPointerException("DBRepresentor is not set");
        }
        return representor.getFormatter(this.getType()).toSQLValueUpper(buffer, obj, this.getLength(), this.getDecimals());
    }

    public DBBlobHandle toBlobHandle(byte[] blob, String classtype) {
        DBBlobHandle handle = null;
        try {
            handle = representor.getBlobTable().insert(blob, classtype);
        }
        catch (SQLException e) {
            throw new NestableRuntimeException(e);
        }
        return handle;
    }
}

