/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.smartsync.FixedDecimal;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;

final class TypeConverter {
    private static final byte[] intConvBytes = new byte[4];

    TypeConverter() {
    }

    static void intoByte(String s, byte[] target, int offset, int len) throws PersistenceException {
        try {
            if (s != null) {
                int sEnd = s.length();
                if (sEnd < len) {
                    System.arraycopy(s.getBytes("UTF8"), 0, target, offset, sEnd);
                    target[offset + sEnd] = -1;
                } else {
                    System.arraycopy(s.getBytes("UTF8"), 0, target, offset, len);
                }
            } else {
                target[offset] = -1;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new PersistenceException(e);
        }
    }

    static void intoByte(String s, byte[] target, int offset) throws PersistenceException {
        TypeConverter.intoByte(s, target, offset, s.length());
    }

    static byte[] toByte(String s, int len) throws PersistenceException {
        byte[] b = new byte[len];
        TypeConverter.intoByte(s, b, 0, len);
        return b;
    }

    static String toString(byte[] b, int offset, int len) throws PersistenceException {
        try {
            int end = offset + len;
            int x = offset;
            while (x < end) {
                if (b[x] == -1) {
                    return new String(b, offset, x - offset, "UTF8");
                }
                ++x;
            }
            return new String(b, offset, len, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new PersistenceException(e);
        }
    }

    static int toInt(byte[] b, int offset) {
        return (b[offset++] & 0xFF) << 24 | (b[offset++] & 0xFF) << 16 | (b[offset++] & 0xFF) << 8 | b[offset] & 0xFF;
    }

    static byte[] intoByte(int val, byte[] b, int offset) {
        b[offset++] = (byte)(val >>> 24);
        b[offset++] = (byte)(val >>> 16);
        b[offset++] = (byte)(val >>> 8);
        b[offset] = (byte)(val >>> 0);
        return b;
    }

    static byte[] toByte(int val) {
        return TypeConverter.intoByte(val, intConvBytes, 0);
    }

    private static int intoByte(byte[] b, byte[] target, int offset, int length) throws PersistenceException {
        int k = target.length - offset;
        int l = k >= length ? length : k;
        System.arraycopy(b, 0, target, offset, l);
        return offset + length;
    }

    private static byte[] tobytes(byte[] target, int offset, int length) throws PersistenceException {
        int k = target.length - offset;
        int l = k >= length ? length : k;
        byte[] bytes = new byte[l];
        System.arraycopy(target, offset, bytes, 0, l);
        return bytes;
    }

    private static int intoByte(byte b, byte[] target, int offset) throws PersistenceException {
        target[offset++] = b;
        return offset;
    }

    private static byte tobyte(byte[] target, int offset) throws PersistenceException {
        return target[offset++];
    }

    private static int intoByte(Byte b, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte((byte)b, target, offset);
    }

    private static Byte toByte(byte[] target, int offset) throws PersistenceException {
        return new Byte(TypeConverter.tobyte(target, offset));
    }

    private static int intoByte(boolean b, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte(b ? (byte)1 : 0, target, offset);
    }

    private static boolean toboolean(byte[] target, int offset) throws PersistenceException {
        return TypeConverter.tobyte(target, offset) == 1;
    }

    private static int intoByte(Boolean b, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte((boolean)b, target, offset);
    }

    private static Boolean toBoolean(byte[] target, int offset) throws PersistenceException {
        return new Boolean(TypeConverter.toboolean(target, offset));
    }

    private static int intoByte(double d, byte[] target, int offset) throws PersistenceException {
        long value = Double.doubleToLongBits(d);
        target[offset++] = (byte)(value >>> 56);
        target[offset++] = (byte)(value >>> 48);
        target[offset++] = (byte)(value >>> 40);
        target[offset++] = (byte)(value >>> 32);
        target[offset++] = (byte)(value >>> 24);
        target[offset++] = (byte)(value >>> 16);
        target[offset++] = (byte)(value >>> 8);
        target[offset++] = (byte)(value >>> 0);
        return offset;
    }

    private static double todouble(byte[] target, int offset) throws PersistenceException {
        return Double.longBitsToDouble((((long)target[offset++] & 0xFFL) << 56) + (((long)target[offset++] & 0xFFL) << 48) + (((long)target[offset++] & 0xFFL) << 40) + (((long)target[offset++] & 0xFFL) << 32) + (((long)target[offset++] & 0xFFL) << 24) + (((long)target[offset++] & 0xFFL) << 16) + (((long)target[offset++] & 0xFFL) << 8) + (((long)target[offset++] & 0xFFL) << 0));
    }

    private static int intoByte(Double d, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte((double)d, target, offset);
    }

    private static Double toDouble(byte[] target, int offset) throws PersistenceException {
        return new Double(TypeConverter.todouble(target, offset));
    }

    private static int intoByte(float f, byte[] target, int offset) throws PersistenceException {
        int value = Float.floatToIntBits(f);
        target[offset++] = (byte)(value >>> 24);
        target[offset++] = (byte)(value >>> 16);
        target[offset++] = (byte)(value >>> 8);
        target[offset++] = (byte)(value >>> 0);
        return offset;
    }

    private static float tofloat(byte[] target, int offset) throws PersistenceException {
        return Float.intBitsToFloat(((target[offset++] & 0xFF) << 24) + ((target[offset++] & 0xFF) << 16) + ((target[offset++] & 0xFF) << 8) + ((target[offset++] & 0xFF) << 0));
    }

    private static int intoByte(Float f, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte(f.floatValue(), target, offset);
    }

    private static Float toFloat(byte[] target, int offset) throws PersistenceException {
        return new Float(TypeConverter.tofloat(target, offset));
    }

    private static int intoByte(Integer i, byte[] target, int offset) throws PersistenceException {
        TypeConverter.intoByte((int)i, target, offset);
        return offset + 4;
    }

    private static Integer toInteger(byte[] target, int offset) throws PersistenceException {
        return new Integer(TypeConverter.toInt(target, offset));
    }

    private static int intoByte(long l, byte[] target, int offset) throws PersistenceException {
        target[offset++] = (byte)(l >>> 56);
        target[offset++] = (byte)(l >>> 48);
        target[offset++] = (byte)(l >>> 40);
        target[offset++] = (byte)(l >>> 32);
        target[offset++] = (byte)(l >>> 24);
        target[offset++] = (byte)(l >>> 16);
        target[offset++] = (byte)(l >>> 8);
        target[offset++] = (byte)(l >>> 0);
        return offset;
    }

    private static long tolong(byte[] target, int offset) throws PersistenceException {
        return (((long)target[offset++] & 0xFFL) << 56) + (((long)target[offset++] & 0xFFL) << 48) + (((long)target[offset++] & 0xFFL) << 40) + (((long)target[offset++] & 0xFFL) << 32) + (((long)target[offset++] & 0xFFL) << 24) + (((long)target[offset++] & 0xFFL) << 16) + (((long)target[offset++] & 0xFFL) << 8) + (((long)target[offset++] & 0xFFL) << 0);
    }

    private static int intoByte(Long l, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte((long)l, target, offset);
    }

    private static Long toLong(byte[] target, int offset) throws PersistenceException {
        return new Long(TypeConverter.tolong(target, offset));
    }

    private static int intoByte(short s, byte[] target, int offset) throws PersistenceException {
        target[offset++] = (byte)(s >>> 8);
        target[offset++] = (byte)(s >>> 0);
        return offset;
    }

    private static short toshort(byte[] target, int offset) throws PersistenceException {
        return (short)(((target[offset++] & 0xFF) << 8) + ((target[offset++] & 0xFF) << 0));
    }

    private static int intoByte(Short s, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte((short)s, target, offset);
    }

    private static Short toShort(byte[] target, int offset) throws PersistenceException {
        return new Short(TypeConverter.toshort(target, offset));
    }

    private static int intoByte(Calendar c, byte[] target, int offset) throws PersistenceException {
        return TypeConverter.intoByte(c.getTime().getTime(), target, offset);
    }

    private static Calendar toCalendar(byte[] target, int offset) throws PersistenceException {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(TypeConverter.tolong(target, offset)));
        return c;
    }

    private static int intoByte(FixedDecimal dec, byte[] target, int offset) throws PersistenceException {
        int length = dec.getLength();
        TypeConverter.intoByte(length, target, offset);
        TypeConverter.intoByte(dec.getDecimals(), target, offset += 4);
        TypeConverter.intoByte(dec.toString(), target, offset += 4, length);
        return offset + length;
    }

    private static FixedDecimal toFixedDecimal(byte[] target, int offset) throws PersistenceException {
        int length = TypeConverter.toInt(target, offset);
        int dec = TypeConverter.toInt(target, offset += 4);
        String str = TypeConverter.toString(target, offset += 4, length);
        return new FixedDecimal(str, length, dec);
    }

    private static void printBits(int i) {
        StringBuffer sb = new StringBuffer(32);
        int x = 31;
        while (x >= 0) {
            sb.append(i >>> x & 1);
            --x;
        }
        System.out.println(sb.toString());
    }

    private static void printBits(byte b) {
        StringBuffer sb = new StringBuffer(8);
        int x = 7;
        while (x >= 0) {
            sb.append(b >>> x & 1);
            --x;
        }
        System.out.println(sb.toString());
    }
}

