/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.core.MeBitSet;
import com.sap.ip.me.persist.fileio.AttributePosition;
import com.sap.ip.me.persist.fileio.IndexTree;
import java.io.File;

final class SecondaryIndex
extends IndexTree {
    String[] primaryKeys;

    SecondaryIndex(String fileNameBase, AttributeDescriptor keyAtt, AttributePosition keyAttPos, int index) throws PersistenceException {
        super(SecondaryIndex.getFileName(fileNameBase, index), keyAtt, keyAttPos);
    }

    private static String getFileName(String fileNameBase, int index) {
        String filename;
        int idx = fileNameBase.lastIndexOf(File.separator);
        String filepath = "";
        if (idx >= 0) {
            filepath = fileNameBase.substring(0, idx + 1);
            filename = fileNameBase.substring(idx + 1);
        } else {
            filename = fileNameBase;
        }
        StringBuffer sb = new StringBuffer(filepath);
        sb.append(SecondaryIndex.getEscapedString(filename, "-", "--")).append("-").append(index);
        return sb.toString();
    }

    static String getEscapedString(String s, String replace, String escape) {
        StringBuffer sb = new StringBuffer();
        int p_idx = 0;
        while (true) {
            int idx;
            if ((idx = s.indexOf(replace, p_idx)) == -1) break;
            sb.append(s.substring(p_idx, idx));
            sb.append(escape);
            p_idx = idx + replace.length();
        }
        sb.append(s.substring(p_idx, s.length()));
        return sb.toString();
    }

    void searchNodes(Object key, MeBitSet mask, MeBitSet result, RelationalOperatorType type) throws PersistenceException {
        if (type == RelationalOperatorType.CONTAINS) {
            this.searchNodesWhereContains(key, mask, result);
        } else if (type == RelationalOperatorType.EQUALS) {
            this.searchNodesWhereEquals(key, mask, result);
        } else if (type == RelationalOperatorType.GREATER_THAN) {
            this.searchNodesWhereGreaterThan(key, mask, result);
        } else if (type == RelationalOperatorType.LOWER_THAN) {
            this.searchNodesWhereLowerThan(key, mask, result);
        } else if (type == RelationalOperatorType.NOT_EQUALS) {
            this.searchNodesWhereNotEquals(key, mask, result);
        } else if (type == RelationalOperatorType.STARTS_WITH) {
            this.searchNodesWhereStartsWith(key, mask, result);
        } else {
            throw new RuntimeException("Not supported RelationalOperatorType!");
        }
    }

    void searchNodesWhereEquals(Object key, MeBitSet mask, MeBitSet result) {
        this.searchNodesWhereEquals(key, 0, mask, result);
    }

    void searchNodesWhereNotEquals(Object key, MeBitSet mask, MeBitSet result) {
        MeBitSet allValidNodes = (MeBitSet)mask.clone();
        allValidNodes.and(super.getValidRows());
        this.searchNodesWhereEquals(key, 0, mask, result);
        result.xor(allValidNodes);
    }

    void searchNodesWhereLowerThan(Object key, MeBitSet mask, MeBitSet result) {
        this.searchNodesWhereLowerThan(key, 0, mask, result);
    }

    void searchNodesWhereContains(Object subkey, MeBitSet mask, MeBitSet result) throws PersistenceException {
        try {
            String s = (String)subkey;
            int index = mask.nextSetBit(0);
            while (index != -1) {
                String key = (String)super.getKey(index);
                if (key != null && key.indexOf(s) != -1) {
                    result.set(index);
                }
                index = mask.nextSetBit(index + 1);
            }
        }
        catch (ClassCastException cx) {
            throw new PersistenceException("[contains] condition only valid for String objects");
        }
    }

    void searchNodesWhereStartsWith(Object subkey, MeBitSet mask, MeBitSet result) throws PersistenceException {
        try {
            String s = (String)subkey;
            int index = mask.nextSetBit(0);
            while (index != -1) {
                String key = (String)super.getKey(index);
                if (key != null && key.startsWith(s)) {
                    result.set(index);
                }
                index = mask.nextSetBit(index + 1);
            }
        }
        catch (ClassCastException cx) {
            throw new PersistenceException("[startsWith] condition only valid for String objects");
        }
    }

    void searchNodesWhereGreaterThan(Object key, MeBitSet mask, MeBitSet result) {
        this.searchNodesWhereGreaterThan(key, 0, mask, result);
    }

    boolean isPrimary() {
        return false;
    }

    private void searchNodesWhereLowerThan(Object key, int nodeIdx, MeBitSet mask, MeBitSet result) {
        while (nodeIdx != -2) {
            int cmp = this.keyType.compare(key, this.key[nodeIdx]);
            if (cmp <= 0) {
                nodeIdx = this.lNode[nodeIdx];
                continue;
            }
            if (cmp <= 0) continue;
            this.traversal(this.lNode[nodeIdx], mask, result);
            int rowIdx = this.idx[nodeIdx];
            if (rowIdx > -1 && mask.get(rowIdx)) {
                result.set(rowIdx);
            }
            nodeIdx = this.rNode[nodeIdx];
        }
    }

    private void searchNodesWhereGreaterThan(Object key, int nodeIdx, MeBitSet mask, MeBitSet result) {
        while (nodeIdx != -2) {
            int cmp = this.keyType.compare(key, this.key[nodeIdx]);
            if (cmp <= 0) {
                this.traversal(this.rNode[nodeIdx], mask, result);
                int rowIdx = this.idx[nodeIdx];
                if (cmp < 0 && rowIdx > -1 && mask.get(rowIdx)) {
                    result.set(rowIdx);
                }
                nodeIdx = this.lNode[nodeIdx];
                continue;
            }
            if (cmp <= 0) continue;
            nodeIdx = this.rNode[nodeIdx];
        }
    }

    private void traversal(int startNodeIdx, MeBitSet mask, MeBitSet result) {
        if (startNodeIdx == -2) {
            return;
        }
        int rowIdx = this.idx[startNodeIdx];
        if (rowIdx > -1 && mask.get(rowIdx)) {
            result.set(rowIdx);
        }
        this.traversal(this.lNode[startNodeIdx], mask, result);
        this.traversal(this.rNode[startNodeIdx], mask, result);
    }

    private void searchNodesWhereEquals(Object key, int nodeIdx, MeBitSet mask, MeBitSet result) {
        while (nodeIdx != -2) {
            int cmp = this.keyType.compare(key, this.key[nodeIdx]);
            if (cmp <= 0) {
                int rowIdx = this.idx[nodeIdx];
                if (cmp == 0 && rowIdx > -1 && mask.get(rowIdx)) {
                    result.set(rowIdx);
                }
                nodeIdx = this.lNode[nodeIdx];
                continue;
            }
            if (cmp <= 0) continue;
            nodeIdx = this.rNode[nodeIdx];
        }
    }

    private int searchNode(Object key, int nodeIdx, int rowIdx) {
        while (nodeIdx != -2) {
            int cmp = this.keyType.compare(key, this.key[nodeIdx]);
            if (cmp < 0) {
                nodeIdx = this.lNode[nodeIdx];
                continue;
            }
            if (cmp > 0) {
                nodeIdx = this.rNode[nodeIdx];
                continue;
            }
            if (this.idx[nodeIdx] == rowIdx) {
                return nodeIdx;
            }
            if (this.lNode[nodeIdx] != -2 && (nodeIdx = this.searchNode(key, this.lNode[nodeIdx], rowIdx)) > -1) {
                return nodeIdx;
            }
            if (this.rNode[nodeIdx] == -2 || (nodeIdx = this.searchNode(key, this.rNode[nodeIdx], rowIdx)) <= -1) continue;
            return nodeIdx;
        }
        return -1;
    }
}

