/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.core.MeLinkedList;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;

public final class RandomAccessFilePool {
    private Hashtable cache;
    private int size;
    private MeLinkedList fifoList;
    private static final int CACHE_SIZE = 200;
    private static RandomAccessFilePool instance;

    static RandomAccessFilePool getInstance() {
        if (instance == null) {
            instance = new RandomAccessFilePool(200);
        }
        return instance;
    }

    protected void finalize() {
        try {
            Enumeration enumeration = this.cache.elements();
            while (enumeration.hasMoreElements()) {
                ((RandomAccessFile)enumeration.nextElement()).close();
            }
            this.cache = null;
            this.fifoList = null;
            this.size = -1;
            instance = null;
        }
        catch (IOException e) {
            Trace.getInstance("MI/Persistence").logException(e);
        }
    }

    private RandomAccessFilePool(int size) {
        this.cache = new Hashtable(size);
        this.fifoList = new MeLinkedList();
        this.size = size;
    }

    RandomAccessFile getFile(String filename) {
        RandomAccessFile file = this.readCache(filename);
        if (file == null) {
            try {
                file = new RandomAccessFile(filename, "rw");
                this.writeCache(filename, file);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                Trace.getInstance("MI/Persistence").logException(ioe);
            }
        }
        return file;
    }

    private void writeCache(String filename, RandomAccessFile file) throws IOException {
        if (this.cache.size() == this.size) {
            String deleteKey = (String)this.fifoList.removeFirst();
            RandomAccessFile fileToClose = (RandomAccessFile)this.cache.get(deleteKey);
            fileToClose.close();
            this.cache.remove(deleteKey);
        }
        this.fifoList.addLast(filename);
        this.cache.put(filename, file);
    }

    private RandomAccessFile readCache(String filename) {
        return (RandomAccessFile)this.cache.get(filename);
    }
}

