/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.persist.fileio.AttributePosition;
import com.sap.ip.me.persist.fileio.LinkPosition;
import java.util.Hashtable;

final class PositionSet {
    final Hashtable HASHED_SET;
    final LinkPosition[] LINK_POS;
    final AttributePosition[] ATT_POS;
    final int attrByteLen;
    final int linkByteLen;
    final int totalByteLen;
    final int multiLinkCnt;
    final AttributePosition keyAttributePosition;

    PositionSet(ClassDescriptor cdes) throws PersistenceException {
        this.keyAttributePosition = new AttributePosition(cdes.getKeyAttributeDescriptor(), 0);
        AttributeDescriptor[] ades = cdes.getAttributeDescriptorArray();
        LinkDescriptor[] ldes = cdes.getLinkDescriptorArray();
        int size = ades.length + ldes.length;
        this.HASHED_SET = size > 0 ? new Hashtable(size) : new Hashtable();
        this.ATT_POS = new AttributePosition[ades.length];
        int offset = 0;
        int x = 0;
        while (x < ades.length) {
            this.ATT_POS[x] = new AttributePosition(ades[x], offset);
            offset += this.ATT_POS[x].totalByteLen;
            this.HASHED_SET.put(ades[x].getName(), this.ATT_POS[x]);
            ++x;
        }
        this.attrByteLen = offset;
        this.LINK_POS = new LinkPosition[ldes.length];
        int multiLinkCnt = 0;
        offset = 0;
        PersistenceRuntime runtime = PersistenceRuntime.getInstance();
        int x2 = 0;
        while (x2 < ldes.length) {
            ClassDescriptor linkedCdes = runtime.getClassDescriptor(ldes[x2].getClasstype());
            AttributeDescriptor linkedKeyAdes = linkedCdes.getKeyAttributeDescriptor();
            this.LINK_POS[x2] = new LinkPosition(ldes[x2], linkedKeyAdes, x2, offset);
            offset += this.LINK_POS[x2].byteLengthInObjTab;
            this.HASHED_SET.put(ldes[x2].getName(), this.LINK_POS[x2]);
            if (ldes[x2].getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR) {
                ++multiLinkCnt;
            }
            ++x2;
        }
        this.linkByteLen = offset;
        this.totalByteLen = this.attrByteLen + this.linkByteLen;
        this.multiLinkCnt = multiLinkCnt;
    }

    AttributePosition getAttributePosition(String adesName) {
        return (AttributePosition)this.HASHED_SET.get(adesName);
    }

    LinkPosition getLinkPosition(String adesName) {
        return (LinkPosition)this.HASHED_SET.get(adesName);
    }

    int getAttributeByteLength() {
        return this.attrByteLen;
    }

    int getLinkByteLength() {
        return this.linkByteLen;
    }

    int getTotalByteLength() {
        return this.totalByteLen;
    }

    int getMultipleLinkCnt() {
        return this.multiLinkCnt;
    }

    AttributePosition getKeyAttributePosition() {
        return this.keyAttributePosition;
    }
}

