/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.persist.fileio.RandomAccessFileUser;
import com.sap.ip.me.persist.fileio.TypeConverter;
import java.io.IOException;
import java.io.RandomAccessFile;

final class PersistentIntStack
extends RandomAccessFileUser {
    private static final int FILE_START = 0;
    private static final int VALIDITY_FLAG_POS = 0;
    private static final int VERSION_POS = 1;
    private static final int LAST_ELEMENT_CNT_POS = 5;
    private static final int CUSTOM_VAL_POS = 28;
    private static final int FILE_META_OFFSET = 32;
    private static final int VERSION_NO = 0;
    private static final byte VALIDITY_FLAG = -1;
    private static final int INITIAL_SIZE = 10;
    private static final int RESIZE_FACTOR = 2;
    private int minStackSizeSinceIo;
    private int stackSizeAtIo;
    private int[] stack;
    private int stackSize;
    private boolean isInitial;
    private boolean isInitialized;
    private int customVal;
    private boolean changedCustomVal;

    PersistentIntStack(String fileName) throws PersistenceException {
        super(fileName);
    }

    void reinitialize() throws PersistenceException {
        this.isInitialized = false;
        this.verifyIsInitialized();
    }

    int pop() throws PersistenceException {
        this.verifyIsInitialized();
        if (this.stackSize > 0) {
            --this.stackSize;
            if (this.stackSize < this.minStackSizeSinceIo) {
                this.minStackSizeSinceIo = this.stackSize;
            }
            return this.stack[this.stackSize];
        }
        return -1;
    }

    void push(int i) throws PersistenceException {
        this.verifyIsInitialized();
        this.ensureCapacity();
        this.stack[this.stackSize++] = i;
    }

    boolean isEmpty() throws PersistenceException {
        this.verifyIsInitialized();
        return this.stackSize < 1;
    }

    void write() throws PersistenceException {
        try {
            byte[] b;
            if (this.stackSize != this.stackSizeAtIo || this.changedCustomVal || this.isInitial) {
                b = new byte[32];
                b[0] = -1;
                TypeConverter.intoByte(0, b, 1);
                TypeConverter.intoByte(this.stackSize, b, 5);
                TypeConverter.intoByte(this.customVal, b, 28);
                RandomAccessFile file = this.getFile();
                file.seek(0L);
                file.write(b);
            }
            if (this.minStackSizeSinceIo < this.stackSize) {
                b = new byte[(this.stackSize - this.minStackSizeSinceIo) * 4];
                int y = 0;
                int x = this.minStackSizeSinceIo;
                while (x < this.stackSize) {
                    TypeConverter.intoByte(this.stack[x], b, y++ * 4);
                    ++x;
                }
                RandomAccessFile file = this.getFile();
                file.seek(32 + this.minStackSizeSinceIo * 4);
                file.write(b);
            }
            this.isInitial = false;
            this.changedCustomVal = false;
            this.stackSizeAtIo = this.stackSize;
            this.minStackSizeSinceIo = this.stackSize;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PersistenceException(e);
        }
    }

    int getCustomValue() throws PersistenceException {
        this.verifyIsInitialized();
        return this.customVal;
    }

    void setCustomValue(int i) throws PersistenceException {
        this.verifyIsInitialized();
        if (i != this.customVal) {
            this.customVal = i;
            this.changedCustomVal = true;
        }
    }

    private void verifyIsInitialized() throws PersistenceException {
        if (!this.isInitialized) {
            if (this.readFromFile()) {
                this.isInitial = false;
            } else {
                this.isInitial = true;
                this.initializeWithoutFile();
            }
            this.isInitialized = true;
        }
    }

    private void ensureCapacity() {
        if (this.stackSize >= this.stack.length) {
            int[] newStack = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
    }

    private boolean readFromFile() throws PersistenceException {
        try {
            RandomAccessFile file = this.getFile();
            int len = (int)file.length();
            if (len < 32) {
                return false;
            }
            if ((len - 32) % 4 > 0) {
                throw new PersistenceException("Corrupt file");
            }
            byte[] meta = new byte[32];
            file.seek(0L);
            file.read(meta);
            if (meta[0] != -1) {
                return false;
            }
            if (TypeConverter.toInt(meta, 1) != 0) {
                throw new PersistenceException("Incompatible version");
            }
            this.stackSize = TypeConverter.toInt(meta, 5);
            this.customVal = TypeConverter.toInt(meta, 28);
            this.stack = new int[this.stackSize > 0 ? this.stackSize : 10];
            byte[] b = new byte[this.stackSize * 4];
            file.read(b);
            int x = 0;
            while (x < this.stackSize) {
                this.stack[x] = TypeConverter.toInt(b, x * 4);
                ++x;
            }
            this.minStackSizeSinceIo = this.stackSize;
            this.stackSizeAtIo = this.stackSize;
            this.changedCustomVal = false;
            return true;
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private void initializeWithoutFile() {
        this.stackSize = 0;
        this.customVal = 0;
        this.stack = new int[10];
        this.minStackSizeSinceIo = this.stackSize;
        this.stackSizeAtIo = this.stackSize;
        this.changedCustomVal = false;
    }
}

