/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.conf.Configuration;
import com.sap.ip.me.api.conf.VisibilityType;
import com.sap.ip.me.api.logging.Trace;
import com.sap.ip.me.api.persist.app.PackagePersistenceMaster;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceManager;
import com.sap.ip.me.api.persist.core.PersistenceRuntime;
import com.sap.ip.me.api.persist.core.TransactionManager;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.ConversationId;
import com.sap.ip.me.core.ConversationIdHandler;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.persist.core.InternalTransactionManager;
import com.sap.ip.me.persist.core.PersistenceCleaner;
import com.sap.ip.me.persist.core.PersistenceManagerTXWrapper;
import com.sap.ip.me.persist.core.TransactionManagerTXWrapper;
import com.sap.ip.me.persist.fileio.FilePersistenceManager;
import com.sap.ip.me.persist.fileio.FileTransactionManager;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;

public final class PersistenceRuntimeImpl
extends PersistenceRuntime
implements PersistenceCleaner {
    private static final Configuration CONFIG = Configuration.getInstance();
    private final ConversationIdHandler convIdHandler;
    private final Hashtable transactionManagers = new Hashtable();
    private final Hashtable persistenceManagers = new Hashtable();
    private final Hashtable persistenceMasters = new Hashtable();
    private final File FILEBASE;
    private final Vector allClassDescriptors = new Vector();

    public PersistenceRuntimeImpl() {
        Trace.getInstance("MI/Persistence").log(90, "Me Persistence initialization, step 2: start create instance of com.sap.ip.me.persist.core.PersistenceRuntimeImpl");
        this.convIdHandler = ConversationIdHandler.getInstance();
        Trace.getInstance("MI/Persistence").log(90, "Me Persistence initialization, step 3: end create instance of com.sap.ip.me.persist.core.PersistenceRuntimeImpl");
        this.FILEBASE = this.initFileBase();
    }

    public void _reset() {
        this.transactionManagers.clear();
        this.persistenceManagers.clear();
        this.persistenceMasters.clear();
        this.allClassDescriptors.removeAllElements();
    }

    public TransactionManager getTransactionManager(VisibilityType visibility) throws PersistenceException {
        ConversationId convId = this.convIdHandler.getCurrentConversationId(visibility);
        return this.getTransactionManager(convId);
    }

    private TransactionManager getTransactionManager(ConversationId convId) throws PersistenceException {
        Trace.getInstance("MI/Persistence").log(90, "Me Persistence initialization, step 4: get TransactionManager for ConversationID: {0}", new Object[]{convId.getId()});
        TransactionManager manager = (TransactionManager)this.transactionManagers.get(convId.getId());
        if (manager == null) {
            try {
                manager = new FileTransactionManager(convId, this);
                this.transactionManagers.put(convId.getId(), manager);
            }
            catch (Exception e) {
                Trace.getInstance("MI/Persistence").logException(e);
                e.printStackTrace();
                if (e instanceof PersistenceException) {
                    throw (PersistenceException)e;
                }
                throw new PersistenceException(e.toString());
            }
        }
        return new TransactionManagerTXWrapper(manager, manager.getTransaction());
    }

    public PersistenceManager getPersistenceManager(VisibilityType v) throws PersistenceException {
        ConversationId convId = this.convIdHandler.getCurrentConversationId(v);
        if (convId == null) {
            throw new IllegalStateException("user not logging on, cannot get curent conversation id");
        }
        return this.getPersistenceManager(convId);
    }

    private PersistenceManager getPersistenceManager(ConversationId convId) throws PersistenceException {
        PersistenceManager manager = (PersistenceManager)this.persistenceManagers.get(convId.getId());
        if (manager == null) {
            try {
                manager = new FilePersistenceManager(convId, this);
                this.persistenceManagers.put(convId.getId(), manager);
            }
            catch (Exception e) {
                Trace.getInstance("MI/Persistence").logException(e);
                e.printStackTrace();
                if (e instanceof PersistenceException) {
                    throw (PersistenceException)e;
                }
                throw new PersistenceException(e.toString());
            }
        }
        return new PersistenceManagerTXWrapper(manager);
    }

    public void registerPersistenceMaster(PackagePersistenceMaster persistenceMaster) throws PersistenceException {
        String[] classtypes = persistenceMaster.getClasstypes();
        int x = 0;
        while (x < classtypes.length) {
            if (this.persistenceMasters.put(classtypes[x], persistenceMaster) == null) {
                this.allClassDescriptors.addElement(persistenceMaster.getClassDescriptor(classtypes[x]));
            }
            ++x;
        }
    }

    public MeIterator getAllClassDescriptors() {
        return new MeIteratorVectorImpl(this.allClassDescriptors);
    }

    public ClassDescriptor getClassDescriptor(String classtype) throws PersistenceException {
        PackagePersistenceMaster master = (PackagePersistenceMaster)this.persistenceMasters.get(classtype);
        if (master == null) {
            throw new PersistenceException("No master registered for classtype {0}", new Object[]{classtype});
        }
        ClassDescriptor pclass = master.getClassDescriptor(classtype);
        if (pclass == null) {
            throw new PersistenceException("No ClassDescriptor registered for classtype {0}", new Object[]{classtype});
        }
        return pclass;
    }

    public void removeTransactionManager(String convId) {
        this.transactionManagers.remove(convId);
    }

    public File getFileBase(String convId) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.FILEBASE.getAbsolutePath());
        sb.append(File.separator);
        sb.append(convId);
        File f = new File(new File(sb.toString()).getAbsolutePath());
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public File getFileBase() {
        return this.FILEBASE;
    }

    private File initFileBase() {
        StringBuffer sbDir = new StringBuffer(200);
        boolean isAbsoluteDir = CONFIG.getBoolean("MobileEngine.Persist.RootDir.isAbsolute", false);
        if (!isAbsoluteDir) {
            String instDir = CONFIG.getProperty("MobileEngine.InstallationPath");
            sbDir.append(instDir);
            sbDir.append(File.separator);
        }
        sbDir.append(CONFIG.getProperty("MobileEngine.Persist.Rootdir"));
        File f = new File(new File(sbDir.toString()).getAbsolutePath());
        if (!f.exists()) {
            f.mkdirs();
        }
        return f;
    }

    public void deleteAllDataForConversationId(ConversationId convId) throws PersistenceException {
        this.deleteAllDataForConversationId(this.transactionManagers, convId);
        this.deleteAllDataForConversationId(this.persistenceManagers, convId);
    }

    private void deleteAllDataForConversationId(Hashtable transactionManagers, ConversationId convId) throws PersistenceException {
        if (transactionManagers.containsKey(convId.getId())) {
            ((InternalTransactionManager)transactionManagers.get(convId.getId())).reset();
        }
    }
}

