/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.app.Entity;
import com.sap.ip.me.api.persist.app.PersistableEntity;
import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceContainer;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.core.NestableRuntimeException;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.LinkPosition;
import com.sap.ip.me.persist.fileio.PositionSet;
import java.util.Vector;

final class PersistedObjectImpl
implements PersistedObject,
PersistenceContainer {
    static final int NO_ROW_IDX = -1;
    private static final Object[] EMPTY_RESOLVED_LINKS = new Object[0];
    private static final Vector EMPTY_VECTOR = new Vector();
    private static final PersistableEntity INITIAL_ENTITY_2 = null;
    private final ClassDescriptorImpl cdes;
    private final PositionSet pset;
    private final AbstractFileTransactionManager txMan;
    private Object[] attributes;
    private Object[] attributesUndo;
    private Object[] links;
    private Object[] linksUndo;
    private Object[] transientLinks;
    private PersistenceOperationType op;
    private int rowIdx;
    private long isModified;
    private boolean isPersistent;
    private int keyPos;

    private PersistedObjectImpl(Object key, ClassDescriptorImpl cdes, PositionSet pset, Object[] attributes, Object[] links, int rowIdx, AbstractFileTransactionManager txMan, boolean isPersistent) {
        this.cdes = cdes;
        this.pset = pset;
        this.txMan = txMan;
        this.keyPos = cdes.getKeyAttributePosition();
        this.rowIdx = rowIdx;
        this.isModified = 0L;
        this.isPersistent = isPersistent;
        this.attributes = new Object[pset.ATT_POS.length];
        if (attributes != null) {
            System.arraycopy(attributes, 0, this.attributes, 0, pset.ATT_POS.length);
        } else {
            int i = 0;
            while (i < pset.ATT_POS.length) {
                this.attributes[i] = pset.ATT_POS[i].getDefaultValue();
                ++i;
            }
        }
        this.links = new Object[pset.LINK_POS.length];
        if (links != null) {
            System.arraycopy(links, 0, this.links, 0, pset.LINK_POS.length);
        }
        this.attributes[this.keyPos] = pset.ATT_POS[this.keyPos].type.cloneMutable(key);
    }

    public void setEntity(PersistableEntity entity) {
    }

    public final String getClasstype() {
        return this.cdes.getClasstype();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.attributes.length);
        int x = 0;
        while (x < this.pset.ATT_POS.length) {
            sb.append(this.attributes[x]);
            sb.append(" ; ");
            ++x;
        }
        return sb.toString();
    }

    public final ClassDescriptor getClassDescriptor() {
        return this.cdes;
    }

    public int sizeAttribute() {
        return this.cdes.getAttributeDescriptorArray().length;
    }

    public int sizeAttribute(int idx) {
        return this.cdes.getAttributeDescriptor(idx).getMultiple();
    }

    public void setAttribute(int idx, int pos, Object val) {
        if (this.isPersistent) {
            if (this.op == null) {
                this.op = PersistenceOperationType.MODIFY;
            }
            if (this.op == PersistenceOperationType.NOOPER) {
                throw new IllegalStateException("no open transaction");
            }
            if (this.op == PersistenceOperationType.DELETE) {
                return;
            }
            if (this.op == PersistenceOperationType.MODIFY && this.attributesUndo == null) {
                this.attributesUndo = new Object[this.attributes.length];
                System.arraycopy(this.attributes, 0, this.attributesUndo, 0, this.attributes.length);
            }
        }
        if (this.attributes[idx] == null) {
            this.attributes[idx] = new Object[this.pset.ATT_POS[idx].mult];
        }
        ((Object[])this.attributes[idx])[pos] = this.pset.ATT_POS[idx].type.cloneMutable(val);
    }

    public Object getAttribute(int idx, int pos) {
        if (this.attributes[idx] == null) {
            this.attributes[idx] = new Object[this.pset.ATT_POS[idx].mult];
        }
        return this.cdes.getAttributeDescriptor(idx).getType().cloneMutable(((Object[])this.attributes[idx])[pos]);
    }

    public String getEntityKey() {
        return (String)this.attributes[this.keyPos];
    }

    public String getKey() {
        return this.getEntityKey();
    }

    public void setAttribute(int idx, Object object) {
        if (idx == this.keyPos) {
            throw new IllegalArgumentException("The specified index refers to the key. The key cannot be changed.");
        }
        if (!this.pset.ATT_POS[idx].type.isValidType(object)) {
            throw new IllegalArgumentException("The specified value " + object + " is not compatible to this attribute index " + idx);
        }
        if (this.isPersistent) {
            if (this.op == null) {
                this.op = PersistenceOperationType.MODIFY;
            }
            if (this.op == PersistenceOperationType.NOOPER) {
                throw new IllegalStateException("no open transaction");
            }
            if (this.op == PersistenceOperationType.DELETE) {
                return;
            }
            if (this.op == PersistenceOperationType.MODIFY && this.attributesUndo == null) {
                this.attributesUndo = new Object[this.attributes.length];
                System.arraycopy(this.attributes, 0, this.attributesUndo, 0, this.attributes.length);
            }
        }
        this.attributes[idx] = this.pset.ATT_POS[idx].type.cloneMutable(object);
    }

    public void setAttributes(Object[] attributes) {
        int x = 0;
        while (x < attributes.length) {
            this.setAttribute(x, attributes[x]);
            ++x;
        }
    }

    public Object[] getAttributes() {
        AttributeDescriptor[] ades = this.cdes.getAttributeDescriptorArray();
        Object[] o = new Object[ades.length];
        int x = 0;
        while (x < o.length) {
            o[x] = this.getAttribute(x);
            ++x;
        }
        return o;
    }

    public Object getAttribute(int idx) {
        return this.cdes.getAttributeDescriptor(idx).getType().cloneMutable(this.attributes[idx]);
    }

    public Object getLink(int x) {
        if (this.cdes.getLinkDescriptorArray()[x].getMultiplicity() == MultiplicityType.SINGLE) {
            return this.getLinkAsEntity(x);
        }
        return this.getLinkAsVector(x);
    }

    private Object getLinkAsEntity(int x) {
        if (this.transientLinks != null && this.transientLinks[x] != null) {
            return this.transientLinks[x];
        }
        if (this.isPersistent) {
            String key = (String)this.links[x];
            if (key == null) {
                return null;
            }
            String classtype = this.cdes.getLinkDescriptor(x).getClasstype();
            try {
                return this.txMan.getUntyped(classtype, key);
            }
            catch (PersistenceException e) {
                throw new RuntimeException(e.toString());
            }
        }
        return null;
    }

    public PersistableEntity getSingleLink(int x) {
        return (PersistableEntity)this.getLinkAsEntity(x);
    }

    private Vector getLinkAsVector(int x) {
        int y;
        if (this.transientLinks != null && this.transientLinks[x] != null) {
            return (Vector)this.transientLinks[x];
        }
        Vector res = new Vector();
        if (this.links[x] != null && (y = ((Integer)this.links[x]).intValue()) != -1) {
            try {
                return this.txMan.getLinkAsVector(this.cdes, this.cdes.getLinkDescriptor(x), y);
            }
            catch (PersistenceException e) {
                throw new NestableRuntimeException(e);
            }
        }
        return new Vector();
    }

    public void removeAllMultipleLink(int idx) {
        this.setLink(idx, EMPTY_VECTOR);
    }

    public void removeMultipleLink(int idx, int pos) {
        Vector v = this.getLinkAsVector(idx);
        if (pos < v.size()) {
            v.removeElementAt(pos);
        }
        this.setLink(idx, v);
    }

    public void removeSingleLink(int idx) {
        this.setSingleLink(idx, INITIAL_ENTITY_2);
    }

    public int sizeLink(int idx) {
        return this.getLinkAsVector(idx).size();
    }

    public int sizeLink() {
        return this.cdes.getLinkDescriptorArray().length;
    }

    public boolean isMultipleLink(int idx) {
        return this.cdes.getLinkDescriptor(idx).getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR;
    }

    public PersistableEntity getMultipleLink(int idx, int pos) {
        Vector v = this.getLinkAsVector(idx);
        return (PersistableEntity)v.elementAt(pos);
    }

    public void addMultipleLink(int idx, PersistableEntity e) {
        Vector v = this.getLinkAsVector(idx);
        v.addElement(e);
        this.setLink(idx, v);
    }

    private void vectorSetElementAtWithAnySize(Vector v, int pos, Object val) {
        if (pos < 0) {
            throw new IllegalArgumentException("position must be positive:" + pos);
        }
        if (v.size() <= pos) {
            v.setSize(pos + 1);
        }
        v.setElementAt(val, pos);
    }

    public void setMultipleLink(int idx, int pos, PersistableEntity e) {
        Vector v = this.getLinkAsVector(idx);
        this.vectorSetElementAtWithAnySize(v, pos, e);
        this.setLink(idx, v);
    }

    public MeIterator getMultipleLink(int idx) {
        return new MeIteratorVectorImpl(this.getLinkAsVector(idx));
    }

    private void ensureTransientLinks() {
        if (this.transientLinks == null) {
            this.transientLinks = new Object[this.cdes.getLinkDescriptorArray().length];
        }
    }

    public void setLink(int idx, Vector v) {
        if (this.isPersistent) {
            if (this.op == PersistenceOperationType.NOOPER) {
                throw new IllegalStateException("no open transaction");
            }
            if (this.op == PersistenceOperationType.DELETE) {
                return;
            }
        }
        this.setIsModified(idx);
        if (this.transientLinks == null) {
            this.transientLinks = new Object[this.cdes.getLinkDescriptorArray().length];
        }
        this.transientLinks[idx] = v;
    }

    public void setSingleLink(int x, PersistableEntity entity) {
        if (entity != null) {
            this.setLink(x, entity.getPersistedObject().getKey());
        } else {
            this.setLink(x, (String)null);
        }
        this.ensureTransientLinks();
        this.transientLinks[x] = entity;
    }

    public void setLink(int x, Entity entity) {
        this.setLink(x, entity.getEntityKey());
        if (this.transientLinks == null) {
            this.transientLinks = new Object[this.cdes.getLinkDescriptorArray().length];
        }
        this.transientLinks[x] = entity;
    }

    public void setLink(int idx, String entityKey) {
        if (this.isPersistent) {
            if (this.op == null) {
                this.op = PersistenceOperationType.MODIFY;
            }
            if (this.op == PersistenceOperationType.NOOPER) {
                throw new IllegalStateException("no open transaction");
            }
            if (this.op == PersistenceOperationType.DELETE) {
                return;
            }
            if (this.op == PersistenceOperationType.MODIFY && this.linksUndo == null) {
                this.linksUndo = new Object[this.links.length];
                System.arraycopy(this.links, 0, this.linksUndo, 0, this.links.length);
            }
        }
        this.setIsModified(idx);
        this.links[idx] = entityKey;
    }

    public Object[] getLinks() {
        return this.resolveAllKeysToLinks();
    }

    public void setLinks(Object[] links) {
        LinkDescriptor[] lDes = this.cdes.getLinkDescriptorArray();
        if (links.length != lDes.length) {
            throw new IllegalArgumentException("specified link array not equal to link array length in descriptor");
        }
        int x = 0;
        while (x < lDes.length) {
            if (this.isMultipleLink(x)) {
                this.setLink(x, (Vector)links[x]);
            } else {
                this.setSingleLink(x, (PersistableEntity)links[x]);
            }
            ++x;
        }
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public PersistenceOperationType getOperation() {
        return this.op;
    }

    static PersistedObjectImpl createForRead(String key, ClassDescriptor cdes, PositionSet pset, byte[] attributes, byte[] links, int rowIdx, AbstractFileTransactionManager txMan) {
        Object[] atts = new Object[pset.ATT_POS.length];
        int i = 0;
        while (i < atts.length) {
            atts[i] = pset.ATT_POS[i].type.toValue(attributes, pset.ATT_POS[i].offset);
            ++i;
        }
        Object[] lks = new Object[pset.LINK_POS.length];
        int i2 = 0;
        while (i2 < lks.length) {
            lks[i2] = pset.LINK_POS[i2].toValue(links);
            ++i2;
        }
        return new PersistedObjectImpl(key, (ClassDescriptorImpl)cdes, pset, atts, lks, rowIdx, txMan, true);
    }

    static PersistedObjectImpl createTransient(String key, ClassDescriptor cdes, PositionSet pset, AbstractFileTransactionManager txMan) {
        return new PersistedObjectImpl(key, (ClassDescriptorImpl)cdes, pset, null, null, -1, txMan, false);
    }

    static PersistedObjectImpl createTransient(PersistedObjectImpl o, String key) {
        return new PersistedObjectImpl(key, o.cdes, o.pset, o.attributes, null, o.rowIdx, o.txMan, false);
    }

    boolean isModified(int idx) {
        return (this.isModified >> idx & 1L) == 1L;
    }

    void setOperation(PersistenceOperationType op) {
        this.op = this.op == null ? op : this.op.getMerged(op);
    }

    void onInsert(byte[] b) throws PersistenceException {
        this.isPersistent = true;
        int i = 0;
        while (i < this.attributes.length) {
            this.pset.ATT_POS[i].type.toByte(b, this.pset.ATT_POS[i].offset, this.attributes[i], this.cdes.getAttributeDescriptor(i).getLength(), this.cdes.getAttributeDescriptor(i).getDecimals());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.links.length) {
            this.pset.LINK_POS[i2].toByte(b, this.links[i2], this.pset.attrByteLen);
            ++i2;
        }
        this.op = null;
        this.resetIsModified();
        this.transientLinks = null;
    }

    void onModify(byte[] b) throws PersistenceException {
        this.isPersistent = true;
        int i = 0;
        while (i < this.attributes.length) {
            this.pset.ATT_POS[i].type.toByte(b, this.pset.ATT_POS[i].offset, this.attributes[i], this.cdes.getAttributeDescriptor(i).getLength(), this.cdes.getAttributeDescriptor(i).getDecimals());
            ++i;
        }
        int i2 = 0;
        while (i2 < this.links.length) {
            this.pset.LINK_POS[i2].toByte(b, this.links[i2], this.pset.attrByteLen);
            ++i2;
        }
        this.attributesUndo = null;
        this.linksUndo = null;
        this.op = null;
        this.resetIsModified();
        this.transientLinks = null;
    }

    void onDelete() throws PersistenceException {
        this.op = null;
        this.transitionToTransient();
    }

    void onRollback() {
        if (this.isPersistent) {
            if (this.attributesUndo != null) {
                this.attributes = this.attributesUndo;
                this.attributesUndo = null;
            }
            this.transientLinks = null;
            if (this.linksUndo != null) {
                this.links = this.linksUndo;
                this.linksUndo = null;
            }
            this.op = null;
            this.resetIsModified();
        }
    }

    void setRowIdx(int rowIdx) {
        this.rowIdx = rowIdx;
    }

    int getRowIdx() {
        return this.rowIdx;
    }

    void setLinkVectorStart(LinkPosition lpos, int y) {
        this.links[lpos.pos] = new Integer(y);
    }

    int getLinkVectorStart(LinkPosition lpos) {
        if (this.links[lpos.pos] == null) {
            return -1;
        }
        return (Integer)this.links[lpos.pos];
    }

    private void transitionToTransient() throws PersistenceException {
        if (!this.isPersistent) {
            throw new PersistenceException("cannot transition - already transient");
        }
        this.isPersistent = false;
        this.attributesUndo = null;
        this.transientLinks = this.resolveAllKeysToLinks();
        this.op = null;
        this.rowIdx = -1;
    }

    private Object[] resolveAllKeysToLinks() {
        LinkDescriptor[] ldes = this.cdes.getLinkDescriptorArray();
        if (ldes.length > 0) {
            Object[] resolvedLinks = new Object[ldes.length];
            int x = 0;
            while (x < ldes.length) {
                resolvedLinks[x] = this.getLink(x);
                ++x;
            }
            return resolvedLinks;
        }
        return EMPTY_RESOLVED_LINKS;
    }

    private void setIsModified(int idx) {
        this.isModified |= (long)(1 << idx);
    }

    private void resetIsModified() {
        this.isModified = 0L;
    }

    void mergeWith(PersistedObjectImpl prev) {
        this.op = prev.op.getMerged(this.op);
        this.rowIdx = prev.rowIdx;
    }
}

