/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.core.PersistedObject;
import com.sap.ip.me.api.persist.core.PersistenceException;
import com.sap.ip.me.api.persist.core.PersistenceOperationType;
import com.sap.ip.me.api.persist.meta.AttributeDescriptor;
import com.sap.ip.me.api.persist.meta.ClassDescriptor;
import com.sap.ip.me.api.persist.meta.LinkDescriptor;
import com.sap.ip.me.api.persist.meta.MultiplicityType;
import com.sap.ip.me.api.persist.query.CompositeCondition;
import com.sap.ip.me.api.persist.query.Condition;
import com.sap.ip.me.api.persist.query.LogicalOperatorType;
import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.Query;
import com.sap.ip.me.api.persist.query.RelationalOperatorType;
import com.sap.ip.me.api.persist.query.SingleCondition;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeComparator;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.api.services.PerformanceLog;
import com.sap.ip.me.core.MeArrays;
import com.sap.ip.me.core.MeBitSet;
import com.sap.ip.me.core.MeIteratorArrayImpl;
import com.sap.ip.me.core.MeIteratorHashImpl;
import com.sap.ip.me.core.MeIteratorVectorImpl;
import com.sap.ip.me.persist.core.ClassDescriptorImpl;
import com.sap.ip.me.persist.core.Prioritizable;
import com.sap.ip.me.persist.core.PriorityComparator;
import com.sap.ip.me.persist.fileio.AbstractFileTransactionManager;
import com.sap.ip.me.persist.fileio.AttributePosition;
import com.sap.ip.me.persist.fileio.FileIOQuery;
import com.sap.ip.me.persist.fileio.IndexTree;
import com.sap.ip.me.persist.fileio.MultipleLinkTable;
import com.sap.ip.me.persist.fileio.MultipleValue;
import com.sap.ip.me.persist.fileio.MultipleValueComparator;
import com.sap.ip.me.persist.fileio.PersistedObjectComparator;
import com.sap.ip.me.persist.fileio.PersistedObjectImpl;
import com.sap.ip.me.persist.fileio.PersistentIntStack;
import com.sap.ip.me.persist.fileio.PositionSet;
import com.sap.ip.me.persist.fileio.PrimaryIndex;
import com.sap.ip.me.persist.fileio.RandomAccessFileUser;
import com.sap.ip.me.persist.fileio.SecondaryIndex;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class ObjectTable
extends RandomAccessFileUser {
    private static final String FILE_POSTFIX = ".dat";
    private final String fileNameBase;
    private final PrimaryIndex primaryIdx;
    private final IndexTree[] allIndexes;
    private final int rowLen;
    private final int attribLen;
    private final int linkLen;
    private final ClassDescriptor cdes;
    private final PositionSet pset;
    private final PersistentIntStack rowIdxGen;
    private final Hashtable txContext;
    private final AbstractFileTransactionManager txMan;
    private final byte[] tmpRow;
    private final MultipleLinkTable[] multiLink;
    private final Hashtable multiLinkHash = new Hashtable();
    private final int primaryKeyPos;
    private long operationCounter;
    private PersistedObject[] persistentCache;
    private final FileIOQueryManager fqManager = new FileIOQueryManager();

    ObjectTable(ClassDescriptor cdes, File fileBase, AbstractFileTransactionManager txMan) throws PersistenceException {
        super(new File(fileBase + File.separator + cdes.getClasstype()).getAbsolutePath() + FILE_POSTFIX);
        this.cdes = cdes;
        this.pset = new PositionSet(cdes);
        this.fileNameBase = new File(fileBase + File.separator + cdes.getClasstype()).getAbsolutePath();
        this.rowIdxGen = new PersistentIntStack(this.fileNameBase + ".fi0");
        this.primaryIdx = new PrimaryIndex(this.fileNameBase, cdes.getKeyAttributeDescriptor(), this.pset.keyAttributePosition);
        this.allIndexes = new IndexTree[cdes.getSecondaryIdxCount() + 1];
        this.allIndexes[0] = this.primaryIdx;
        this.txContext = new Hashtable(10);
        this.txMan = txMan;
        this.persistentCache = new PersistedObjectImpl[this.rowIdxGen.getCustomValue() + 1];
        this.multiLink = this.createAllMultipleLinkTables();
        this.rowLen = this.pset.getTotalByteLength();
        this.attribLen = this.pset.getAttributeByteLength();
        this.linkLen = this.pset.getLinkByteLength();
        this.tmpRow = new byte[this.rowLen];
        this.primaryKeyPos = ((ClassDescriptorImpl)cdes).getKeyAttributePosition();
    }

    void reinitialize() throws PersistenceException {
        this.rowIdxGen.reinitialize();
        MeIterator itr = this.cdes.getAttributeDescriptors();
        itr.reset();
        while (itr.hasNext()) {
            AttributeDescriptor ad = (AttributeDescriptor)itr.next();
            if (!ad.isIndex()) continue;
            this.getIndex(ad).reinitialize();
        }
        this.persistentCache = new PersistedObjectImpl[this.rowIdxGen.getCustomValue() + 1];
        int x = 0;
        while (x < this.multiLink.length) {
            this.multiLink[x].reinitialize();
            ++x;
        }
    }

    void commit() throws PersistenceException {
        MeIteratorHashImpl opIt = new MeIteratorHashImpl(this.txContext);
        this.processAndWriteRowIndexes(opIt);
        int x = 0;
        while (x < this.multiLink.length) {
            this.multiLink[x].commit(opIt);
            ++x;
        }
        MeIterator itr = this.cdes.getAttributeDescriptors();
        itr.reset();
        while (itr.hasNext()) {
            AttributeDescriptor ad = (AttributeDescriptor)itr.next();
            if (!ad.isIndex()) continue;
            this.getIndex(ad).commit(opIt);
        }
        if (this.rowIdxGen.getCustomValue() >= this.persistentCache.length) {
            PersistedObjectImpl[] newPersistentCache = new PersistedObjectImpl[this.rowIdxGen.getCustomValue() + 1];
            System.arraycopy(this.persistentCache, 0, newPersistentCache, 0, this.persistentCache.length);
            this.persistentCache = newPersistentCache;
        }
        RandomAccessFile file = this.getFile();
        opIt.reset();
        while (opIt.hasNext()) {
            PersistedObjectImpl o = (PersistedObjectImpl)opIt.next();
            PersistenceOperationType type = o.getOperation();
            int rowIdx = o.getRowIdx();
            if (type == PersistenceOperationType.INSERT) {
                o.onInsert(this.tmpRow);
                try {
                    file.seek(rowIdx * this.rowLen);
                    file.write(this.tmpRow);
                    this.persistentCache[rowIdx] = o;
                    continue;
                }
                catch (IOException ex) {
                    throw new PersistenceException(ex);
                }
            }
            if (type == PersistenceOperationType.MODIFY) {
                o.onModify(this.tmpRow);
                try {
                    file.seek(rowIdx * this.rowLen);
                    file.write(this.tmpRow);
                    this.persistentCache[rowIdx] = o;
                    continue;
                }
                catch (IOException ex) {
                    throw new PersistenceException(ex);
                }
            }
            if (type != PersistenceOperationType.DELETE) continue;
            o.onDelete();
            this.persistentCache[rowIdx] = null;
        }
        this.txContext.clear();
        this.persistentCache = new PersistedObject[this.persistentCache.length];
    }

    void rollback() {
        Enumeration e = this.txContext.elements();
        while (e.hasMoreElements()) {
            ((PersistedObjectImpl)e.nextElement()).onRollback();
        }
        this.txContext.clear();
        this.persistentCache = new PersistedObject[this.persistentCache.length];
    }

    MeIterator getTxContext() {
        return new MeIteratorHashImpl(this.txContext);
    }

    PersistedObjectImpl getPersistedObjectForChange(String key, PersistenceOperationType op) throws PersistenceException {
        PersistedObjectImpl o = (PersistedObjectImpl)this.txContext.get(key);
        if (o == null) {
            o = op == PersistenceOperationType.INSERT ? this.createPersistedObject(key) : (PersistedObjectImpl)this.get(key);
            this.txContext.put(key, o);
        }
        return o;
    }

    void prepareChange(PersistedObjectImpl o, String key, PersistenceOperationType op) throws PersistenceException {
        if (op != PersistenceOperationType.NOOPER) {
            ++this.operationCounter;
            o.setOperation(op);
            PersistedObjectImpl prevObj = (PersistedObjectImpl)this.txContext.get(key);
            if (prevObj != null) {
                o.mergeWith(prevObj);
            }
            this.txContext.put(key, o);
        }
    }

    PersistedObject get(String key) throws PersistenceException {
        if (key == null) {
            return null;
        }
        PersistedObjectImpl o = (PersistedObjectImpl)this.txContext.get(key);
        if (o != null) {
            if (o.getOperation() != PersistenceOperationType.DELETE && o.getOperation() != PersistenceOperationType.NOOPER) {
                return o;
            }
            return null;
        }
        return this.get(this.primaryIdx.getIdx(key));
    }

    private void verifyReadSize(int size, int required) throws PersistenceException {
        if (size != required) {
            throw new PersistenceException("file " + this.cdes.getClasstype() + " corruptted");
        }
    }

    private PersistedObject get(int rowIdx) throws PersistenceException {
        if (rowIdx == -1) {
            return null;
        }
        PersistedObject o = this.persistentCache[rowIdx];
        if (o != null) {
            return o;
        }
        String key = (String)this.primaryIdx.getKey(rowIdx);
        try {
            RandomAccessFile file = this.getFile();
            file.seek(rowIdx * this.rowLen);
            this.verifyReadSize(file.read(this.tmpRow), this.tmpRow.length);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        byte[] attribs = new byte[this.attribLen];
        byte[] links = new byte[this.linkLen];
        System.arraycopy(this.tmpRow, 0, attribs, 0, this.attribLen);
        System.arraycopy(this.tmpRow, this.attribLen, links, 0, this.linkLen);
        this.persistentCache[rowIdx] = o = PersistedObjectImpl.createForRead(key, this.cdes, this.pset, attribs, links, rowIdx, this.txMan);
        return o;
    }

    Vector get(String[] keys) throws PersistenceException {
        if (keys.length < 1) {
            return new Vector(1);
        }
        Vector<PersistedObject> v = new Vector<PersistedObject>(keys.length);
        int x = 0;
        while (x < keys.length) {
            PersistedObject o = this.get(keys[x]);
            if (o != null) {
                v.addElement(o);
            }
            ++x;
        }
        return v;
    }

    MeIterator get(MeBitSet bitset) throws PersistenceException {
        Vector<PersistedObject> v = new Vector<PersistedObject>();
        int index = bitset.nextSetBit(0);
        while (index != -1) {
            v.addElement(this.get(index));
            index = bitset.nextSetBit(index + 1);
        }
        return new MeIteratorVectorImpl(v);
    }

    MeIterator get(Query query) throws PersistenceException {
        MeIterator meIterator;
        Object perftag = PerformanceLog.methodStarted(this);
        try {
            MeIterator itr_result;
            FileIOQuery fquery = this.fqManager.getFileIOQuery(query);
            fquery.execute(this, this.operationCounter);
            Vector txResult = fquery.getTxResult();
            MeBitSet nonTxResult = fquery.getNonTxResult();
            MeIterator resolvedNonTxResult = this.get(nonTxResult, fquery.getSortOrder(), fquery.getStartIndex(), fquery.getMaxResults());
            meIterator = itr_result = this.combineResults(resolvedNonTxResult, new MeIteratorVectorImpl(txResult), new PersistedObjectComparator(this.cdes, fquery.getSortOrder()));
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            PerformanceLog.methodFinished(perftag, "get(final Query query0)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perftag, "get(final Query query0)");
        return meIterator;
    }

    int getCount(Query query) throws PersistenceException {
        return this.fqManager.getFileIOQuery(query).execute(this, this.operationCounter);
    }

    MeIterator getAll() throws PersistenceException {
        MeBitSet set = this.primaryIdx.getValidRows();
        Vector<PersistedObject> result = new Vector<PersistedObject>();
        int i = set.nextSetBit(0);
        while (i >= 0) {
            String key = (String)this.primaryIdx.getKey(i);
            PersistedObjectImpl o = (PersistedObjectImpl)this.txContext.get(key);
            if (o != null) {
                if (o.getOperation() != PersistenceOperationType.DELETE && o.getOperation() != PersistenceOperationType.NOOPER) {
                    result.addElement(o);
                }
            } else {
                result.addElement(this.get(i));
            }
            i = set.nextSetBit(i + 1);
        }
        Enumeration e = this.txContext.elements();
        while (e.hasMoreElements()) {
            PersistedObjectImpl obj = (PersistedObjectImpl)e.nextElement();
            if (obj.getOperation() != PersistenceOperationType.INSERT) continue;
            result.addElement(obj);
        }
        return new MeIteratorVectorImpl(result);
    }

    boolean contains(String entityKey) throws PersistenceException {
        if (this.txContext.containsKey(entityKey)) {
            PersistenceOperationType type = ((PersistedObjectImpl)this.txContext.get(entityKey)).getOperation();
            return type != PersistenceOperationType.DELETE && type != PersistenceOperationType.NOOPER;
        }
        return this.primaryIdx.getIdx(entityKey) != -1;
    }

    PersistedObjectImpl createPersistedObject(String key) {
        return PersistedObjectImpl.createTransient(key, this.cdes, this.pset, this.txMan);
    }

    MultipleLinkTable getMultipleLinkTable(LinkDescriptor ldes) throws PersistenceException {
        return (MultipleLinkTable)this.multiLinkHash.get(ldes.getName());
    }

    Vector getTxQueryResult(FileIOQuery query) throws PersistenceException {
        Vector<PersistedObject> vector = new Vector<PersistedObject>();
        Condition condition = query.getCondition();
        MeBitSet nonTxResults = query.getNonTxResult();
        Enumeration enumeration = this.txContext.elements();
        while (enumeration.hasMoreElements()) {
            PersistedObject object = (PersistedObject)enumeration.nextElement();
            PersistenceOperationType operationType = object.getOperation();
            if (operationType == PersistenceOperationType.INSERT || operationType == PersistenceOperationType.MODIFY) {
                if (condition != null && !condition.matches(object)) continue;
                vector.addElement(object);
                continue;
            }
            if (operationType != PersistenceOperationType.DELETE || condition != null && !condition.matches(object)) continue;
            nonTxResults.clear(((PersistedObjectImpl)object).getRowIdx());
        }
        return vector;
    }

    MeBitSet getNonTxQueryResult(FileIOQuery query) throws PersistenceException {
        Condition cond = query.getCondition();
        MeBitSet results = new MeBitSet();
        this.search(cond, results);
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MeIterator get(MeBitSet bitset, SortOrder order, int startIndex, int count) throws PersistenceException {
        Object perftag = PerformanceLog.methodStarted(this);
        try {
            MeIteratorVectorImpl meIteratorVectorImpl;
            Object mv;
            Object[] resultset;
            block22: {
                block21: {
                    int size = 0;
                    int i = bitset.nextSetBit(0);
                    while (true) {
                        if (i < 0) {
                            resultset = new MultipleValue[size];
                            if (order == null) {
                                break;
                            }
                            break block21;
                        }
                        ++size;
                        i = bitset.nextSetBit(i + 1);
                    }
                    MeIteratorHashImpl orders = new MeIteratorHashImpl(new Hashtable());
                    int j = 0;
                    int i2 = bitset.nextSetBit(0);
                    while (true) {
                        if (i2 < 0) {
                            MeArrays.sort(resultset, new MultipleValueComparator());
                            break block22;
                        }
                        mv = new MultipleValue(i2);
                        ((MultipleValue)mv).put("key", this.primaryIdx.getKey(i2));
                        resultset[j] = mv;
                        ++j;
                        i2 = bitset.nextSetBit(i2 + 1);
                    }
                }
                Object perftag2 = PerformanceLog.methodStarted(this);
                try {
                    Vector orders = new Vector();
                    this.traversalOrder(order, orders);
                    Object perftag4 = PerformanceLog.methodStarted(this);
                    try {
                        int j = 0;
                        int i = bitset.nextSetBit(0);
                        block10: while (true) {
                            if (i < 0) {
                                MultipleValueComparator mvComparator = new MultipleValueComparator(order);
                                MeArrays.sort(resultset, mvComparator);
                                Object var19_22 = null;
                                break;
                            }
                            MultipleValue mv2 = new MultipleValue(i);
                            Enumeration enumeration = orders.elements();
                            while (true) {
                                if (!enumeration.hasMoreElements()) {
                                    resultset[j] = mv2;
                                    ++j;
                                    i = bitset.nextSetBit(i + 1);
                                    continue block10;
                                }
                                AttributeDescriptor ad = (AttributeDescriptor)enumeration.nextElement();
                                AttributePosition apos = this.pset.getAttributePosition(ad.getName());
                                mv2.put(ad.getName(), this.getKey(i, ad, apos));
                            }
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var19_23 = null;
                        PerformanceLog.methodFinished(perftag4, "sort values");
                        throw throwable;
                    }
                    PerformanceLog.methodFinished(perftag4, "sort values");
                    Object var21_25 = null;
                }
                catch (Throwable throwable) {
                    Object var21_26 = null;
                    PerformanceLog.methodFinished(perftag2, "sort values by orders");
                    throw throwable;
                }
                PerformanceLog.methodFinished(perftag2, "sort values by orders");
            }
            Object perftag3 = PerformanceLog.methodStarted(this);
            try {
                if (startIndex < 0) {
                    startIndex = 0;
                }
                if (count < 0) {
                    count = resultset.length;
                }
                Vector<PersistedObject> v = new Vector<PersistedObject>();
                int i = startIndex;
                while (true) {
                    if (i >= count + startIndex || i >= resultset.length) {
                        meIteratorVectorImpl = new MeIteratorVectorImpl(v);
                        Object var23_28 = null;
                        break;
                    }
                    mv = resultset[i];
                    v.addElement(this.get(((MultipleValue)mv).index));
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var23_29 = null;
                PerformanceLog.methodFinished(perftag3, "get sorted values");
                throw throwable;
            }
            PerformanceLog.methodFinished(perftag3, "get sorted values");
            Object var25_30 = null;
            PerformanceLog.methodFinished(perftag, "get(MeBitSet bitset, SortOrder order, int startIndex, int count)");
            return meIteratorVectorImpl;
        }
        catch (Throwable throwable) {
            Object var25_31 = null;
            PerformanceLog.methodFinished(perftag, "get(MeBitSet bitset, SortOrder order, int startIndex, int count)");
            throw throwable;
        }
    }

    private Object getKey(int rowIdx, AttributeDescriptor ades, AttributePosition apos) throws PersistenceException {
        SecondaryIndex secondaryIdx = this.getSecondaryIndex(ades);
        if (secondaryIdx != null) {
            return secondaryIdx.getKey(rowIdx);
        }
        return this.getFieldValue(rowIdx, apos);
    }

    private void traversalOrder(SortOrder order, Vector result) {
        if (order.isMultiple()) {
            MeIterator itr = ((MultipleSortOrder)order).getSortOrders();
            itr.reset();
            while (itr.hasNext()) {
                SortOrder sub_sortOrder = (SortOrder)itr.next();
                this.traversalOrder(sub_sortOrder, result);
            }
        } else {
            SingleSortOrder singleSortOrder = (SingleSortOrder)order;
            AttributeDescriptor ad = singleSortOrder.getAttributeDescriptor();
            result.addElement(ad);
        }
    }

    private MeIterator combineResults(MeIterator result_io, MeIterator result_trans, MeComparator comparator) throws PersistenceException {
        Hashtable<String, PersistedObject> hash = new Hashtable<String, PersistedObject>();
        if (result_io != null) {
            result_io.reset();
            while (result_io.hasNext()) {
                PersistedObject obj = (PersistedObject)result_io.next();
                hash.put(obj.getEntityKey(), obj);
            }
        }
        Enumeration enumeration = this.txContext.keys();
        while (enumeration.hasMoreElements()) {
            hash.remove(enumeration.nextElement());
        }
        if (result_trans != null) {
            result_trans.reset();
            while (result_trans.hasNext()) {
                PersistedObject obj = (PersistedObject)result_trans.next();
                String key = obj.getEntityKey();
                hash.put(key, obj);
            }
        }
        Object[] resultset = new PersistedObject[hash.size()];
        int i = 0;
        Enumeration enum2 = hash.elements();
        while (enum2.hasMoreElements()) {
            resultset[i] = (PersistedObject)enum2.nextElement();
            ++i;
        }
        MeArrays.sort(resultset, comparator);
        return new MeIteratorArrayImpl(resultset);
    }

    private void search(Condition condition, MeBitSet mask, MeBitSet result, LogicalOperatorType type) throws PersistenceException {
        if (type == null) {
            type = LogicalOperatorType.OR;
        }
        if (condition == null) {
            if (type == LogicalOperatorType.AND) {
                result.and(mask);
            } else {
                result.or(mask);
            }
            return;
        }
        if (!condition.isComposite()) {
            this.search((SingleCondition)condition, mask, result, type);
        } else {
            CompositeCondition compositeCondition = (CompositeCondition)condition;
            MeIterator condition_itr = compositeCondition.getComponents();
            Object[] conditions = new Prioritizable[condition_itr.elementCount()];
            int i = 0;
            while (condition_itr.hasNext()) {
                Prioritizable sub_condition = (Prioritizable)condition_itr.next();
                conditions[i] = sub_condition;
                ++i;
            }
            MeArrays.sort(conditions, PriorityComparator.getInstance());
            LogicalOperatorType sub_type = compositeCondition.getLogicalOperator();
            MeBitSet sub_result = new MeBitSet();
            if (sub_type == LogicalOperatorType.AND) {
                sub_result.or(mask);
            }
            MeBitSet sub_mask = (MeBitSet)mask.clone();
            int i2 = 0;
            while (i2 < conditions.length) {
                Condition sub_condition = (Condition)conditions[i2];
                this.search(sub_condition, sub_mask, sub_result, sub_type);
                if (sub_type == LogicalOperatorType.AND) {
                    sub_mask.and(sub_result);
                } else {
                    sub_mask.andNot(sub_result);
                }
                ++i2;
            }
            if (type == LogicalOperatorType.AND) {
                result.and(sub_result);
            } else {
                result.or(sub_result);
            }
        }
    }

    private void search(SingleCondition condition, MeBitSet mask, MeBitSet result, LogicalOperatorType type) throws PersistenceException {
        AttributeDescriptor ad = condition.getAttributeDescriptor();
        MeBitSet tmp_result = new MeBitSet();
        if (ad.isIndex()) {
            RelationalOperatorType operatorType = condition.getRelationalOperator();
            SecondaryIndex secondaryIndex = this.getSecondaryIndex(ad);
            secondaryIndex.searchNodes(condition.getValue(), mask, tmp_result, operatorType);
        } else {
            int index = mask.nextSetBit(0);
            while (index != -1) {
                if (this.match(index, condition.getValue(), condition.getAttributeDescriptor(), condition.getRelationalOperator())) {
                    tmp_result.set(index);
                }
                index = mask.nextSetBit(index + 1);
            }
        }
        if (type == LogicalOperatorType.OR) {
            result.or(tmp_result);
        } else {
            result.and(tmp_result);
        }
    }

    private byte[] getFieldBytes(int rowIdx, AttributePosition apos) throws PersistenceException {
        if (rowIdx == -1) {
            return null;
        }
        try {
            RandomAccessFile file = this.getFile();
            file.seek(rowIdx * this.rowLen + apos.offset);
            byte[] attribs = new byte[apos.singleByteLen];
            this.verifyReadSize(file.read(attribs), attribs.length);
            return attribs;
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private Object getFieldValue(int rowIdx, AttributePosition apos) throws PersistenceException {
        return apos.toValue(this.getFieldBytes(rowIdx, apos), 0);
    }

    private boolean match(int rowIdx, Object value, AttributeDescriptor ad, RelationalOperatorType type) throws PersistenceException {
        AttributePosition apos = this.pset.getAttributePosition(ad.getName());
        byte[] target_value = this.getFieldBytes(rowIdx, apos);
        if (type == RelationalOperatorType.CONTAINS) {
            return ad.getType().contains(target_value, value);
        }
        if (type == RelationalOperatorType.EQUALS) {
            return ad.getType().equals(target_value, value);
        }
        if (type == RelationalOperatorType.GREATER_THAN) {
            return ad.getType().greaterThan(target_value, value);
        }
        if (type == RelationalOperatorType.LOWER_THAN) {
            return ad.getType().lowerThan(target_value, value);
        }
        if (type == RelationalOperatorType.NOT_EQUALS) {
            return ad.getType().notEqual(target_value, value);
        }
        if (type == RelationalOperatorType.STARTS_WITH) {
            return ad.getType().startWith(target_value, value);
        }
        throw new RuntimeException("Not supported RelationOperatorType!");
    }

    private void processAndWriteRowIndexes(MeIterator opIt) throws PersistenceException {
        try {
            int maxIdx = this.rowIdxGen.getCustomValue();
            opIt.reset();
            while (opIt.hasNext()) {
                PersistedObjectImpl op = (PersistedObjectImpl)opIt.next();
                if (op.getOperation() == PersistenceOperationType.DELETE) {
                    this.rowIdxGen.push(op.getRowIdx());
                    continue;
                }
                if (op.getOperation() == PersistenceOperationType.INSERT) {
                    op.setRowIdx(!this.rowIdxGen.isEmpty() ? this.rowIdxGen.pop() : maxIdx++);
                    continue;
                }
                if (op.getOperation() != PersistenceOperationType.MODIFY) continue;
                int idx = this.primaryIdx.getIdx(op.getEntityKey());
                if (idx < 0) {
                    throw new RuntimeException("inconsistent state");
                }
                op.setRowIdx(idx);
            }
            this.rowIdxGen.setCustomValue(maxIdx);
            this.rowIdxGen.write();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    private void search(Condition condition, MeBitSet result) throws PersistenceException {
        Object perftag = PerformanceLog.methodStarted(this);
        try {
            MeBitSet mask = (MeBitSet)this.primaryIdx.getValidRows().clone();
            this.search(condition, mask, result, null);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            PerformanceLog.methodFinished(perftag, "search(Condition condition, MeBitSet result)");
            throw throwable;
        }
        PerformanceLog.methodFinished(perftag, "search(Condition condition, MeBitSet result)");
    }

    private IndexTree getIndex(AttributeDescriptor attDes) throws PersistenceException {
        if (attDes.isIndex()) {
            int x = 0;
            while (x < this.allIndexes.length) {
                if (this.allIndexes[x] == null) {
                    int xpos = this.cdes.getAttributePosition(attDes.getName());
                    AttributePosition pos = this.pset.getAttributePosition(attDes.getName());
                    this.allIndexes[x] = new SecondaryIndex(this.fileNameBase, attDes, pos, xpos);
                }
                if (this.allIndexes[x].ATT_DES.getName().equals(attDes.getName())) {
                    return this.allIndexes[x];
                }
                ++x;
            }
        }
        return null;
    }

    private SecondaryIndex getSecondaryIndex(AttributeDescriptor attDes) throws PersistenceException {
        IndexTree t = this.getIndex(attDes);
        return t instanceof SecondaryIndex ? (SecondaryIndex)t : null;
    }

    private MultipleLinkTable[] createAllMultipleLinkTables() throws PersistenceException {
        MultipleLinkTable[] multiLink = new MultipleLinkTable[this.pset.getMultipleLinkCnt()];
        LinkDescriptor[] ldes = this.cdes.getLinkDescriptorArray();
        int y = 0;
        int x = 0;
        while (x < ldes.length) {
            if (ldes[x].getMultiplicity() == MultiplicityType.MULTIPLE_VECTOR) {
                multiLink[y] = new MultipleLinkTable(this.fileNameBase, ldes[x], this.pset.LINK_POS[x]);
                this.multiLinkHash.put(ldes[x].getName(), multiLink[y]);
                ++y;
            }
            ++x;
        }
        return multiLink;
    }

    private static class FileIOQueryManager {
        private Hashtable ht = new Hashtable();

        private FileIOQueryManager() {
        }

        public FileIOQuery getFileIOQuery(Query q) {
            FileIOQuery fq = (FileIOQuery)this.ht.get(q);
            if (fq == null) {
                fq = new FileIOQuery(q);
                this.ht.put(q, fq);
            }
            return fq;
        }
    }
}

