/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.me.persist.fileio;

import com.sap.ip.me.api.persist.query.MultipleSortOrder;
import com.sap.ip.me.api.persist.query.SingleSortOrder;
import com.sap.ip.me.api.persist.query.SortOrder;
import com.sap.ip.me.api.services.MeIterator;
import com.sap.ip.me.core.AbstractMeComparator;
import com.sap.ip.me.persist.fileio.MultipleValue;

public final class MultipleValueComparator
extends AbstractMeComparator {
    private final SortOrder sortOrder;
    public static final String DEFAULT_KEY = "key";

    public MultipleValueComparator() {
        this(null);
    }

    public MultipleValueComparator(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int compare(SortOrder sortOrder, Object o1, Object o2) {
        if (sortOrder == null) {
            String s1 = (String)((MultipleValue)o1).get(DEFAULT_KEY);
            String s2 = (String)((MultipleValue)o2).get(DEFAULT_KEY);
            return s1.compareTo(s2);
        }
        if (sortOrder.isMultiple()) {
            int result = 0;
            MeIterator itr = ((MultipleSortOrder)sortOrder).getSortOrders();
            itr.reset();
            while (itr.hasNext()) {
                SortOrder sub_sortOrder = (SortOrder)itr.next();
                result = this.compare(sub_sortOrder, o1, o2);
            }
            return result;
        }
        SingleSortOrder singleSortOrder = (SingleSortOrder)sortOrder;
        String attribute_name = singleSortOrder.getAttributeDescriptor().getName();
        Object c1 = ((MultipleValue)o1).get(attribute_name);
        Object c2 = ((MultipleValue)o2).get(attribute_name);
        return singleSortOrder.isAscending() ? super.compareTo(c2, c1) : super.compareTo(c1, c2);
    }

    public int compare(Object o1, Object o2) {
        return this.compare(this.sortOrder, o1, o2);
    }
}

